/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.StyleSheet;
import org.netbeans.modules.autoupdate.ui.HTMLEditorKitEx;
import org.netbeans.modules.autoupdate.ui.HeaderPanel;
import org.netbeans.modules.autoupdate.ui.UnitTable;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DetailsPanel
extends JTextPane {
    private JScrollPane scrollPane;
    private HeaderPanel header;
    private JLabel title;
    private JButton button;
    private JButton button2;
    private JPanel rightCornerHeader;
    private HyperlinkListener hyperlinkListener;
    private static final RequestProcessor RP = new RequestProcessor(DetailsPanel.class);

    public DetailsPanel() {
        this.initComponents2();
        HTMLEditorKitEx htmlkit = new HTMLEditorKitEx();
        StyleSheet css = htmlkit.getStyleSheet();
        if (css.getStyleSheets() == null) {
            StyleSheet css2 = new StyleSheet();
            Font f = new JList().getFont();
            int size = f.getSize();
            css2.addRule(new StringBuffer("body { font-size: ").append(size).append("; font-family: ").append(f.getName()).append("; }").toString());
            css2.addStyleSheet(css);
            htmlkit.setStyleSheet(css2);
        }
        this.setEditorKit(htmlkit);
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hlevt) {
                if (HyperlinkEvent.EventType.ACTIVATED == hlevt.getEventType() && hlevt.getURL() != null) {
                    Utilities.showURL(hlevt.getURL());
                }
            }
        });
        this.setEditable(false);
        this.setPreferredSize(new Dimension(300, 80));
        RP.post(new Runnable(){

            @Override
            public void run() {
                DetailsPanel.this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DetailsPanel.class, (String)"ACN_DetailsPanel"));
            }
        });
        this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.getScrollPane();
    }

    @Override
    public void removeNotify() {
        this.setEditorKit(new StyledEditorKit());
        if (this.hyperlinkListener != null) {
            this.removeHyperlinkListener(this.hyperlinkListener);
        }
        this.scrollPane = null;
        super.removeNotify();
    }

    JScrollPane getScrollPane() {
        Container gp;
        Container p;
        if (this.scrollPane == null && (p = this.getParent()) instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            this.scrollPane = (JScrollPane)gp;
        }
        return this.scrollPane;
    }

    public void setTitle(String value) {
        this.getScrollPane().setColumnHeaderView(value != null ? this.header : null);
        this.getScrollPane().setCorner("UPPER_RIGHT_CORNER", value != null ? this.rightCornerHeader : null);
        if (value != null) {
            this.title.setText("<html><h3>" + value + "</h3></html>");
        }
    }

    public void setActionListener(Action action) {
        this.button.setVisible(action != null);
        this.button.setEnabled(action != null);
        if (action != null) {
            this.button.setAction(action);
            this.button.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailsPanel.class, (String)"ACN_DetailsPanel_Button", (Object)this.button.getName()));
        }
    }

    public void setActionListener2(Action action) {
        this.button2.setVisible(action != null);
        this.button2.setEnabled(action != null);
        if (action != null) {
            this.button2.setAction(action);
            this.button2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailsPanel.class, (String)"ACN_DetailsPanel_Button", (Object)this.button2.getName()));
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.title.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    JEditorPane getDetails() {
        return this;
    }

    @Override
    public void setText(String t) {
        super.setText(t);
        this.validate();
    }

    HeaderPanel getHeader() {
        return this.header;
    }

    private void initComponents2() {
        this.header = new HeaderPanel();
        this.title = this.header.getTitle();
        this.button = this.header.getButton();
        this.button2 = this.header.getButton2();
        MatteBorder outsideBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray);
        Border insideBorder = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(outsideBorder, insideBorder);
        this.header.setBorder(compoundBorder);
        this.button.setVisible(false);
        this.button2.setVisible(false);
        this.rightCornerHeader = new JPanel();
        this.rightCornerHeader.setBorder(compoundBorder);
        Color headerBgColor = UnitTable.getDarkerColor(this.getBackground());
        this.header.setBackground(headerBgColor);
        if (this.button != null) {
            this.button.setOpaque(false);
        }
        if (this.button2 != null) {
            this.button2.setOpaque(false);
        }
        this.rightCornerHeader.setBackground(headerBgColor);
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 0, 0));
    }
}

