/*
 * Decompiled with CFR 0.152.
 */
package ancestris.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class EventUsage {
    public static String[] mainEventsList = new String[]{"BIRT", "CHR", "MARR", "DEAT", "BURI", "OCCU", "RESI", "RETI", "DIV"};
    public static String[] otherEventsList = new String[]{"BAPM", "BLES", "ADOP", "FCOM", "BARM", "BASM", "CONF", "NATI", "RELI", "CAST", "CHRA", "GRAD", "ORDN", "ENGA", "MARB", "MARL", "MARS", "MARC", "DIVF", "DIV", "ANUL", "EMIG", "IMMI", "NATU", "TITL", "SSN", "IDNO", "DSCR", "EDUC", "CENS", "PROP", "EVEN", "FACT", "NCHI", "NMR", "PROB", "WILL", "CREM", "RESI"};
    private int order = 0;
    private String type = "";

    public static void init(Map<String, EventUsage> eventUsages) {
        eventUsages.put("INDI", new EventUsage(0, "INDI"));
        eventUsages.put("BIRT", new EventUsage(1, "INDI"));
        eventUsages.put("CHR", new EventUsage(2, "INDI"));
        eventUsages.put("BAPM", new EventUsage(3, "INDI"));
        eventUsages.put("BLES", new EventUsage(4, "INDI"));
        eventUsages.put("ADOP", new EventUsage(5, "INDI"));
        eventUsages.put("FCOM", new EventUsage(6, "INDI"));
        eventUsages.put("BARM", new EventUsage(7, "INDI"));
        eventUsages.put("BASM", new EventUsage(8, "INDI"));
        eventUsages.put("CONF", new EventUsage(9, "INDI"));
        eventUsages.put("NATI", new EventUsage(10, "INDI"));
        eventUsages.put("RELI", new EventUsage(11, "INDI"));
        eventUsages.put("CAST", new EventUsage(12, "INDI"));
        eventUsages.put("CHRA", new EventUsage(13, "INDI"));
        eventUsages.put("GRAD", new EventUsage(15, "INDI"));
        eventUsages.put("ORDN", new EventUsage(16, "INDI"));
        eventUsages.put("ENGA", new EventUsage(20, "FAM"));
        eventUsages.put("MARB", new EventUsage(21, "FAM"));
        eventUsages.put("MARL", new EventUsage(22, "FAM"));
        eventUsages.put("MARS", new EventUsage(23, "FAM"));
        eventUsages.put("MARC", new EventUsage(24, "FAM"));
        eventUsages.put("MARR", new EventUsage(25, "FAM"));
        eventUsages.put("OCCU", new EventUsage(30, "INDI"));
        eventUsages.put("RESI", new EventUsage(31, "ALL"));
        eventUsages.put("DIVF", new EventUsage(40, "FAM"));
        eventUsages.put("DIV", new EventUsage(41, "FAM"));
        eventUsages.put("ANUL", new EventUsage(42, "FAM"));
        eventUsages.put("EMIG", new EventUsage(50, "INDI"));
        eventUsages.put("IMMI", new EventUsage(51, "INDI"));
        eventUsages.put("NATU", new EventUsage(52, "INDI"));
        eventUsages.put("TITL", new EventUsage(53, "INDI"));
        eventUsages.put("SSN", new EventUsage(54, "INDI"));
        eventUsages.put("IDNO", new EventUsage(55, "INDI"));
        eventUsages.put("DSCR", new EventUsage(56, "INDI"));
        eventUsages.put("EDUC", new EventUsage(57, "INDI"));
        eventUsages.put("CENS", new EventUsage(58, "ALL"));
        eventUsages.put("PROP", new EventUsage(59, "INDI"));
        eventUsages.put("EVEN", new EventUsage(60, "ALL"));
        eventUsages.put("FACT", new EventUsage(61, "ALL"));
        eventUsages.put("NCHI", new EventUsage(62, "ALL"));
        eventUsages.put("NMR", new EventUsage(63, "INDI"));
        eventUsages.put("RETI", new EventUsage(70, "INDI"));
        eventUsages.put("PROB", new EventUsage(80, "INDI"));
        eventUsages.put("WILL", new EventUsage(81, "INDI"));
        eventUsages.put("DEAT", new EventUsage(97, "INDI"));
        eventUsages.put("BURI", new EventUsage(98, "INDI"));
        eventUsages.put("CREM", new EventUsage(99, "INDI"));
        eventUsages.put("NO", new EventUsage(200, "ALL"));
    }

    public static String[] getTags(Map<String, EventUsage> eventUsages, String type) {
        ArrayList<String> ret = new ArrayList<String>();
        Set<String> keys = eventUsages.keySet();
        for (String key : keys) {
            EventUsage eu = eventUsages.get(key);
            if (!eu.getType().equals(type) && !eu.getType().equals("ALL")) continue;
            ret.add(key);
        }
        return ret.toArray(new String[ret.size()]);
    }

    public static boolean isEventTag(String tag) {
        HashMap<String, EventUsage> eventUsages = new HashMap<String, EventUsage>();
        EventUsage.init(eventUsages);
        Set keys = eventUsages.keySet();
        return keys.contains(tag);
    }

    private EventUsage(int order, String type) {
        this.order = order;
        this.type = type;
    }

    public int getOrder() {
        return this.order;
    }

    public String getType() {
        return this.type;
    }
}

