/*
 * Decompiled with CFR 0.152.
 */
package genj.chart;

import genj.chart.IndexedSeries;
import genj.chart.XYSeries;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.NumberFormat;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;

public class Chart
extends JPanel {
    private void init(String title, Plot plot, boolean legend) {
        this.setLayout(new BorderLayout());
        ChartPanel panel = new ChartPanel(new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, plot, legend));
        panel.setDomainZoomable(true);
        panel.setRangeZoomable(true);
        this.add((Component)panel, "Center");
    }

    public Chart(String title, String labelAxisX, String labelAxisY, IndexedSeries[] series, NumberFormat formatX, NumberFormat formatY, boolean stacked) {
        NumberAxis xAxis = new NumberAxis(labelAxisX);
        xAxis.setAutoRangeIncludesZero(false);
        xAxis.setNumberFormatOverride(formatX);
        NumberAxis yAxis = new NumberAxis(labelAxisY);
        yAxis.setNumberFormatOverride(formatY);
        yAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        StackedXYAreaRenderer2 renderer = stacked ? new StackedXYAreaRenderer2() : new XYAreaRenderer();
        XYPlot plot = new XYPlot((XYDataset)IndexedSeries.asTableXYDataset(series), (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        this.init(title, (Plot)plot, true);
    }

    public Chart(String title, String labelAxisX, String labelAxisY, XYSeries[] series, NumberFormat format, boolean shapes) {
        NumberAxis xAxis = new NumberAxis(labelAxisX);
        xAxis.setAutoRangeIncludesZero(false);
        NumberAxis yAxis = new NumberAxis(labelAxisY);
        yAxis.setNumberFormatOverride(format);
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(shapes ? 3 : 2);
        renderer.setBaseStroke((Stroke)new BasicStroke(3.0f));
        ((AbstractRenderer)renderer).setAutoPopulateSeriesStroke(false);
        XYPlot plot = new XYPlot(XYSeries.toXYDataset(series), (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        this.init(title, (Plot)plot, true);
    }

    public Chart(String title, IndexedSeries series, String[] categories, boolean legend) {
        PiePlot plot = new PiePlot(IndexedSeries.asPieDataset(series, categories));
        plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0} = {1}"));
        plot.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 10.0));
        this.init(title, (Plot)plot, legend);
    }

    public Chart(String title, String labelCatAxis, IndexedSeries[] series, String[] categories, NumberFormat format, boolean isStacked, boolean isVertical, Color manColor, Color womanColor, boolean shadow, boolean outline, boolean embossed) {
        CategoryAxis categoryAxis = new CategoryAxis(labelCatAxis);
        NumberAxis valueAxis = new NumberAxis();
        valueAxis.setNumberFormatOverride(format);
        valueAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        Object renderer = isStacked ? new StackedBarRenderer() : new BarRenderer();
        renderer.setSeriesPaint(0, (Paint)manColor);
        renderer.setSeriesPaint(1, (Paint)womanColor);
        renderer.setShadowVisible(shadow);
        renderer.setShadowXOffset(4.0);
        renderer.setShadowYOffset(4.0);
        renderer.setDrawBarOutline(outline);
        if (!embossed) {
            renderer.setBarPainter((BarPainter)new StandardBarPainter());
        }
        CategoryPlot plot = new CategoryPlot(IndexedSeries.asCategoryDataset(series, categories), categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(!isVertical ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL);
        this.init(title, (Plot)plot, true);
    }
}

