/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Property;
import genj.gedcom.PropertyChoiceValue;
import genj.gedcom.values.EnumOperations;

public class PropertyChoiceEnum
extends PropertyChoiceValue {
    protected Class LOCALENUM = null;
    protected String keyVals = "";
    protected Enum[] values = null;
    protected String defaultValue = "";
    protected boolean isEditable = true;

    public PropertyChoiceEnum(String tag) {
        super(tag);
        this.assertTag(tag);
    }

    @Override
    protected String getKey() {
        return this.keyVals;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    @Override
    public String getDisplayValue() {
        return EnumOperations.getDisplayValue(Enum.valueOf(this.LOCALENUM, this.getValue()), this.keyVals);
    }

    @Override
    public void setValue(String displayValue) {
        String code = EnumOperations.getCodeValueFromString(displayValue, this.values, this.defaultValue);
        super.setValue(code);
    }

    @Override
    public boolean isValid() {
        return EnumOperations.getCodeChoices(this.values).contains(super.getValue());
    }

    @Override
    protected boolean referenceDisplayValue(String oldCode, String newCode) {
        super.referenceDisplayValue(EnumOperations.getDisplayValueFromCode(oldCode, this.values), EnumOperations.getDisplayValueFromCode(newCode, this.values));
        return true;
    }

    protected void setPhraseValue(Property parent, String displayValue) {
        if (this.getParent() == null) {
            return;
        }
        String code = EnumOperations.getCodeValueFromString(displayValue, this.values, this.defaultValue);
        if (!code.equals(displayValue) && code.equals(this.defaultValue) && !displayValue.equals(EnumOperations.getDisplayValueFromCode(code, this.values))) {
            Property prop;
            Object phraseTag = "PHRASE";
            if (!parent.getMetaProperty().allows((String)phraseTag)) {
                phraseTag = "_" + (String)phraseTag;
            }
            if ((prop = parent.getProperty((String)phraseTag)) == null) {
                prop = parent.addProperty((String)phraseTag, "");
            }
            prop.setValue(displayValue);
        }
    }

    public String getPhraseDisplayValue() {
        String phrase;
        if (this.getValue().equals(this.defaultValue) && !(phrase = this.getPhrase()).isEmpty()) {
            return phrase;
        }
        return this.getDisplayValue();
    }

    public String getPhrase() {
        Property phrase;
        Object phraseTag = "PHRASE";
        if (!this.getParent().getMetaProperty().allows((String)phraseTag)) {
            phraseTag = "_" + (String)phraseTag;
        }
        if ((phrase = this.getProperty((String)phraseTag)) != null) {
            return phrase.getValue().trim();
        }
        return "";
    }

    public void alignPhrase() {
        Property phrase;
        String code = this.getValue();
        if (!code.equals(this.defaultValue) && (phrase = this.getProperty("PHRASE")) != null) {
            this.delProperty(phrase);
        }
    }
}

