/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.crypto.Enigma;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertySimpleValue;
import genj.util.ReferenceSet;
import java.util.ArrayList;
import java.util.List;

public class PropertyChoiceValue
extends PropertySimpleValue {
    public PropertyChoiceValue(String tag) {
        super(tag);
    }

    protected String getKey() {
        Object key = this.getTag();
        if ("EVEN".equals(key) || "TYPE".equals(key)) {
            key = this.getParent().getTag() + "-" + (String)key;
        }
        return key;
    }

    protected boolean remember(String oldValue, String newValue) {
        Gedcom gedcom = this.getGedcom();
        if (this.isTransient || gedcom == null || this.getParent() == null) {
            return false;
        }
        newValue = newValue.intern();
        if (Enigma.isEncrypted(oldValue)) {
            oldValue = "";
        }
        if (Enigma.isEncrypted(newValue)) {
            newValue = "";
        }
        return this.referenceDisplayValue(oldValue, newValue);
    }

    protected boolean referenceDisplayValue(String oldValue, String newValue) {
        Gedcom gedcom = this.getGedcom();
        ReferenceSet<String, Property> refSet = gedcom.getReferenceSet(this.getKey());
        if (oldValue.length() > 0) {
            refSet.remove(oldValue, this);
        }
        if (newValue.length() > 0) {
            refSet.add(newValue, this);
        }
        return true;
    }

    public String[] getChoices(boolean sort) {
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            return new String[0];
        }
        return PropertyChoiceValue.getChoices(gedcom, this.getKey(), sort);
    }

    public static String[] getChoices(Gedcom gedcom, String key, boolean sort) {
        List<String> choices = gedcom.getReferenceSet(key).getKeys(sort ? gedcom.getCollator() : null);
        return choices.toArray(new String[choices.size()]);
    }

    public static Property[] getSameChoices(Gedcom gedcom, String key, boolean sort) {
        ReferenceSet<String, Property> references = gedcom.getReferenceSet(key);
        List<String> choices = references.getKeys(sort ? gedcom.getCollator() : null);
        ArrayList<Property> result = new ArrayList<Property>(choices.size());
        choices.forEach(choice -> result.addAll(references.getReferences((String)choice)));
        return Property.toArray(result);
    }

    public Property[] getSameChoices() {
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            return new Property[0];
        }
        ReferenceSet<String, Property> refSet = gedcom.getReferenceSet(this.getKey());
        return PropertyChoiceValue.toArray(refSet.getReferences(super.getValue()));
    }

    @Override
    public void setValue(String value) {
        this.setValueInternal(value.intern());
    }

    public void setValue(String value, boolean global) {
        if (global) {
            Property[] others;
            for (Property other : others = this.getSameChoices()) {
                if (!(other instanceof PropertyChoiceValue) || other == this) continue;
                ((PropertyChoiceValue)other).setValue(value);
            }
        }
        this.setValue(value);
    }

    private void setValueInternal(String value) {
        this.remember(super.getValue(), value);
        super.setValue(value);
    }

    @Override
    void afterAddNotify() {
        super.afterAddNotify();
        this.remember("", super.getValue());
    }

    @Override
    void beforeDelNotify() {
        this.remember(super.getValue(), "");
        super.beforeDelNotify();
    }
}

