/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.util.Collections;
import java.util.EventObject;
import java.util.Set;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;

public final class FileStatusEvent
extends EventObject {
    static final long serialVersionUID = -6428208118782405291L;
    private Set<? extends FileObject> files;
    private boolean icon;
    private boolean name;

    public FileStatusEvent(FileSystem fs, Set<? extends FileObject> files, boolean icon, boolean name) {
        super(fs);
        this.files = files;
        this.icon = icon;
        this.name = name;
    }

    public FileStatusEvent(FileSystem fs, FileObject file, boolean icon, boolean name) {
        this(fs, Collections.singleton(file), icon, name);
    }

    public FileStatusEvent(FileSystem fs, boolean icon, boolean name) {
        this(fs, (Set<? extends FileObject>)null, icon, name);
    }

    public FileSystem getFileSystem() {
        return (FileSystem)this.getSource();
    }

    public boolean isNameChange() {
        return this.name;
    }

    public boolean isIconChange() {
        return this.icon;
    }

    public boolean hasChanged(FileObject file) {
        if (this.files == null) {
            try {
                return file.getFileSystem() == this.getSource();
            }
            catch (FileStateInvalidException ex) {
                return false;
            }
        }
        return this.files.contains(file);
    }
}

