/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.gedcomconversion;

import ancestris.modules.editors.gedcomconversion.GedcomFiveConverter;
import ancestris.modules.editors.gedcomconversion.GedcomSevenConverter;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.Grammar;
import javax.swing.SwingWorker;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class GedcomVersionConverter
extends SwingWorker<Void, Void> {
    protected final Gedcom gedcom;
    protected Grammar fromGrammar = null;
    protected Grammar toGrammar = null;
    protected boolean upgrade = false;
    protected boolean isGedcom7 = false;
    private int nbIterations;
    private int progress;
    private String stateNameDots;

    public GedcomVersionConverter(Gedcom gedcom, String fromGrammar, String toGrammar) {
        this.gedcom = gedcom;
        if (fromGrammar.equals("5.5") && toGrammar.equals("5.5.1")) {
            this.fromGrammar = Grammar.V55;
            this.toGrammar = Grammar.V551;
            this.upgrade = true;
            this.isGedcom7 = false;
        } else if (fromGrammar.equals("5.5.1") && toGrammar.equals("5.5")) {
            this.fromGrammar = Grammar.V551;
            this.toGrammar = Grammar.V55;
            this.upgrade = false;
            this.isGedcom7 = false;
        } else if (fromGrammar.equals("5.5.1") && toGrammar.equals("7.0.13")) {
            this.toGrammar = Grammar.V70;
            this.fromGrammar = Grammar.V551;
            this.upgrade = true;
            this.isGedcom7 = true;
        } else if (fromGrammar.equals("7.0.13") && toGrammar.equals("5.5.1")) {
            this.toGrammar = Grammar.V551;
            this.fromGrammar = Grammar.V70;
            this.upgrade = false;
            this.isGedcom7 = true;
        }
    }

    public void convert() {
        Runnable converter = null;
        this.stateNameDots = "..";
        if (!this.isGedcom7) {
            converter = new GedcomFiveConverter(this);
        } else if (this.isGedcom7) {
            converter = new GedcomSevenConverter(this);
        }
        try {
            converter.run();
        }
        catch (Exception ex) {
            this.firePropertyChange("exception", "", ex.getLocalizedMessage());
            Exceptions.printStackTrace((Throwable)ex);
        }
        Context context = (Context)Utilities.actionsGlobalContext().lookup(Context.class);
        if (context != null) {
            SelectionDispatcher.fireSelection(null, (Context)context);
        }
    }

    protected int setNextStepCounters(int nextInterval, int percentageFrom, int percentageTo, String step) {
        if (percentageFrom == percentageTo) {
            return 0;
        }
        this.nbIterations = nextInterval * 100 / (percentageTo - percentageFrom);
        ++this.nbIterations;
        return percentageFrom * this.nbIterations / 100;
    }

    public void notifyProgress(int counter, String stateName) {
        int oldProgress = this.progress;
        this.progress = counter * 100 / this.nbIterations;
        if (this.progress > oldProgress) {
            this.firePropertyChange("stateName", "", stateName + this.stateNameDots + " (" + Integer.toString(Math.min(this.progress, 100)) + "%)");
            this.stateNameDots = this.stateNameDots + ".";
        }
    }

    @Override
    protected Void doInBackground() throws Exception {
        return null;
    }
}

