/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.merge;

import ancestris.gedcom.GedcomDirectory;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Source;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.openide.util.NbBundle;

public class RecordSourceConfigDialog
extends JDialog {
    Source result = null;
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JComboBox<Gedcom> jComboBoxGedcom;
    private JComboBox<Source> jComboBoxSources;
    private JLabel jLabelFileLabel;
    private JLabel jLabelFileName;
    private JLabel jLabelSelectGedcom;
    private JLabel jLabelSelectSource;
    private JPanel jPanelButton;
    private JPanel sourcePanel;

    public static Source show(Frame parent, String fileName, String sourceTitle) {
        RecordSourceConfigDialog dialog = new RecordSourceConfigDialog(parent, fileName, sourceTitle, null);
        dialog.setVisible(true);
        return dialog.result;
    }

    public static Source show(Frame parent, String fileName, String sourceTitle, Gedcom gedcom) {
        RecordSourceConfigDialog dialog = new RecordSourceConfigDialog(parent, fileName, sourceTitle, gedcom);
        dialog.setVisible(true);
        return dialog.result;
    }

    private RecordSourceConfigDialog(Frame parent, String fileName, String sourceTitle, Gedcom gedcom) {
        super(parent, true);
        Gedcom[] gedcoms;
        this.setTitle(NbBundle.getMessage(RecordSourceConfigDialog.class, (String)"RecordSourceConfigDialog.sourcePanel.border.title"));
        this.initComponents();
        this.setModal(true);
        this.setLocationRelativeTo(parent);
        this.jLabelFileName.setText(fileName);
        this.jComboBoxGedcom.setEditor(new MyEditor());
        this.jComboBoxGedcom.addItemListener(arg0 -> {
            Gedcom gedcom1 = (Gedcom)arg0.getItem();
            Entity[] entities = gedcom1.getEntities("SOUR", "SOUR:TITL");
            ArrayList<Source> sources = new ArrayList<Source>();
            for (Entity entity : entities) {
                if (!(entity instanceof Source) || ((Source)entity).getTitle().isEmpty()) continue;
                sources.add((Source)entity);
            }
            this.jComboBoxSources.setModel(new DefaultComboBoxModel<Source>((Source[])sources.toArray(Source[]::new)));
        });
        this.jComboBoxSources.setEditor(new MyEditor());
        if (gedcom == null) {
            List contexts = GedcomDirectory.getDefault().getContexts();
            gedcoms = new Gedcom[contexts.size()];
            for (int i = 0; i < contexts.size(); ++i) {
                gedcoms[i] = ((Context)contexts.get(i)).getGedcom();
            }
            if (gedcoms.length > 0) {
                gedcom = GedcomDirectory.getDefault().getDefaultContext().getGedcom();
            }
        } else {
            gedcoms = new Gedcom[]{gedcom};
        }
        if (gedcom != null) {
            this.jComboBoxGedcom.setModel(new DefaultComboBoxModel<Gedcom>(gedcoms));
            Entity[] entities = gedcom.getEntities("SOUR", "SOUR:TITL");
            ArrayList<Source> sources = new ArrayList<Source>();
            for (Entity entity : entities) {
                if (!(entity instanceof Source) || ((Source)entity).getTitle().isEmpty()) continue;
                sources.add((Source)entity);
            }
            this.jComboBoxSources.setModel(new DefaultComboBoxModel<Source>((Source[])sources.toArray(Source[]::new)));
            if (!sourceTitle.isEmpty()) {
                for (Entity entity : sources) {
                    if (!((Source)entity).getTitle().equals(sourceTitle)) continue;
                    this.jComboBoxSources.getModel().setSelectedItem(entity);
                    break;
                }
            }
        }
    }

    private void initComponents() {
        this.sourcePanel = new JPanel();
        this.jLabelFileLabel = new JLabel();
        this.jLabelFileName = new JLabel();
        this.jLabelSelectGedcom = new JLabel();
        this.jComboBoxGedcom = new JComboBox();
        this.jLabelSelectSource = new JLabel();
        this.jComboBoxSources = new JComboBox();
        this.jPanelButton = new JPanel();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.sourcePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), "", 2, 0));
        this.jLabelFileLabel.setText(NbBundle.getMessage(RecordSourceConfigDialog.class, (String)"RecordSourceConfigDialog.jLabelFileLabel.text"));
        this.jLabelFileName.setFont(this.jLabelFileName.getFont().deriveFont(this.jLabelFileName.getFont().getStyle() | 1));
        this.jLabelFileName.setBorder(null);
        this.jLabelFileName.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jLabelFileName.setMinimumSize(new Dimension(60, 18));
        this.jLabelFileName.setName("");
        this.jLabelFileName.setPreferredSize(new Dimension(80, 24));
        this.jLabelFileName.setRequestFocusEnabled(false);
        this.jLabelSelectGedcom.setText(NbBundle.getMessage(RecordSourceConfigDialog.class, (String)"RecordSourceConfigDialog.jLabelSelectGedcom.text"));
        this.jLabelSelectSource.setText(NbBundle.getMessage(RecordSourceConfigDialog.class, (String)"RecordSourceConfigDialog.jLabelSelectSource.text"));
        GroupLayout sourcePanelLayout = new GroupLayout(this.sourcePanel);
        this.sourcePanel.setLayout(sourcePanelLayout);
        sourcePanelLayout.setHorizontalGroup(sourcePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, sourcePanelLayout.createSequentialGroup().addContainerGap().addGroup(sourcePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jComboBoxSources, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxGedcom, 0, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, sourcePanelLayout.createSequentialGroup().addGroup(sourcePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelSelectGedcom, GroupLayout.Alignment.LEADING).addComponent(this.jLabelSelectSource, GroupLayout.Alignment.LEADING)).addGap(0, 260, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, sourcePanelLayout.createSequentialGroup().addComponent(this.jLabelFileLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelFileName, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        sourcePanelLayout.setVerticalGroup(sourcePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sourcePanelLayout.createSequentialGroup().addContainerGap().addGroup(sourcePanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabelFileName, -2, -1, -2).addComponent(this.jLabelFileLabel)).addGap(18, 18, 18).addComponent(this.jLabelSelectGedcom).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxGedcom, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelSelectSource).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxSources, -2, -1, -2).addContainerGap()));
        this.getContentPane().add((Component)this.sourcePanel, "Center");
        this.jButtonOk.setText(NbBundle.getMessage(RecordSourceConfigDialog.class, (String)"RecordSourceConfigDialog.jButtonOk.text"));
        this.jButtonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RecordSourceConfigDialog.this.jButtonOkActionPerformed(evt);
            }
        });
        this.jPanelButton.add(this.jButtonOk);
        this.jButtonCancel.setText(NbBundle.getMessage(RecordSourceConfigDialog.class, (String)"RecordSourceConfigDialog.jButtonCancel.text"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RecordSourceConfigDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanelButton.add(this.jButtonCancel);
        this.getContentPane().add((Component)this.jPanelButton, "South");
        this.pack();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        if (this.jComboBoxSources.getSelectedIndex() != -1) {
            this.result = (Source)this.jComboBoxSources.getModel().getElementAt(this.jComboBoxSources.getSelectedIndex());
        }
        this.dispose();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    static class MyEditor
    extends BasicComboBoxEditor {
        JScrollPane scroller = new JScrollPane();

        public MyEditor() {
            this.scroller.setViewportView(this.editor);
            this.scroller.setHorizontalScrollBarPolicy(30);
        }

        @Override
        public Component getEditorComponent() {
            return this.scroller;
        }

        @Override
        protected JTextField createEditorComponent() {
            JTextField editorTemp = new JTextField();
            editorTemp.setBorder(null);
            editorTemp.setEditable(false);
            return editorTemp;
        }
    }
}

