/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.merge;

import ancestris.modules.releve.merge.MergeOption;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Source;
import genj.util.swing.ChoiceWidget;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SourceChooser
extends JPanel {
    private boolean isBusy = true;
    private List<Source> sources = new ArrayList<Source>();
    private ButtonGroup buttonGroup1;
    private JRadioButton existingSourceRadioButton;
    private JLabel message;
    private JRadioButton newSourceRadioButton;
    private JLabel noteLabel;
    private JTextField sourceTitleTextField;
    private ChoiceWidget sourcesChoiceWidget;

    public SourceChooser(String sourceTitle, Source selectedSource, Gedcom gedcom) {
        this.initComponents();
        this.sourceTitleTextField.setText(sourceTitle);
        if (gedcom != null) {
            Entity[] entities = gedcom.getEntities("SOUR", "SOUR:TITL");
            for (Entity entity : entities) {
                if (!(entity instanceof Source) || ((Source)entity).getTitle().isEmpty()) continue;
                this.sources.add((Source)entity);
            }
            this.sourcesChoiceWidget.setIgnoreCase(true);
            this.sourcesChoiceWidget.setEditable(true);
            this.sourcesChoiceWidget.setValues(this.sources);
            this.sourcesChoiceWidget.setAutoFilter(true);
            this.sourcesChoiceWidget.setDefaultUpdater();
            if (selectedSource != null) {
                this.sourcesChoiceWidget.setSelectedItem((Object)selectedSource);
                this.existingSourceRadioButton.setSelected(true);
            } else {
                this.newSourceRadioButton.setSelected(true);
                if (!sourceTitle.isEmpty()) {
                    for (Source source : this.sources) {
                        if (!source.getTitle().equals(sourceTitle)) continue;
                        this.sourcesChoiceWidget.setSelectedItem((Object)source);
                        break;
                    }
                }
            }
        }
        this.isBusy = false;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.message = new JLabel();
        this.newSourceRadioButton = new JRadioButton();
        this.existingSourceRadioButton = new JRadioButton();
        this.sourceTitleTextField = new JTextField();
        this.sourcesChoiceWidget = new ChoiceWidget();
        this.noteLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.message, (String)NbBundle.getMessage(SourceChooser.class, (String)"SourceChooser.message.text"));
        this.buttonGroup1.add(this.newSourceRadioButton);
        this.newSourceRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.newSourceRadioButton, (String)NbBundle.getMessage(SourceChooser.class, (String)"SourceChooser.newSourceRadioButton.text"));
        this.buttonGroup1.add(this.existingSourceRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.existingSourceRadioButton, (String)NbBundle.getMessage(SourceChooser.class, (String)"SourceChooser.existingSourceRadioButton.text"));
        this.sourceTitleTextField.setEditable(false);
        this.sourceTitleTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SourceChooser.this.sourceTitleTextFieldFocusGained(evt);
            }
        });
        this.sourcesChoiceWidget.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SourceChooser.this.sourcesChoiceWidgetItemStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.noteLabel, (String)NbBundle.getMessage(SourceChooser.class, (String)(MergeOption.getSourceScopeCity() ? "SourceChooser.noteLabel.text.city" : "SourceChooser.noteLabel.text.record")));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.message, -1, 394, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.newSourceRadioButton).addComponent(this.existingSourceRadioButton)).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.sourcesChoiceWidget, -1, -1, Short.MAX_VALUE).addComponent(this.sourceTitleTextField))).addGroup(layout.createSequentialGroup().addComponent(this.noteLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.message, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.newSourceRadioButton).addComponent(this.sourceTitleTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.existingSourceRadioButton).addComponent((Component)this.sourcesChoiceWidget, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.noteLabel).addContainerGap(12, Short.MAX_VALUE)));
    }

    private void sourceTitleTextFieldFocusGained(FocusEvent evt) {
        if (!this.isBusy) {
            this.newSourceRadioButton.setSelected(true);
        }
    }

    private void sourcesChoiceWidgetItemStateChanged(ItemEvent evt) {
        if (!this.isBusy && evt.getStateChange() == 1) {
            this.existingSourceRadioButton.setSelected(true);
        }
    }

    public boolean isNew() {
        return this.newSourceRadioButton.isSelected();
    }

    public String getNewSourceTitle() {
        return this.sourceTitleTextField.getText();
    }

    public Source getSource() {
        return (Source)this.sourcesChoiceWidget.getSelectedItem();
    }
}

