/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.searchdupes;

import ancestris.modules.gedcom.matchers.EntityMatcher;
import ancestris.modules.gedcom.searchdupes.DuplicatesFinder;
import ancestris.modules.gedcom.searchdupes.DuplicatesResults;
import ancestris.modules.gedcom.searchdupes.NonDuplicates;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.PotentialMatch;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.AbstractNote;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomMetaListener;
import genj.gedcom.Property;
import genj.gedcom.UnitOfWork;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class NonDupManagerPanel
extends JPanel {
    private Gedcom gedcom;
    private Object[][] data;
    private String[] headers;
    private final DefaultTableModel model;
    private GedcomMetaListener listener;
    private JButton calcScoreButton;
    private JButton deleteButton;
    private JScrollPane jScrollPane;
    private JTable jTable;

    public NonDupManagerPanel(Gedcom gedcom) {
        this.gedcom = gedcom;
        this.resetData();
        this.headers = new String[]{NbBundle.getMessage(NonDupManagerPanel.class, (String)"nonDupTableCol1"), NbBundle.getMessage(NonDupManagerPanel.class, (String)"nonDupTableCol2"), NbBundle.getMessage(NonDupManagerPanel.class, (String)"nonDupTableCol3")};
        this.model = new DefaultTableModel(this.data, this.headers){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Entity.class, Entity.class, String.class};
                this.canEdit = new boolean[]{false, false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        };
        this.initComponents();
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.jTable.getModel());
        this.jTable.setRowSorter(sorter);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        sortKeys.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
        sorter.setSortKeys(sortKeys);
        this.resetColumns();
        this.deleteButton.setEnabled(this.jTable.getSelectedRow() > -1);
        this.calcScoreButton.setEnabled(this.jTable.getSelectedRow() > -1);
        this.jTable.getSelectionModel().addListSelectionListener(e -> {
            this.deleteButton.setEnabled(this.jTable.getSelectedRow() > -1);
            this.calcScoreButton.setEnabled(this.jTable.getSelectedRow() > -1);
        });
        this.addNoteListener();
        this.jTable.setAutoCreateColumnsFromModel(false);
    }

    private void resetData() {
        TreeMap<String, String> list = NonDuplicates.getList(this.gedcom);
        this.data = new Object[list.size()][3];
        int row = 0;
        for (String key : list.keySet()) {
            int i = key.indexOf("+");
            if (i == -1) continue;
            String id1 = key.substring(0, i);
            String id2 = key.substring(i + 1);
            this.data[row][0] = this.gedcom.getEntity(id1);
            this.data[row][1] = this.gedcom.getEntity(id2);
            this.data[row][2] = list.get(key);
            ++row;
        }
    }

    private void resetColumns() {
        for (int col = 0; col < this.jTable.getColumnCount(); ++col) {
            this.jTable.getColumnModel().getColumn(col).setPreferredWidth(this.getMaxWidth(col));
        }
    }

    private void initComponents() {
        this.jScrollPane = new JScrollPane();
        this.jTable = new JTable();
        this.deleteButton = new JButton();
        this.calcScoreButton = new JButton();
        this.jTable.setModel(this.model);
        this.jTable.setSelectionMode(2);
        this.jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NonDupManagerPanel.this.jTableMouseClicked(evt);
            }
        });
        this.jScrollPane.setViewportView(this.jTable);
        Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)NbBundle.getMessage(NonDupManagerPanel.class, (String)"NonDupManagerPanel.deleteButton.text"));
        this.deleteButton.setToolTipText(NbBundle.getMessage(NonDupManagerPanel.class, (String)"NonDupManagerPanel.deleteButton.toolTipText"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NonDupManagerPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.calcScoreButton, (String)NbBundle.getMessage(NonDupManagerPanel.class, (String)"NonDupManagerPanel.calcScoreButton.text"));
        this.calcScoreButton.setToolTipText(NbBundle.getMessage(NonDupManagerPanel.class, (String)"NonDupManagerPanel.calcScoreButton.toolTipText"));
        this.calcScoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NonDupManagerPanel.this.calcScoreButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane, -1, 400, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.deleteButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.calcScoreButton).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane, -1, 188, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deleteButton).addComponent(this.calcScoreButton)).addContainerGap()));
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        this.deleteSelection();
    }

    private void jTableMouseClicked(MouseEvent evt) {
        Point point = evt.getPoint();
        int row = this.jTable.rowAtPoint(point);
        int col = this.jTable.columnAtPoint(point);
        if (col < 2 && evt.getClickCount() == 2 && this.jTable.getSelectedRow() != -1) {
            Entity entity = (Entity)this.model.getValueAt(row, col);
            SelectionDispatcher.fireSelection((Context)new Context(entity));
        }
    }

    private void calcScoreButtonActionPerformed(ActionEvent evt) {
        int[] rows = this.jTable.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        ArrayList<PotentialMatch<? extends Entity>> matchesLinkedList = new ArrayList<PotentialMatch<? extends Entity>>();
        DuplicatesFinder finder = null;
        Entity firstEntity = null;
        boolean invalid = false;
        for (int row : rows) {
            int index = this.jTable.convertRowIndexToModel(row);
            Entity e1 = (Entity)this.model.getValueAt(index, 0);
            Entity e2 = (Entity)this.model.getValueAt(index, 1);
            if (e1 == null || e2 == null) {
                invalid = true;
                continue;
            }
            if (firstEntity == null) {
                firstEntity = e1;
            }
            if (finder == null) {
                finder = new DuplicatesFinder(e1);
            }
            EntityMatcher entityMatcher = finder.getMatcher(e1);
            int diff = entityMatcher.compare(e1, e2);
            matchesLinkedList.add((PotentialMatch<? extends Entity>)new PotentialMatch((Object)e1, (Object)e2, diff));
        }
        if (invalid) {
            DialogManager.createError((String)NbBundle.getMessage(this.getClass(), (String)"nonDupCalScore"), (String)NbBundle.getMessage(this.getClass(), (String)"nonDupCalScore_nullEntity")).setOptionType(10).show();
        }
        if (!matchesLinkedList.isEmpty()) {
            DuplicatesResults results = new DuplicatesResults(this.gedcom, matchesLinkedList, firstEntity, false, 0);
            results.setParams(firstEntity, finder.getMatcher(firstEntity));
            results.show();
        }
    }

    private void deleteSelection() {
        int selectedRow = this.jTable.getSelectedRow();
        for (int row : this.jTable.getSelectedRows()) {
            if (row <= selectedRow) {
                selectedRow = Math.max(0, selectedRow - 1);
            }
            this.model.removeRow(row);
        }
        if (this.model.getRowCount() > selectedRow) {
            this.jTable.setRowSelectionInterval(selectedRow, selectedRow);
        } else if (this.model.getRowCount() > 0) {
            this.jTable.setRowSelectionInterval(0, 0);
        }
    }

    protected void saveList() {
        final TreeMap<String, String> list = new TreeMap<String, String>();
        for (int row = 0; row < this.model.getRowCount(); ++row) {
            Entity e1 = (Entity)this.model.getValueAt(row, 0);
            Entity e2 = (Entity)this.model.getValueAt(row, 1);
            if (e1 == null || e2 == null) continue;
            String key = NonDuplicates.getKey(e1.getId(), e2.getId());
            String reason = (String)this.model.getValueAt(row, 2);
            list.put(key, reason);
        }
        try {
            this.gedcom.doUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    NonDuplicates.saveList(list, gedcom);
                }
            });
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private int getMaxWidth(int col) {
        int PADDING = 10;
        FontMetrics fm = this.getFontMetrics(this.getFont().deriveFont(0));
        int width = 80;
        int w = 0;
        for (int row = 0; row < this.jTable.getRowCount(); ++row) {
            Object value = this.jTable.getValueAt(row, col);
            Object text = "";
            if (value instanceof String) {
                text = (String)value;
            } else if (value instanceof Entity) {
                text = ((Entity)value).toString();
            }
            w = fm.stringWidth((String)text) + 2 * PADDING;
            width = Math.max(width, w);
        }
        return width;
    }

    private void addNoteListener() {
        this.listener = new GedcomMetaListener(){

            public void gedcomHeaderChanged(Gedcom gedcom) {
            }

            public void gedcomWriteLockAcquired(Gedcom gedcom) {
            }

            public void gedcomBeforeUnitOfWork(Gedcom gedcom) {
            }

            public void gedcomAfterUnitOfWork(Gedcom gedcom) {
            }

            public void gedcomWriteLockReleased(Gedcom gedcom) {
                TableRowSorter sorter = (TableRowSorter)NonDupManagerPanel.this.jTable.getRowSorter();
                List<RowSorter.SortKey> sortKeys = sorter.getSortKeys();
                int[] rows = NonDupManagerPanel.this.jTable.getSelectedRows();
                AbstractNote note = NonDuplicates.getNote(gedcom);
                NonDupManagerPanel.this.resetData();
                NonDupManagerPanel.this.model.setDataVector(NonDupManagerPanel.this.data, NonDupManagerPanel.this.headers);
                NonDupManagerPanel.this.jTable.setRowSorter(sorter);
                sorter.setSortKeys(sortKeys);
                NonDupManagerPanel.this.jTable.clearSelection();
                for (int row : rows) {
                    NonDupManagerPanel.this.jTable.addRowSelectionInterval(row, row);
                }
            }

            public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
            }

            public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
            }

            public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
            }

            public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
            }

            public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property deleted) {
            }
        };
        this.gedcom.addGedcomListener((GedcomListener)this.listener);
    }

    public void close() {
        this.gedcom.removeGedcomListener((GedcomListener)this.listener);
    }
}

