/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.popup;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

final class PopupMenuResizer
extends MouseAdapter {
    private final JPopupMenu menu;
    private static final int REZSIZE_SPOT_SIZE = 10;
    private Point mouseStart = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
    private Dimension startSize;
    private boolean isResizing = false;

    public static void decorate(JPopupMenu jPopupMenu) {
        new PopupMenuResizer(jPopupMenu);
    }

    private PopupMenuResizer(JPopupMenu jPopupMenu) {
        this.menu = jPopupMenu;
        this.menu.setLightWeightPopupEnabled(true);
        jPopupMenu.addMouseListener(this);
        jPopupMenu.addMouseMotionListener(this);
    }

    private boolean isInResizeSpot(Point point) {
        if (point == null) {
            return false;
        }
        Rectangle rectangle = new Rectangle(this.menu.getWidth() - 10, this.menu.getHeight() - 10, 10, 10);
        return rectangle.contains(point);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.menu.setCursor(Cursor.getPredefinedCursor(this.isInResizeSpot(mouseEvent.getPoint()) ? 5 : 0));
    }

    private Point toScreen(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
        return point;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseStart = this.toScreen(mouseEvent);
        this.startSize = this.menu.getSize();
        this.isResizing = this.isInResizeSpot(mouseEvent.getPoint());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseStart = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.isResizing = false;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.isResizing) {
            return;
        }
        Point point = this.toScreen(mouseEvent);
        int n = point.x - this.mouseStart.x;
        int n2 = point.y - this.mouseStart.y;
        Dimension dimension = this.menu.getMinimumSize();
        Dimension dimension2 = new Dimension(this.startSize.width + n, this.startSize.height + n2);
        if (dimension2.width >= dimension.width && dimension2.height >= dimension.height) {
            this.menu.setPopupSize(dimension2);
        }
    }
}

