/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.geo;

import ancestris.api.search.SearchCommunicator;
import ancestris.modules.geo.GeoListTopComponent;
import ancestris.modules.geo.GeoMapTopComponent;
import ancestris.modules.geo.GeoNodeObject;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.util.Registry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.JComboBox;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class GeoFilter {
    private Registry registry = null;
    private Gedcom gedcom;
    public String location = "";
    public boolean showUnknown = false;
    public boolean ascendants = false;
    public boolean descendants = false;
    public boolean cousins = false;
    public boolean otherAncestors = false;
    public boolean selectedIndividual = false;
    public boolean selectedSearch = false;
    public boolean males = false;
    public boolean females = false;
    public String yearStart = "";
    public String yearEnd = "";
    public boolean births = false;
    public boolean marriages = false;
    public boolean deaths = false;
    public boolean otherEvents = false;
    public Indi rootIndi = null;
    private HashSet<Indi> ancestorsList = new HashSet();
    private HashSet<Indi> descendantsList = new HashSet();
    private HashSet<Indi> cousinsList = new HashSet();
    private HashSet<Indi> othersList = new HashSet();
    private HashSet<Indi> searchedIndis = new HashSet();
    private Indi selectedIndi = null;
    private boolean isBusy = false;

    public void setGedcom(Gedcom gedcom) {
        this.gedcom = gedcom;
        this.registry = gedcom.getRegistry();
        this.load();
    }

    public void load() {
        this.location = this.registry.get("GEO.geofilter.location", "");
        this.showUnknown = this.registry.get("GEO.geofilter.showUnknown", false);
        this.ascendants = this.registry.get("GEO.geofilter.ascendants", false);
        this.descendants = this.registry.get("GEO.geofilter.descendants", false);
        this.cousins = this.registry.get("GEO.geofilter.cousins", false);
        this.otherAncestors = this.registry.get("GEO.geofilter.otherAncestors", false);
        this.selectedIndividual = this.registry.get("GEO.geofilter.selectedIndividual", false);
        this.selectedSearch = this.registry.get("GEO.geofilter.selectedSearch", false);
        this.males = this.registry.get("GEO.geofilter.males", false);
        this.females = this.registry.get("GEO.geofilter.females", false);
        this.yearStart = this.registry.get("GEO.geofilter.yearStart", "");
        this.yearEnd = this.registry.get("GEO.geofilter.yearEnd", "");
        this.births = this.registry.get("GEO.geofilter.births", false);
        this.marriages = this.registry.get("GEO.geofilter.marriages", false);
        this.deaths = this.registry.get("GEO.geofilter.deaths", false);
        this.otherEvents = this.registry.get("GEO.geofilter.otherEvents", false);
    }

    public void save() {
        this.registry.put("GEO.geofilter.location", this.location);
        this.registry.put("GEO.geofilter.showUnknown", Boolean.valueOf(this.showUnknown));
        this.registry.put("GEO.geofilter.ascendants", Boolean.valueOf(this.ascendants));
        this.registry.put("GEO.geofilter.descendants", Boolean.valueOf(this.descendants));
        this.registry.put("GEO.geofilter.cousins", Boolean.valueOf(this.cousins));
        this.registry.put("GEO.geofilter.otherAncestors", Boolean.valueOf(this.otherAncestors));
        this.registry.put("GEO.geofilter.selectedIndividual", Boolean.valueOf(this.selectedIndividual));
        this.registry.put("GEO.geofilter.selectedSearch", Boolean.valueOf(this.selectedSearch));
        this.registry.put("GEO.geofilter.males", Boolean.valueOf(this.males));
        this.registry.put("GEO.geofilter.females", Boolean.valueOf(this.females));
        this.registry.put("GEO.geofilter.yearStart", this.yearStart);
        this.registry.put("GEO.geofilter.yearEnd", this.yearEnd);
        this.registry.put("GEO.geofilter.births", Boolean.valueOf(this.births));
        this.registry.put("GEO.geofilter.marriages", Boolean.valueOf(this.marriages));
        this.registry.put("GEO.geofilter.deaths", Boolean.valueOf(this.deaths));
        this.registry.put("GEO.geofilter.otherEvents", Boolean.valueOf(this.otherEvents));
    }

    public void calculatesIndividuals(Gedcom gedcom) {
        if (this.isBusy) {
            return;
        }
        this.isBusy = true;
        this.selectedIndi = this.getSelectedIndi();
        if (this.rootIndi == null) {
            this.rootIndi = this.getDeCujusIndi();
        }
        if (this.rootIndi == null) {
            this.rootIndi = this.selectedIndi;
        }
        if (this.rootIndi == null) {
            this.rootIndi = (Indi)gedcom.getFirstEntity("INDI");
        }
        this.ancestorsList = this.getAncestors(this.rootIndi);
        this.descendantsList = this.getDescendants(this.rootIndi);
        this.cousinsList = this.getCousins();
        this.othersList = this.getOthersList();
        this.searchedIndis = this.getSearchedIndis();
        this.isBusy = false;
    }

    public boolean compliesNode(GeoNodeObject node) {
        if (!this.location.isEmpty()) {
            if (node.toString().equals(NbBundle.getMessage(GeoListTopComponent.class, (String)"GeoEmpty"))) {
                return false;
            }
            if (!node.toString().toLowerCase().contains(this.location.toLowerCase())) {
                return false;
            }
        }
        if (!this.showUnknown && node.areCoordinatesUnknown()) {
            return false;
        }
        for (GeoNodeObject event : node.getAllEvents()) {
            if (!this.compliesEvent(event)) continue;
            return true;
        }
        return false;
    }

    public boolean compliesEvent(GeoNodeObject event) {
        boolean found = false;
        Set<Indi> indis = event.getFilteredIndisFromProp(null, null);
        if (indis.isEmpty()) {
            return !this.ascendants && !this.descendants && !this.cousins && !this.otherAncestors && !this.selectedSearch && !this.selectedIndividual && !this.males && !this.females;
        }
        for (Indi indi : indis) {
            if (!this.compliesIndi(indi)) continue;
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        if (this.births || this.marriages || this.deaths || this.otherEvents) {
            String tag = event.getEventTag();
            if (!(this.births && this.isBirth(tag) || this.marriages && this.isMarriage(tag) || this.deaths && this.isDeath(tag) || this.otherEvents && this.isOtherEvents(tag))) {
                return false;
            }
        }
        if (!this.yearStart.isEmpty() && !this.after(event.getEventsMaxDate(), this.yearStart)) {
            return false;
        }
        return this.yearEnd.isEmpty() || this.before(event.getEventsMinDate(), this.yearEnd);
    }

    public boolean compliesIndi(Indi indi) {
        if (this.ascendants && !this.ancestorsList.contains(indi)) {
            return false;
        }
        if (this.descendants && !this.descendantsList.contains(indi)) {
            return false;
        }
        if (this.cousins && !this.cousinsList.contains(indi)) {
            return false;
        }
        if (this.otherAncestors && !this.othersList.contains(indi)) {
            return false;
        }
        if (this.selectedSearch && !this.searchedIndis.contains(indi)) {
            return false;
        }
        if (this.selectedIndividual && this.selectedIndi != null && !this.selectedIndi.equals(indi)) {
            return false;
        }
        if (this.males && indi.getSex() != 1) {
            return false;
        }
        return !this.females || indi.getSex() == 2;
    }

    public boolean isBirth(String tag) {
        return "BIRT".equals(tag);
    }

    public boolean isMarriage(String tag) {
        return "MARR".equals(tag) || "ENGA".equals(tag) || "MARB".equals(tag) || "MARC".equals(tag);
    }

    public boolean isDeath(String tag) {
        return "DEAT".equals(tag) || "BURI".equals(tag) || "CREM".equals(tag);
    }

    public boolean isOtherEvents(String tag) {
        return !this.isBirth(tag) && !this.isMarriage(tag) && !this.isDeath(tag);
    }

    private boolean after(int eventsMaxDate, String yearStart) {
        if (yearStart == null || yearStart.isEmpty()) {
            return true;
        }
        return eventsMaxDate != -99999 && eventsMaxDate >= this.getNb(yearStart);
    }

    private boolean before(int eventsMinDate, String yearEnd) {
        if (yearEnd == null || yearEnd.isEmpty()) {
            return true;
        }
        return eventsMinDate != 99999 && eventsMinDate <= this.getNb(yearEnd);
    }

    public Indi getRootIndi() {
        if (this.rootIndi == null) {
            this.rootIndi = this.getSelectedIndi();
        }
        return this.rootIndi;
    }

    public Indi askRootIndi() {
        Entity[] ents = this.gedcom.getEntities("INDI", "INDI:NAME");
        JComboBox<Entity> jlist = new JComboBox<Entity>(ents);
        if (this.rootIndi != null) {
            jlist.setSelectedItem(this.rootIndi);
        }
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation(jlist, NbBundle.getMessage(GeoMapTopComponent.class, (String)"sosa.input.title"), 2);
        Indi chosenIndi = DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.OK_OPTION ? (Indi)ents[jlist.getSelectedIndex()] : (this.rootIndi != null ? this.rootIndi : (Indi)ents[0]);
        return chosenIndi;
    }

    private int getNb(String str) {
        int sosaNb;
        int start;
        if (str == null || str.isEmpty()) {
            return 0;
        }
        int end = str.length();
        for (start = 0; start <= end && !Character.isDigit(str.charAt(start)); ++start) {
        }
        for (end = start; end <= str.length() - 1 && Character.isDigit(str.charAt(end)); ++end) {
        }
        if (end == start) {
            return 0;
        }
        try {
            sosaNb = Integer.parseInt(str.substring(start, end));
        }
        catch (NumberFormatException e) {
            sosaNb = 0;
        }
        return sosaNb;
    }

    private HashSet<Indi> getAncestors(Indi rootIndi) {
        if (rootIndi == null) {
            return null;
        }
        HashSet<Indi> retList = new HashSet<Indi>();
        ArrayList<Indi> indis = new ArrayList<Indi>();
        indis.add(rootIndi);
        ListIterator<Indi> it = indis.listIterator();
        while (it.hasNext()) {
            Indi indi = (Indi)it.next();
            if (retList.contains(indi)) continue;
            Fam famc = indi.getFamilyWhereBiologicalChild();
            if (famc != null) {
                Indi father;
                Indi mother = famc.getWife();
                if (mother != null) {
                    it.add(mother);
                    it.previous();
                }
                if ((father = famc.getHusband()) != null) {
                    it.add(father);
                    it.previous();
                }
            }
            retList.add(indi);
        }
        return retList;
    }

    private HashSet<Indi> getDescendants(Indi rootIndi) {
        if (rootIndi == null) {
            return null;
        }
        HashSet<Indi> retList = new HashSet<Indi>();
        ArrayList<Indi> indis = new ArrayList<Indi>();
        indis.add(rootIndi);
        ListIterator<Indi> it = indis.listIterator();
        while (it.hasNext()) {
            Indi[] children;
            Indi indi = (Indi)it.next();
            if (retList.contains(indi)) continue;
            for (Indi kid : children = indi.getChildren()) {
                it.add(kid);
                it.previous();
            }
            retList.add(indi);
        }
        return retList;
    }

    private HashSet<Indi> getCousins() {
        if (this.gedcom == null) {
            return new HashSet<Indi>();
        }
        HashSet<Indi> retList = new HashSet<Indi>();
        HashSet<Indi> excludedIndis = new HashSet<Indi>();
        excludedIndis.addAll(this.ancestorsList);
        excludedIndis.addAll(this.descendantsList);
        for (Indi ancestor : this.ancestorsList) {
            HashSet<Indi> descendantslst = new HashSet<Indi>();
            this.getDescendants(ancestor, excludedIndis, descendantslst);
            retList.addAll(descendantslst);
            excludedIndis.addAll(retList);
        }
        return retList;
    }

    private void getDescendants(Indi ancestor, HashSet<Indi> excludedSet, HashSet<Indi> descendants) {
        for (Indi indi : ancestor.getChildren()) {
            if (excludedSet.contains(indi)) continue;
            descendants.add(indi);
            this.getDescendants(indi, excludedSet, descendants);
        }
    }

    private HashSet<Indi> getOthersList() {
        if (this.gedcom == null) {
            return new HashSet<Indi>();
        }
        HashSet<Indi> retList = new HashSet<Indi>();
        HashSet indis = new HashSet(this.gedcom.getEntities("INDI"));
        indis.removeAll(this.ancestorsList);
        indis.removeAll(this.descendantsList);
        indis.removeAll(this.cousinsList);
        retList.addAll(indis);
        return retList;
    }

    public HashSet<Indi> getSearchedIndis() {
        if (this.gedcom == null) {
            return new HashSet<Indi>();
        }
        HashSet<Indi> retList = new HashSet<Indi>();
        List results = SearchCommunicator.getResults((Gedcom)this.gedcom);
        if (results == null) {
            return retList;
        }
        for (Property prop : results) {
            String tag = prop.getTag();
            if (tag.equals("ASSO") || tag.equals("CHIL") || tag.equals("FAMC") || tag.equals("FAMS") || tag.equals("HUSB") || tag.equals("WIFE")) continue;
            if (!(prop instanceof Indi) && !(prop instanceof Fam)) {
                prop = prop.getEntity();
            }
            if (prop instanceof Indi) {
                Indi indi = (Indi)prop;
                retList.add(indi);
                continue;
            }
            if (!(prop instanceof Fam)) continue;
            Fam fam = (Fam)prop;
            Indi indi = fam.getHusband();
            if (indi != null) {
                retList.add(indi);
            }
            if ((indi = fam.getWife()) == null) continue;
            retList.add(indi);
        }
        return retList;
    }

    public Indi getSelectedIndi() {
        if (this.gedcom == null) {
            return null;
        }
        Context context = (Context)Utilities.actionsGlobalContext().lookup(Context.class);
        if (context == null) {
            return null;
        }
        Entity ent = context.getEntity();
        if (ent == null) {
            return null;
        }
        if (ent instanceof Indi) {
            Indi indi = (Indi)ent;
            return indi;
        }
        if (ent instanceof Fam) {
            Fam fam = (Fam)ent;
            Indi indi = fam.getHusband();
            if (indi != null) {
                return indi;
            }
            indi = fam.getWife();
            if (indi != null) {
                return indi;
            }
        }
        return this.gedcom.getDeCujusIndi();
    }

    public String getShortDescription() {
        String selected;
        String indi;
        Object ret = "";
        if (!this.location.isEmpty()) {
            ret = (String)ret + NbBundle.getMessage(GeoMapTopComponent.class, (String)"filters.location", (Object)this.location);
        }
        if (!this.showUnknown) {
            if (!((String)ret).isEmpty()) {
                ret = (String)ret + " + ";
            }
            ret = (String)ret + NbBundle.getMessage(GeoMapTopComponent.class, (String)"filters.unknown");
        }
        String string = indi = this.rootIndi != null ? this.rootIndi.toString(true) : "";
        if (this.ascendants | this.descendants | this.cousins | this.otherAncestors) {
            Object tree = "";
            String asce = NbBundle.getMessage(GeoMapTopComponent.class, (String)"SettingsPanel.jAncestorCheckBox.text");
            String desc = NbBundle.getMessage(GeoMapTopComponent.class, (String)"SettingsPanel.jDescendantCheckBox.text");
            String cous = NbBundle.getMessage(GeoMapTopComponent.class, (String)"SettingsPanel.jCousinCheckBox.text");
            String othe = NbBundle.getMessage(GeoMapTopComponent.class, (String)"SettingsPanel.jOthersCheckBox.text");
            if (!this.ascendants) {
                asce = "";
            }
            tree = (String)tree + asce;
            if (!this.descendants) {
                desc = "";
            } else if (!((String)tree).isEmpty()) {
                tree = (String)tree + "+";
            }
            tree = (String)tree + desc;
            if (!this.cousins) {
                cous = "";
            } else if (!((String)tree).isEmpty()) {
                tree = (String)tree + "+";
            }
            tree = (String)tree + cous;
            if (!this.otherAncestors) {
                othe = "";
            } else if (!((String)tree).isEmpty()) {
                tree = (String)tree + "+";
            }
            tree = (String)tree + othe;
            if (!((String)tree).isEmpty()) {
                if (!((String)ret).isEmpty()) {
                    ret = (String)ret + " + ";
                }
                ret = (String)ret + NbBundle.getMessage(GeoMapTopComponent.class, (String)"filters.tree", (Object)tree, (Object)indi);
            }
        }
        if (!this.yearStart.isEmpty() | !this.yearEnd.isEmpty() | this.births | this.marriages | this.deaths | this.otherEvents) {
            Object event = "";
            Object yeas = ">";
            Object yeae = "<";
            String birt = NbBundle.getMessage(GeoMapTopComponent.class, (String)"SettingsPanel.jBirthCheckBox.text");
            String marr = NbBundle.getMessage(GeoMapTopComponent.class, (String)"SettingsPanel.jWeddingCheckBox.text");
            String deat = NbBundle.getMessage(GeoMapTopComponent.class, (String)"SettingsPanel.jDeathCheckBox1.text");
            String othe = NbBundle.getMessage(GeoMapTopComponent.class, (String)"SettingsPanel.jOtherEventCheckBox1.text");
            yeas = this.yearStart.isEmpty() ? "" : (String)yeas + (String)yeas + this.yearStart;
            yeae = this.yearEnd.isEmpty() ? "" : (String)yeae + (String)yeae + this.yearEnd;
            if (!((String)event).isEmpty()) {
                event = (String)event + "+";
            }
            event = (String)event + (String)yeae;
            if (!this.births) {
                birt = "";
            } else if (!((String)event).isEmpty()) {
                event = (String)event + "+";
            }
            event = (String)event + birt;
            if (!this.marriages) {
                marr = "";
            } else if (!((String)event).isEmpty()) {
                event = (String)event + "+";
            }
            event = (String)event + marr;
            if (!this.deaths) {
                deat = "";
            } else if (!((String)event).isEmpty()) {
                event = (String)event + "+";
            }
            event = (String)event + deat;
            if (!this.otherEvents) {
                othe = "";
            } else if (!((String)event).isEmpty()) {
                event = (String)event + "+";
            }
            event = (String)event + othe;
            if (!((String)event).isEmpty()) {
                if (!((String)ret).isEmpty()) {
                    ret = (String)ret + " + ";
                }
                ret = (String)ret + NbBundle.getMessage(GeoMapTopComponent.class, (String)"filters.events", (Object)event);
            }
        }
        String string2 = selected = this.selectedIndi != null ? this.selectedIndi.toString(true) : "";
        if (this.males | this.females | this.selectedIndividual | this.selectedSearch) {
            Object selindi = "";
            String male = NbBundle.getMessage(GeoMapTopComponent.class, (String)"SettingsPanel.jMenRadioButton.text");
            String fema = NbBundle.getMessage(GeoMapTopComponent.class, (String)"SettingsPanel.jWomenRadioButton.text");
            String sind = NbBundle.getMessage(GeoMapTopComponent.class, (String)"SettingsPanel.jSelectedRadioButton.text");
            String ssea = NbBundle.getMessage(GeoMapTopComponent.class, (String)"SettingsPanel.jSearchedRadioButton.text");
            if (!this.males) {
                male = "";
            } else {
                selindi = (String)selindi + male;
            }
            if (!this.females) {
                fema = "";
            } else if (!((String)selindi).isEmpty()) {
                selindi = (String)selindi + "+";
            }
            selindi = (String)selindi + fema;
            if (!this.selectedIndividual) {
                sind = "";
            } else if (!((String)selindi).isEmpty()) {
                selindi = (String)selindi + "+";
            }
            selindi = (String)selindi + sind;
            if (this.selectedIndividual) {
                selindi = (String)selindi + " (" + selected + ")";
            }
            if (!this.selectedSearch) {
                ssea = "";
            } else if (!((String)selindi).isEmpty()) {
                selindi = (String)selindi + "+";
            }
            selindi = (String)selindi + ssea;
            if (!((String)selindi).isEmpty()) {
                if (!((String)ret).isEmpty()) {
                    ret = (String)ret + " + ";
                }
                ret = (String)ret + NbBundle.getMessage(GeoMapTopComponent.class, (String)"filters.indi", (Object)selindi);
            }
        }
        return ret;
    }

    public Indi getDeCujusIndi() {
        return this.gedcom.getDeCujusIndi();
    }
}

