/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.flashlist;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.modules.document.view.FopDocumentView;
import ancestris.modules.flashlist.Bundle;
import ancestris.modules.flashlist.ReportFlashList;
import genj.fo.Document;
import genj.gedcom.Context;
import genj.view.Images;
import java.awt.event.ActionEvent;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class FlashListAction
extends AbstractAncestrisContextAction {
    public FlashListAction() {
        this.setIconBase("ancestris/modules/flashlist/ReportFO.png");
        this.setText(NbBundle.getMessage(FlashListAction.class, (String)"CTL_FlashListAction"));
    }

    protected void contextChanged() {
        this.setEnabled(!this.contextProperties.isEmpty());
        super.contextChanged();
    }

    protected void actionPerformedImpl(ActionEvent event) {
        this.run();
    }

    private void run() {
        Document doc;
        Preferences modulePreferences = NbPreferences.forModule(ReportFlashList.class);
        Context contextToOpen = this.getContext();
        if (contextToOpen != null && (doc = new ReportFlashList().start(contextToOpen.getGedcom(), modulePreferences.get("reportFilename", "flash-list"))) != null) {
            FopDocumentView window = new FopDocumentView(contextToOpen, Bundle.title_short(), Bundle.title(contextToOpen.getGedcom().getDisplayName()), new AbstractAncestrisAction[]{this.runAction(), this.optionAction()});
            window.displayDocument(doc, modulePreferences);
        }
    }

    private AbstractAncestrisAction runAction() {
        AbstractAncestrisAction option = new AbstractAncestrisAction(){

            public void actionPerformed(ActionEvent e) {
                FlashListAction.this.run();
            }
        };
        option.setImage("ancestris/modules/flashlist/Start.png");
        option.setTip(NbBundle.getMessage(FlashListAction.class, (String)"FlashListAction.rerun"));
        return option;
    }

    private AbstractAncestrisAction optionAction() {
        AbstractAncestrisAction option = new AbstractAncestrisAction(){

            public void actionPerformed(ActionEvent e) {
                boolean doRun;
                Context contextToOpen = FlashListAction.this.getContext();
                if (contextToOpen != null && (doRun = new ReportFlashList().getFlashOptions(contextToOpen.getGedcom()))) {
                    FlashListAction.this.run();
                }
            }
        };
        option.setImage((Icon)Images.imgSettings);
        option.setTip(NbBundle.getMessage(FlashListAction.class, (String)"FlashListAction.parameters"));
        return option;
    }
}

