/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import org.graphstream.stream.file.FileSourceBase;

public class FileSourceDGS1And2
extends FileSourceBase {
    protected int version;
    protected String graphName;
    protected int stepCountAnnounced;
    protected int eventCountAnnounced;
    protected int stepCount;
    protected int eventCount;
    protected ArrayList<AttributeFormat> nodesFormat = new ArrayList();
    protected ArrayList<AttributeFormat> edgesFormat = new ArrayList();
    protected HashMap<String, Object> attributes = new HashMap();

    public FileSourceDGS1And2() {
        super(true);
    }

    @Override
    public boolean nextEvents() throws IOException {
        String key = this.getWordOrSymbolOrStringOrEolOrEof();
        String tag = null;
        if (key.equals("ce")) {
            tag = this.getStringOrWordOrNumber();
            this.readAttributes(this.edgesFormat);
            for (String k : this.attributes.keySet()) {
                Object value = this.attributes.get(k);
                this.sendEdgeAttributeChanged(this.graphName, tag, k, null, value);
            }
            if (this.eatEolOrEof() == -1) {
                return false;
            }
        } else if (key.equals("cn")) {
            tag = this.getStringOrWordOrNumber();
            this.readAttributes(this.nodesFormat);
            for (String k : this.attributes.keySet()) {
                Object value = this.attributes.get(k);
                this.sendNodeAttributeChanged(this.graphName, tag, k, null, value);
            }
            if (this.eatEolOrEof() == -1) {
                return false;
            }
        } else if (key.equals("ae")) {
            tag = this.getStringOrWordOrNumber();
            String fromTag = this.getStringOrWordOrNumber();
            String toTag = this.getStringOrWordOrNumber();
            this.readAttributes(this.edgesFormat);
            this.sendEdgeAdded(this.graphName, tag, fromTag, toTag, false);
            if (this.attributes != null) {
                for (String k : this.attributes.keySet()) {
                    Object value = this.attributes.get(k);
                    this.sendEdgeAttributeAdded(this.graphName, tag, k, value);
                }
            }
            if (this.eatEolOrEof() == -1) {
                return false;
            }
        } else if (key.equals("an")) {
            tag = this.getStringOrWordOrNumber();
            this.readAttributes(this.nodesFormat);
            this.sendNodeAdded(this.graphName, tag);
            if (this.attributes != null) {
                for (String k : this.attributes.keySet()) {
                    Object value = this.attributes.get(k);
                    this.sendNodeAttributeAdded(this.graphName, tag, k, value);
                }
            }
            if (this.eatEolOrEof() == -1) {
                return false;
            }
        } else if (key.equals("de")) {
            tag = this.getStringOrWordOrNumber();
            this.sendEdgeRemoved(this.graphName, tag);
            if (this.eatEolOrEof() == -1) {
                return false;
            }
        } else if (key.equals("dn")) {
            tag = this.getStringOrWordOrNumber();
            this.sendNodeRemoved(this.graphName, tag);
            if (this.eatEolOrEof() == -1) {
                return false;
            }
        } else if (key.equals("st")) {
            String w = this.getWordOrNumber();
            try {
                double time = Double.parseDouble(w);
                this.sendStepBegins(this.graphName, time);
            }
            catch (NumberFormatException e) {
                this.parseError("expecting a number after `st', got `" + w + "'");
            }
            if (this.eatEolOrEof() == -1) {
                return false;
            }
        } else if (key == "#") {
            this.eatAllUntilEol();
        } else {
            if (key == "EOL") {
                return true;
            }
            if (key == "EOF") {
                return false;
            }
            this.parseError("found an unknown key in file '" + key + "' (expecting an,ae,cn,ce,dn,de or st)");
        }
        return true;
    }

    @Override
    public boolean nextStep() throws IOException {
        String key = "";
        String tag = null;
        while (!key.equals("st") && !key.equals("EOF")) {
            Object value;
            key = this.getWordOrSymbolOrStringOrEolOrEof();
            if (key.equals("ce")) {
                tag = this.getStringOrWordOrNumber();
                this.readAttributes(this.edgesFormat);
                for (String k : this.attributes.keySet()) {
                    value = this.attributes.get(k);
                    this.sendEdgeAttributeChanged(this.graphName, tag, k, null, value);
                }
                if (this.eatEolOrEof() != -1) continue;
                return false;
            }
            if (key.equals("cn")) {
                tag = this.getStringOrWordOrNumber();
                this.readAttributes(this.nodesFormat);
                for (String k : this.attributes.keySet()) {
                    value = this.attributes.get(k);
                    this.sendNodeAttributeChanged(this.graphName, tag, k, null, value);
                }
                if (this.eatEolOrEof() != -1) continue;
                return false;
            }
            if (key.equals("ae")) {
                tag = this.getStringOrWordOrNumber();
                String fromTag = this.getStringOrWordOrNumber();
                String toTag = this.getStringOrWordOrNumber();
                this.readAttributes(this.edgesFormat);
                this.sendEdgeAdded(this.graphName, tag, fromTag, toTag, false);
                if (this.attributes != null) {
                    for (String k : this.attributes.keySet()) {
                        Object value2 = this.attributes.get(k);
                        this.sendNodeAttributeAdded(this.graphName, tag, k, value2);
                    }
                }
                if (this.eatEolOrEof() != -1) continue;
                return false;
            }
            if (key.equals("an")) {
                tag = this.getStringOrWordOrNumber();
                this.readAttributes(this.nodesFormat);
                this.sendNodeAdded(this.graphName, tag);
                if (this.attributes != null) {
                    for (String k : this.attributes.keySet()) {
                        value = this.attributes.get(k);
                        this.sendNodeAttributeAdded(this.graphName, tag, k, value);
                    }
                }
                if (this.eatEolOrEof() != -1) continue;
                return false;
            }
            if (key.equals("de")) {
                tag = this.getStringOrWordOrNumber();
                this.sendEdgeRemoved(this.graphName, tag);
                if (this.eatEolOrEof() != -1) continue;
                return false;
            }
            if (key.equals("dn")) {
                tag = this.getStringOrWordOrNumber();
                this.sendNodeRemoved(this.graphName, tag);
                if (this.eatEolOrEof() != -1) continue;
                return false;
            }
            if (key.equals("st")) {
                String w = this.getWordOrNumber();
                try {
                    double time = Double.parseDouble(w);
                    this.sendStepBegins(this.graphName, time);
                }
                catch (NumberFormatException e) {
                    this.parseError("expecting a number after `st', got `" + w + "'");
                }
                if (this.eatEolOrEof() != -1) continue;
                return false;
            }
            if (key == "#") {
                this.eatAllUntilEol();
                continue;
            }
            if (key == "EOL") continue;
            if (key == "EOF") {
                return false;
            }
            this.parseError("found an unknown key in file '" + key + "' (expecting an,ae,cn,ce,dn,de or st)");
        }
        return true;
    }

    protected void readAttributes(ArrayList<AttributeFormat> formats) throws IOException {
        this.attributes.clear();
        if (formats.size() > 0) {
            for (AttributeFormat format : formats) {
                if (format.type == AttributeType.NUMBER) {
                    this.readNumberAttribute(format.name);
                    continue;
                }
                if (format.type == AttributeType.VECTOR) {
                    this.readVectorAttribute(format.name);
                    continue;
                }
                if (format.type != AttributeType.STRING) continue;
                this.readStringAttribute(format.name);
            }
        }
    }

    protected void readNumberAttribute(String name) throws IOException {
        int tok = this.st.nextToken();
        if (this.isNull(tok)) {
            this.attributes.put(name, new Double(0.0));
        } else {
            this.st.pushBack();
            double n = this.getNumber();
            this.attributes.put(name, new Double(n));
        }
    }

    protected void readVectorAttribute(String name) throws IOException {
        int tok = this.st.nextToken();
        if (this.isNull(tok)) {
            this.attributes.put(name, new ArrayList());
        } else {
            boolean loop = true;
            ArrayList<Double> vector = new ArrayList<Double>();
            while (loop) {
                if (tok != -2) {
                    this.parseError("expecting a number, " + this.gotWhat(tok));
                }
                vector.add(this.st.nval);
                tok = this.st.nextToken();
                if (tok != 44) {
                    loop = false;
                    this.st.pushBack();
                    continue;
                }
                tok = this.st.nextToken();
            }
            this.attributes.put(name, vector);
        }
    }

    protected void readStringAttribute(String name) throws IOException {
        String s = this.getStringOrWordOrNumber();
        this.attributes.put(name, s);
    }

    protected boolean isNull(int tok) {
        if (tok == -3) {
            return this.st.sval.equals("null");
        }
        return false;
    }

    @Override
    public void begin(String filename) throws IOException {
        super.begin(filename);
        this.init();
    }

    @Override
    public void begin(InputStream stream) throws IOException {
        super.begin(stream);
        this.init();
    }

    @Override
    public void begin(Reader reader) throws IOException {
        super.begin(reader);
        this.init();
    }

    @Override
    public void begin(URL url) throws IOException {
        super.begin(url);
        this.init();
    }

    protected void init() throws IOException {
        this.st.parseNumbers();
        String magic = this.eatOneOfTwoWords("DGS001", "DGS002");
        this.version = magic.equals("DGS001") ? 1 : 2;
        this.eatEol();
        this.graphName = this.getWord();
        this.stepCountAnnounced = (int)this.getNumber();
        this.eventCountAnnounced = (int)this.getNumber();
        this.eatEol();
        if (this.graphName != null) {
            this.attributes.clear();
            this.attributes.put("label", this.graphName);
            this.sendGraphAttributeAdded(this.graphName, "label", this.graphName);
        } else {
            this.graphName = "DGS_";
        }
        this.graphName = String.format("%s_%d", this.graphName, System.currentTimeMillis() + (long)Math.random() * 10L);
        this.readAttributeFormat();
    }

    protected void readAttributeFormat() throws IOException {
        int tok = this.st.nextToken();
        if (tok == -3 && this.st.sval.equals("nodes")) {
            this.parseAttributeFormat(this.nodesFormat);
            tok = this.st.nextToken();
        }
        if (tok == -3 && this.st.sval.equals("edges")) {
            this.parseAttributeFormat(this.edgesFormat);
        } else {
            this.st.pushBack();
        }
    }

    protected void parseAttributeFormat(ArrayList<AttributeFormat> format) throws IOException {
        int tok = this.st.nextToken();
        while (tok != 10) {
            if (tok == -3) {
                String name = this.st.sval;
                this.eatSymbol(':');
                tok = this.st.nextToken();
                if (tok == -3) {
                    String type = this.st.sval.toLowerCase();
                    if (type.equals("number") || type.equals("n")) {
                        format.add(new AttributeFormat(name, AttributeType.NUMBER));
                    } else if (type.equals("string") || type.equals("s")) {
                        format.add(new AttributeFormat(name, AttributeType.STRING));
                    } else if (type.equals("vector") || type.equals("v")) {
                        format.add(new AttributeFormat(name, AttributeType.VECTOR));
                    } else {
                        this.parseError("unknown attribute type `" + type + "' (only `number', `vector' and `string' are accepted)");
                    }
                } else {
                    this.parseError("expecting an attribute type, got `" + this.gotWhat(tok) + "'");
                }
            } else {
                this.parseError("expecting an attribute name, got `" + this.gotWhat(tok) + "'");
            }
            tok = this.st.nextToken();
        }
    }

    @Override
    protected void continueParsingInInclude() throws IOException {
    }

    @Override
    protected Reader createReaderFrom(String file) throws FileNotFoundException {
        InputStream is = null;
        try {
            is = new GZIPInputStream(new FileInputStream(file));
        }
        catch (IOException e) {
            is = new FileInputStream(file);
        }
        return new BufferedReader(new InputStreamReader(is));
    }

    @Override
    protected Reader createReaderFrom(InputStream stream) {
        return new BufferedReader(new InputStreamReader(stream));
    }

    @Override
    protected void configureTokenizer(StreamTokenizer tok) throws IOException {
        if (this.COMMENT_CHAR > 0) {
            tok.commentChar(this.COMMENT_CHAR);
        }
        tok.eolIsSignificant(this.eol_is_significant);
        tok.wordChars(95, 95);
        tok.ordinaryChar(49);
        tok.ordinaryChar(50);
        tok.ordinaryChar(51);
        tok.ordinaryChar(52);
        tok.ordinaryChar(53);
        tok.ordinaryChar(54);
        tok.ordinaryChar(55);
        tok.ordinaryChar(56);
        tok.ordinaryChar(57);
        tok.ordinaryChar(48);
        tok.ordinaryChar(46);
        tok.ordinaryChar(45);
        tok.wordChars(49, 49);
        tok.wordChars(50, 50);
        tok.wordChars(51, 51);
        tok.wordChars(52, 52);
        tok.wordChars(53, 53);
        tok.wordChars(54, 54);
        tok.wordChars(55, 55);
        tok.wordChars(56, 56);
        tok.wordChars(57, 57);
        tok.wordChars(48, 48);
        tok.wordChars(46, 46);
        tok.wordChars(45, 45);
    }

    protected static class AttributeFormat {
        public String name;
        public AttributeType type;

        public AttributeFormat(String name, AttributeType type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public AttributeType getType() {
            return this.type;
        }
    }

    protected static enum AttributeType {
        NUMBER,
        VECTOR,
        STRING;

    }
}

