/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.gexf;

import java.util.HashSet;
import javax.xml.stream.XMLStreamException;
import org.graphstream.stream.PipeBase;
import org.graphstream.stream.file.gexf.GEXFAttribute;
import org.graphstream.stream.file.gexf.GEXFElement;
import org.graphstream.stream.file.gexf.GEXFGraph;
import org.graphstream.stream.file.gexf.GEXFMeta;
import org.graphstream.stream.file.gexf.SmartXMLWriter;

public class GEXF
extends PipeBase
implements GEXFElement {
    public static final String XMLNS = "http://www.gexf.net/1.2draft";
    public static final String XMLNS_XSI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XMLNS_SL = "http://www.gexf.net/1.2draft http://www.gexf.net/1.2draft/gexf.xsd";
    public static final String XMLNS_VIZ = "http://www.gexf.net/1.2draft/viz";
    public static final String VERSION = "1.2";
    GEXFMeta meta = new GEXFMeta();
    GEXFGraph graph = new GEXFGraph(this);
    int currentAttributeIndex = 0;
    double step = 0.0;
    HashSet<GEXFElement.Extension> extensions;
    GEXFElement.TimeFormat timeFormat = GEXFElement.TimeFormat.DOUBLE;

    public GEXF() {
        this.extensions = new HashSet();
        this.extensions.add(GEXFElement.Extension.DATA);
        this.extensions.add(GEXFElement.Extension.DYNAMICS);
        this.extensions.add(GEXFElement.Extension.VIZ);
    }

    public GEXFElement.TimeFormat getTimeFormat() {
        return this.timeFormat;
    }

    public boolean isExtensionEnable(GEXFElement.Extension ext) {
        return this.extensions.contains((Object)ext);
    }

    public void disable(GEXFElement.Extension ext) {
        this.extensions.remove((Object)ext);
    }

    public void enable(GEXFElement.Extension ext) {
        this.extensions.add(ext);
    }

    @Override
    public void export(SmartXMLWriter stream) throws XMLStreamException {
        stream.startElement("gexf");
        stream.stream.writeAttribute("xmlns", XMLNS);
        stream.stream.writeAttribute("xmlns:xsi", XMLNS_XSI);
        if (this.isExtensionEnable(GEXFElement.Extension.VIZ)) {
            stream.stream.writeAttribute("xmlns:viz", XMLNS_VIZ);
        }
        stream.stream.writeAttribute("xsi:schemaLocation", XMLNS_SL);
        stream.stream.writeAttribute("version", VERSION);
        this.meta.export(stream);
        this.graph.export(stream);
        stream.endElement();
    }

    int getNewAttributeIndex() {
        return this.currentAttributeIndex++;
    }

    GEXFAttribute getNodeAttribute(String key) {
        return this.graph.nodesAttributes.attributes.get(key);
    }

    GEXFAttribute getEdgeAttribute(String key) {
        return this.graph.edgesAttributes.attributes.get(key);
    }

    @Override
    public void stepBegins(String sourceId, long timeId, double step) {
        this.step = step;
        super.stepBegins(sourceId, timeId, step);
    }
}

