/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.util;

import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.AbstractElement;
import org.graphstream.stream.Pipe;
import org.graphstream.stream.SourceBase;
import org.graphstream.stream.sync.SinkTime;

public class GraphListeners
extends SourceBase
implements Pipe {
    SinkTime sinkTime = new SinkTime();
    boolean passYourWay;
    boolean passYourWayAE;
    String dnSourceId;
    long dnTimeId;
    Graph g;

    public GraphListeners(Graph g) {
        super(g.getId());
        this.sourceTime.setSinkTime(this.sinkTime);
        this.passYourWay = false;
        this.passYourWayAE = false;
        this.dnSourceId = null;
        this.dnTimeId = Long.MIN_VALUE;
        this.g = g;
    }

    public long newEvent() {
        return this.sourceTime.newEvent();
    }

    public void sendAttributeChangedEvent(String eltId, SourceBase.ElementType eltType, String attribute, AbstractElement.AttributeChangeEvent event, Object oldValue, Object newValue) {
        if (this.passYourWay || attribute.charAt(0) == '.') {
            return;
        }
        this.sendAttributeChangedEvent(this.sourceId, this.newEvent(), eltId, eltType, attribute, event, oldValue, newValue);
    }

    public void sendNodeAdded(String nodeId) {
        if (this.passYourWay) {
            return;
        }
        this.sendNodeAdded(this.sourceId, this.newEvent(), nodeId);
    }

    public void sendNodeRemoved(String nodeId) {
        if (this.dnSourceId != null) {
            this.sendNodeRemoved(this.dnSourceId, this.dnTimeId, nodeId);
        } else {
            this.sendNodeRemoved(this.sourceId, this.newEvent(), nodeId);
        }
    }

    public void sendEdgeAdded(String edgeId, String source, String target, boolean directed) {
        if (this.passYourWayAE) {
            return;
        }
        this.sendEdgeAdded(this.sourceId, this.newEvent(), edgeId, source, target, directed);
    }

    public void sendEdgeRemoved(String edgeId) {
        if (this.passYourWay) {
            return;
        }
        this.sendEdgeRemoved(this.sourceId, this.newEvent(), edgeId);
    }

    public void sendGraphCleared() {
        if (this.passYourWay) {
            return;
        }
        this.sendGraphCleared(this.sourceId, this.newEvent());
    }

    public void sendStepBegins(double step) {
        if (this.passYourWay) {
            return;
        }
        this.sendStepBegins(this.sourceId, this.newEvent(), step);
    }

    @Override
    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        Edge edge;
        if (this.sinkTime.isNewEvent(sourceId, timeId) && (edge = this.g.getEdge(edgeId)) != null) {
            this.passYourWay = true;
            try {
                edge.setAttribute(attribute, value);
            }
            finally {
                this.passYourWay = false;
            }
            this.sendEdgeAttributeAdded(sourceId, timeId, edgeId, attribute, value);
        }
    }

    @Override
    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        Edge edge;
        if (this.sinkTime.isNewEvent(sourceId, timeId) && (edge = this.g.getEdge(edgeId)) != null) {
            this.passYourWay = true;
            if (oldValue == null) {
                oldValue = edge.getAttribute(attribute);
            }
            try {
                edge.setAttribute(attribute, newValue);
            }
            finally {
                this.passYourWay = false;
            }
            this.sendEdgeAttributeChanged(sourceId, timeId, edgeId, attribute, oldValue, newValue);
        }
    }

    @Override
    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        Edge edge;
        if (this.sinkTime.isNewEvent(sourceId, timeId) && (edge = this.g.getEdge(edgeId)) != null) {
            this.sendEdgeAttributeRemoved(sourceId, timeId, edgeId, attribute);
            this.passYourWay = true;
            try {
                edge.removeAttribute(attribute);
            }
            finally {
                this.passYourWay = false;
            }
        }
    }

    @Override
    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        if (this.sinkTime.isNewEvent(sourceId, timeId)) {
            this.passYourWay = true;
            try {
                this.g.setAttribute(attribute, value);
            }
            finally {
                this.passYourWay = false;
            }
            this.sendGraphAttributeAdded(sourceId, timeId, attribute, value);
        }
    }

    @Override
    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        if (this.sinkTime.isNewEvent(sourceId, timeId)) {
            this.passYourWay = true;
            if (oldValue == null) {
                oldValue = this.g.getAttribute(attribute);
            }
            try {
                this.g.setAttribute(attribute, newValue);
            }
            finally {
                this.passYourWay = false;
            }
            this.sendGraphAttributeChanged(sourceId, timeId, attribute, oldValue, newValue);
        }
    }

    @Override
    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
        if (this.sinkTime.isNewEvent(sourceId, timeId)) {
            this.sendGraphAttributeRemoved(sourceId, timeId, attribute);
            this.passYourWay = true;
            try {
                this.g.removeAttribute(attribute);
            }
            finally {
                this.passYourWay = false;
            }
        }
    }

    @Override
    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        Node node;
        if (this.sinkTime.isNewEvent(sourceId, timeId) && (node = this.g.getNode(nodeId)) != null) {
            this.passYourWay = true;
            try {
                node.setAttribute(attribute, value);
            }
            finally {
                this.passYourWay = false;
            }
            this.sendNodeAttributeAdded(sourceId, timeId, nodeId, attribute, value);
        }
    }

    @Override
    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        Node node;
        if (this.sinkTime.isNewEvent(sourceId, timeId) && (node = this.g.getNode(nodeId)) != null) {
            this.passYourWay = true;
            if (oldValue == null) {
                oldValue = node.getAttribute(attribute);
            }
            try {
                node.setAttribute(attribute, newValue);
            }
            finally {
                this.passYourWay = false;
            }
            this.sendNodeAttributeChanged(sourceId, timeId, nodeId, attribute, oldValue, newValue);
        }
    }

    @Override
    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        Node node;
        if (this.sinkTime.isNewEvent(sourceId, timeId) && (node = this.g.getNode(nodeId)) != null) {
            this.sendNodeAttributeRemoved(sourceId, timeId, nodeId, attribute);
            this.passYourWay = true;
            try {
                node.removeAttribute(attribute);
            }
            finally {
                this.passYourWay = false;
            }
        }
    }

    @Override
    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        if (this.sinkTime.isNewEvent(sourceId, timeId)) {
            this.passYourWayAE = true;
            try {
                this.g.addEdge(edgeId, fromNodeId, toNodeId, directed);
            }
            finally {
                this.passYourWayAE = false;
            }
            this.sendEdgeAdded(sourceId, timeId, edgeId, fromNodeId, toNodeId, directed);
        }
    }

    @Override
    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        if (this.sinkTime.isNewEvent(sourceId, timeId)) {
            this.sendEdgeRemoved(sourceId, timeId, edgeId);
            this.passYourWay = true;
            try {
                this.g.removeEdge(edgeId);
            }
            finally {
                this.passYourWay = false;
            }
        }
    }

    @Override
    public void graphCleared(String sourceId, long timeId) {
        if (this.sinkTime.isNewEvent(sourceId, timeId)) {
            this.sendGraphCleared(sourceId, timeId);
            this.passYourWay = true;
            try {
                this.g.clear();
            }
            finally {
                this.passYourWay = false;
            }
        }
    }

    @Override
    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        if (this.sinkTime.isNewEvent(sourceId, timeId)) {
            this.passYourWay = true;
            try {
                this.g.addNode(nodeId);
            }
            finally {
                this.passYourWay = false;
            }
            this.sendNodeAdded(sourceId, timeId, nodeId);
        }
    }

    @Override
    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        if (this.sinkTime.isNewEvent(sourceId, timeId)) {
            this.dnSourceId = sourceId;
            this.dnTimeId = timeId;
            try {
                this.g.removeNode(nodeId);
            }
            finally {
                this.dnSourceId = null;
                this.dnTimeId = Long.MIN_VALUE;
            }
        }
    }

    @Override
    public void stepBegins(String sourceId, long timeId, double step) {
        if (this.sinkTime.isNewEvent(sourceId, timeId)) {
            this.passYourWay = true;
            try {
                this.g.stepBegins(step);
            }
            finally {
                this.passYourWay = false;
            }
            this.sendStepBegins(sourceId, timeId, step);
        }
    }

    public String toString() {
        return String.format("GraphListeners of %s.%s", this.g.getClass().getSimpleName(), this.g.getId());
    }
}

