/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.commonAncestor.quicksearch.module;

import ancestris.modules.commonAncestor.quicksearch.spi.SearchProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.lookup.Lookups;

public final class ProviderModel {
    private static final String SEARCH_PROVIDERS_FOLDER = "/QuickSearch";
    private static final String COMMAND_PREFIX = "command";
    private static HashMap<String, ProviderModel> instances = new HashMap();
    private List<Category> categories;
    private HashSet<String> knownCommands;
    private int maxResult = 7;
    private int allMaxResult = 30;

    private ProviderModel() {
    }

    public ProviderModel(String categoryName, String categoryDisplayName, SearchProvider searchProvider, String commandPrefix, int maxResult, int allMaxResult) {
        Category category = new Category(categoryName, categoryDisplayName, commandPrefix);
        category.addSearchProvider(searchProvider);
        this.categories = new ArrayList<Category>();
        this.categories.add(category);
        this.maxResult = maxResult;
        this.allMaxResult = allMaxResult;
    }

    public static ProviderModel getInstance() {
        ProviderModel providerModel = instances.get(SEARCH_PROVIDERS_FOLDER);
        if (providerModel == null) {
            providerModel = new ProviderModel();
            instances.put(SEARCH_PROVIDERS_FOLDER, providerModel);
        }
        return providerModel;
    }

    public List<Category> getCategories() {
        if (this.categories == null) {
            this.categories = this.loadCategories();
        }
        return this.categories;
    }

    public boolean isKnownCommand(String command) {
        if (this.knownCommands == null) {
            this.knownCommands = new HashSet();
            for (Category cat : this.getCategories()) {
                this.knownCommands.add(cat.getCommandPrefix());
            }
        }
        return this.knownCommands.contains(command);
    }

    int getAllMaxResult() {
        return this.allMaxResult;
    }

    int getMaxResult() {
        return this.maxResult;
    }

    private List<Category> loadCategories() {
        FileObject[] categoryFOs = FileUtil.getConfigFile((String)SEARCH_PROVIDERS_FOLDER).getChildren();
        List sortedCats = FileUtil.getOrder(Arrays.asList(categoryFOs), (boolean)false);
        ArrayList<Category> categoriesList = new ArrayList<Category>(sortedCats.size());
        for (FileObject curFO : sortedCats) {
            String displayName = null;
            try {
                displayName = curFO.getFileSystem().getDecorator().annotateName(curFO.getNameExt(), Collections.singleton(curFO));
            }
            catch (FileStateInvalidException ex) {
                Logger.getLogger(ProviderModel.class.getName()).log(Level.WARNING, "Obtaining display name for " + curFO + " failed.", ex);
            }
            String commandPrefix = null;
            Object cpAttr = curFO.getAttribute(COMMAND_PREFIX);
            if (cpAttr instanceof String) {
                commandPrefix = (String)cpAttr;
            }
            categoriesList.add(new Category(curFO, displayName, commandPrefix));
        }
        return categoriesList;
    }

    public static class Category {
        private FileObject fo;
        private String name;
        private String displayName;
        private String commandPrefix;
        private List<SearchProvider> providers;

        public Category(FileObject fo, String displayName, String commandPrefix) {
            this.fo = fo;
            this.name = fo.getNameExt();
            this.displayName = displayName;
            this.commandPrefix = commandPrefix;
        }

        public Category(String name, String displayName, String commandPrefix) {
            this.fo = null;
            this.name = name;
            this.displayName = displayName;
            this.commandPrefix = commandPrefix;
        }

        public List<SearchProvider> getProviders() {
            if (this.providers == null) {
                Collection catProviders = Lookups.forPath((String)this.fo.getPath()).lookupAll(SearchProvider.class);
                this.providers = new ArrayList<SearchProvider>(catProviders);
            }
            return this.providers;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getCommandPrefix() {
            return this.commandPrefix;
        }

        public void addSearchProvider(SearchProvider searchProvider) {
            if (this.providers == null) {
                this.providers = new ArrayList<SearchProvider>();
            }
            this.providers.add(searchProvider);
        }
    }
}

