/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.generator;

import java.util.Random;
import org.graphstream.algorithm.Toolkit;
import org.graphstream.algorithm.generator.BaseGenerator;
import org.graphstream.graph.Edge;

public class DorogovtsevMendesGenerator
extends BaseGenerator {
    protected int nodeNames = 0;

    public DorogovtsevMendesGenerator() {
        this.setUseInternalGraph(true);
    }

    public DorogovtsevMendesGenerator(Random random) {
        this();
        this.random = random;
    }

    @Override
    public void begin() {
        this.random = this.random == null ? new Random(System.currentTimeMillis()) : this.random;
        this.addNode("0");
        this.addNode("1");
        this.addNode("2");
        this.addEdge("0-1", "0", "1");
        this.addEdge("1-2", "1", "2");
        this.addEdge("2-0", "2", "0");
        this.nodeNames = 3;
    }

    @Override
    public boolean nextEvents() {
        String name = Integer.toString(this.nodeNames++);
        Edge edge = Toolkit.randomEdge(this.internalGraph, this.random);
        String n0 = edge.getNode0().getId();
        String n1 = edge.getNode1().getId();
        this.addNode(name);
        this.addEdge(n0 + "-" + name, n0, name);
        this.addEdge(n1 + "-" + name, n1, name);
        return true;
    }

    @Override
    public void end() {
        super.end();
    }
}

