/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.app.App;
import ancestris.app.Semaphore;
import ancestris.app.StartupFiles;
import ancestris.gedcom.GedcomDirectory;
import genj.gedcom.Context;
import genj.util.DirectAccessTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ControlCenter {
    private int isLoaded = 1;
    private final Object loadLock = new Object();
    private static final Logger LOG = Logger.getLogger("ancestris");

    public void load(Collection<FileObject> files) {
        SwingUtilities.invokeLater(new ActionAutoOpen(files));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady(int i) {
        if (this.isLoaded == 0) {
            return true;
        }
        Object object = this.loadLock;
        synchronized (object) {
            if (i != 0) {
                this.isLoaded += i;
                this.loadLock.notifyAll();
                return true;
            }
            try {
                while (this.isLoaded != 0) {
                    this.loadLock.wait();
                }
                return true;
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return false;
            }
        }
    }

    public void nbDoExit(Runnable postExitCode) {
        Semaphore sem = new Semaphore();
        sem.acquire();
        StartupFiles.getDefault().addOpenedGedcoms();
        for (Context context : GedcomDirectory.getDefault().getContexts()) {
            if (GedcomDirectory.getDefault().closeGedcom(context)) continue;
            postExitCode = null;
        }
        sem.release(postExitCode);
    }

    @Deprecated
    public Context getOpenedContext(String gedName) {
        if (gedName == null) {
            return null;
        }
        DirectAccessTokenizer tokens = new DirectAccessTokenizer(gedName, ",", false);
        String url = tokens.get(0);
        if (url == null) {
            return null;
        }
        for (Context context : GedcomDirectory.getDefault().getContexts()) {
            if (!url.equals(context.getGedcom().getOrigin().toString())) continue;
            return context;
        }
        return null;
    }

    private class ActionAutoOpen
    implements Runnable {
        private Collection<FileObject> files = null;

        private ActionAutoOpen(Collection<FileObject> theFiles) {
            if (theFiles == null) {
                theFiles = new ArrayList<FileObject>();
            }
            this.files = theFiles;
        }

        @Override
        public void run() {
            TopComponent welcome;
            if (this.files != null && !this.files.isEmpty()) {
                for (FileObject file : this.files) {
                    GedcomDirectory.getDefault().openGedcom(file);
                }
            }
            if ((welcome = WindowManager.getDefault().findTopComponent("Welcome")) != null) {
                welcome.requestActive();
            }
            App.center.isReady(-1);
        }
    }
}

