/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app.actions;

import ancestris.app.actions.UpperNameTask;
import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.util.ProgressListener;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.PropertyName;
import genj.util.Trackable;
import java.awt.event.ActionEvent;
import org.openide.util.NbBundle;
import spin.Spin;

public class UpperCaseNamesAction
extends AbstractAncestrisContextAction {
    public UpperCaseNamesAction() {
        this.setIconBase("ancestris/view/images/Uppercase.png");
        this.setText(NbBundle.getMessage(UpperCaseNamesAction.class, (String)"action.upperCaseNames"));
        this.setTip(NbBundle.getMessage(UpperCaseNamesAction.class, (String)"action.upperCaseNames.tip"));
    }

    protected void contextChanged() {
        this.setEnabled(!this.contextProperties.isEmpty());
        super.contextChanged();
    }

    public void actionPerformedImpl(ActionEvent ae) {
        if (this.getContext() == null) {
            return;
        }
        UpperNameTask dj = (UpperNameTask)Spin.off((Object)new DoJob(this.getGedcom()));
        ProgressListener.Dispatcher.processStarted((Trackable)dj);
        try {
            this.getGedcom().doUnitOfWork(g -> dj.run());
        }
        catch (GedcomException e) {
            DialogManager.createError(null, (String)e.getMessage()).show();
        }
        ProgressListener.Dispatcher.processStopped((Trackable)dj);
    }

    private class DoJob
    implements UpperNameTask {
        private int counter = 0;
        private int maxCounter = 0;
        private boolean cancel = false;
        private final Gedcom gedcom;

        DoJob(Gedcom g) {
            this.gedcom = g;
        }

        @Override
        public void run() {
            this.maxCounter = this.gedcom.getIndis().size();
            this.gedcom.getIndis().forEach(indi -> {
                for (PropertyName pn : indi.getProperties(PropertyName.class)) {
                    pn.upperCaseName();
                }
                ++this.counter;
            });
        }

        public void cancelTrackable() {
            this.cancel = true;
        }

        public int getProgress() {
            return 100 * this.counter / this.maxCounter;
        }

        public String getState() {
            return this.gedcom.getName();
        }

        public String getTaskName() {
            return "UpperCaseName";
        }
    }
}

