/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.notepad;

import ancestris.modules.notepad.SearchNote;
import java.awt.Color;
import java.awt.Component;
import java.time.format.DateTimeFormatter;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class SearchNoteListRenderer
extends JLabel
implements ListCellRenderer<SearchNote> {
    private static final DateTimeFormatter RENDER_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");

    public SearchNoteListRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends SearchNote> list, SearchNote value, int index, boolean isSelected, boolean cellHasFocus) {
        String displayGedcom = "-";
        if (value.getGedcom() != null) {
            displayGedcom = value.getGedcom().getDisplayName();
        }
        String displayContent = "";
        if (value.getContent() != null && (displayContent = value.getContent()).contains("\n")) {
            displayContent = displayContent.substring(0, displayContent.indexOf(10) + 1);
        }
        this.setText(String.format("<html>&nbsp;%d .&nbsp; %.30s<br>&nbsp; %s &nbsp;-&nbsp; %s</html>", index, displayContent, displayGedcom, value.getLastModified().format(RENDER_FORMAT)));
        if (isSelected) {
            this.setBackground(new Color(list.getSelectionBackground().getRGB()));
            this.setForeground(new Color(list.getSelectionForeground().getRGB()));
        } else {
            this.setBackground(new Color(list.getBackground().getRGB()));
            this.setForeground(new Color(list.getForeground().getRGB()));
        }
        return this;
    }
}

