/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.geo.spi;

import net.java.html.BrwsrCtx;
import net.java.html.geo.Position;
import org.netbeans.html.geo.impl.Accessor;
import org.netbeans.html.geo.spi.CoordImpl;

public abstract class GLProvider<Coords, Watch> {
    protected abstract Watch start(Query var1);

    protected abstract void stop(Watch var1);

    protected final void callback(final Query c, final long timestamp, final Coords position, final Exception ex) {
        c.ctx.execute(new Runnable(){

            @Override
            public void run() {
                if (ex == null) {
                    c.peer.onLocation(new Position(timestamp, new CoordImpl<Object>(position, GLProvider.this)));
                } else {
                    c.peer.onError(ex);
                }
            }
        });
    }

    protected abstract double latitude(Coords var1);

    protected abstract double longitude(Coords var1);

    protected abstract double accuracy(Coords var1);

    protected abstract Double altitude(Coords var1);

    protected abstract Double altitudeAccuracy(Coords var1);

    protected abstract Double heading(Coords var1);

    protected abstract Double speed(Coords var1);

    static {
        Accessor accessor = new Accessor(false){

            @Override
            public <Watch> Watch start(GLProvider<?, Watch> p, Accessor peer, boolean oneTime, boolean enableHighAccuracy, long timeout, long maximumAge) {
                return p.start(new Query(peer, oneTime, enableHighAccuracy, timeout, maximumAge));
            }

            @Override
            public <Watch> void stop(GLProvider<?, Watch> p, Watch w) {
                p.stop(w);
            }

            @Override
            public void onError(Exception ex) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onLocation(Position position) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static final class Query {
        private final boolean oneTime;
        private final boolean enableHighAccuracy;
        private final long timeout;
        private final long maximumAge;
        private final BrwsrCtx ctx;
        final Accessor peer;

        Query(Accessor peer, boolean oneTime, boolean enableHighAccuracy, long timeout, long maximumAge) {
            this.peer = peer;
            this.oneTime = oneTime;
            this.enableHighAccuracy = enableHighAccuracy;
            this.timeout = timeout;
            this.maximumAge = maximumAge;
            this.ctx = BrwsrCtx.findDefault(Query.class);
        }

        public final boolean isOneTime() {
            return this.oneTime;
        }

        public final boolean isHighAccuracy() {
            return this.enableHighAccuracy;
        }

        public final long getTimeout() {
            return this.timeout;
        }

        public final long getMaximumAge() {
            return this.maximumAge;
        }
    }
}

