/*
 * Decompiled with CFR 0.152.
 */
package swingx.docking.dock;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import swingx.docking.Dock;
import swingx.docking.Dockable;
import swingx.docking.Docked;
import swingx.docking.DockingPane;
import swingx.docking.border.LineBorder;
import swingx.docking.layout.FloatingLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabbedDock
extends Dock {
    private static EmptyBorder emptyBorder = new EmptyBorder(0, 0, 0, 0);
    private JTabbedPane tabbedPane = this.createTabbedPane();
    private List<Tab> tabs = new ArrayList<Tab>();

    public TabbedDock(DockingPane dockingPane) {
        super(dockingPane);
        this.setLayout(new BorderLayout());
        this.tabbedPane = this.createTabbedPane();
        this.add(this.tabbedPane);
    }

    @Override
    public JComponent getDragInitiator() {
        return this.tabbedPane;
    }

    protected JTabbedPane createTabbedPane() {
        return new JTabbedPane();
    }

    @Override
    public List<Object> getDockableKeys() {
        ArrayList<Object> keys = new ArrayList<Object>();
        for (Tab tab : this.tabs) {
            keys.add(tab.getKey());
        }
        return keys;
    }

    @Override
    public boolean containsDockable(Object key) {
        return this.getTab(key) != null;
    }

    @Override
    public Dockable putDockable(Object key, Dockable dockable) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        Tab tab = this.getTab(key);
        if (tab == null) {
            tab = new Tab(key);
            this.tabs.add(0, tab);
        }
        Dockable old = tab.getDockable();
        tab.setDockable(dockable);
        this.fireDockChanged();
        this.revalidate();
        this.repaint();
        return old;
    }

    @Override
    public Dockable getSelectedDockable() {
        Tab tab = (Tab)this.tabbedPane.getSelectedComponent();
        if (tab == null) {
            return null;
        }
        return tab.getDockable();
    }

    @Override
    public void setSelectedDockable(Dockable dockable) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        this.tabbedPane.setSelectedComponent(this.getTab(dockable));
    }

    @Override
    public Dockable getDockable(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        Tab tab = this.getTab(key);
        if (tab == null) {
            throw new IllegalArgumentException("unkown key");
        }
        return tab.getDockable();
    }

    @Override
    public Dockable removeDockable(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        Tab tab = this.getTab(key);
        if (tab == null) {
            throw new IllegalArgumentException("unkown key");
        }
        Dockable dockable = tab.getDockable();
        tab.setDockable(null);
        tab.dispose();
        this.tabs.remove(tab);
        this.fireDockChanged();
        return dockable;
    }

    @Override
    public boolean hasDockable() {
        return !this.tabs.isEmpty();
    }

    @Override
    public int getDockableCount() {
        return this.tabs.size();
    }

    @Override
    public List<Object> getVisibleDockableKeys() {
        ArrayList<Object> keys = new ArrayList<Object>();
        for (Tab tab : this.tabs) {
            if (tab.getDockable() == null) continue;
            keys.add(tab.getKey());
        }
        return keys;
    }

    @Override
    public int getVisibleDockableCount() {
        return this.tabbedPane.getTabCount();
    }

    @Override
    public void closeDockable(Dockable dockable) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        Tab tab = this.getTab(dockable);
        if (tab == null) {
            throw new IllegalArgumentException("unkown dockable '" + dockable + "'");
        }
        if (dockable.undocking()) {
            this.getDockingPane().putDockable(tab.getKey(), null);
        }
    }

    @Override
    public Object getDockableKey(Point point) {
        int index = this.tabbedPane.getUI().tabForCoordinate(this.tabbedPane, point.x, point.y);
        if (index == -1) {
            return null;
        }
        Tab tab = (Tab)this.tabbedPane.getComponentAt(index);
        return tab.getKey();
    }

    private Tab getTab(Object key) {
        for (Tab tab : this.tabs) {
            if (!tab.hasKey(key)) continue;
            return tab;
        }
        return null;
    }

    private Tab getTab(Dockable dockable) {
        for (Tab tab : this.tabs) {
            if (tab.getDockable() == null || !tab.getDockable().equals(dockable)) continue;
            return tab;
        }
        return null;
    }

    protected JComponent customizeContent(JComponent content) {
        if (content instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)content;
            scrollPane.setBorder(emptyBorder);
            scrollPane.setViewportBorder(emptyBorder);
        }
        return content;
    }

    private class Tab
    extends JPanel
    implements Docked {
        private Object key;
        private Dockable dockable;
        private JPanel header = new JPanel();
        private JToolBar toolBar = new JToolBar(){

            protected void paintComponent(Graphics g) {
            }
        };
        private JLabel statusLabel = new JLabel();
        private JComponent content;

        private Tab(Object key) {
            if (key == null) {
                throw new IllegalArgumentException("key must not be null");
            }
            this.key = key;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.header.setLayout(new FloatingLayout());
            this.header.setBorder(new LineBorder());
            this.header.setOpaque(false);
            this.header.setVisible(false);
            this.add((Component)this.header, "North");
            if (UIManager.getLookAndFeel().getName().indexOf("Windows") != -1) {
                this.toolBar.setRollover(true);
            }
            this.toolBar.setFloatable(false);
            this.toolBar.setOpaque(false);
            this.toolBar.setVisible(false);
            this.toolBar.setBorder(emptyBorder);
            this.toolBar.setAlignmentX(1.0f);
            this.header.add(this.toolBar);
            this.statusLabel.setOpaque(false);
            this.statusLabel.setVisible(false);
            this.statusLabel.setAlignmentX(0.0f);
            this.header.add(this.statusLabel);
        }

        public void dispose() {
            this.key = null;
        }

        public boolean hasKey(Object key) {
            return this.key.equals(key);
        }

        private Object getKey() {
            return this.key;
        }

        private Dockable getDockable() {
            return this.dockable;
        }

        private void setDockable(Dockable dockable) {
            Tab selectedTab = (Tab)TabbedDock.this.tabbedPane.getSelectedComponent();
            if (this.dockable != null) {
                TabbedDock.this.tabbedPane.remove(this);
                this.toolBar.removeAll();
                this.setStatus(null);
                if (this.content != null) {
                    this.remove(this.content);
                    this.content = null;
                }
                this.dockable.undocked();
            }
            this.dockable = dockable;
            if (this.dockable != null) {
                int visibleIndex = 0;
                for (Tab tab : TabbedDock.this.tabs) {
                    if (tab == this) break;
                    if (tab.getDockable() == null) continue;
                    ++visibleIndex;
                }
                TabbedDock.this.tabbedPane.add((Component)this, visibleIndex);
                dockable.docked(this);
            }
            if (selectedTab != null && selectedTab != this) {
                TabbedDock.this.tabbedPane.setSelectedComponent(selectedTab);
            }
            this.revalidate();
            this.repaint();
        }

        public void setTitle(String title) {
            int index = TabbedDock.this.tabbedPane.indexOfComponent(this);
            TabbedDock.this.tabbedPane.setTitleAt(index, title);
        }

        public void setIcon(Icon icon) {
            int index = TabbedDock.this.tabbedPane.indexOfComponent(this);
            TabbedDock.this.tabbedPane.setIconAt(index, icon);
        }

        public void setStatus(String status) {
            this.statusLabel.setText(status);
            this.statusLabel.setVisible(status != null);
            this.updateHeaderVisibility();
        }

        public void setMenu(JMenu menu) {
        }

        public JButton addTool(Action action) {
            JButton button = this.toolBar.add(action);
            button.setOpaque(false);
            button.setFocusable(true);
            button.setRequestFocusEnabled(false);
            this.toolBar.setVisible(true);
            this.updateHeaderVisibility();
            return button;
        }

        public JComponent addTool(JComponent component) {
            this.toolBar.add(component);
            component.setFocusable(true);
            component.setRequestFocusEnabled(false);
            this.toolBar.setVisible(true);
            this.updateHeaderVisibility();
            return component;
        }

        public void addToolSeparator() {
            this.toolBar.addSeparator();
            this.toolBar.setVisible(true);
            this.updateHeaderVisibility();
        }

        public void clearTools() {
            this.toolBar.removeAll();
            this.toolBar.setVisible(false);
            this.updateHeaderVisibility();
        }

        private void updateHeaderVisibility() {
            this.header.setVisible(this.toolBar.isVisible() || this.statusLabel.isVisible());
        }

        public void setContent(JComponent content) {
            if (this.content != null) {
                this.remove(this.content);
            }
            this.content = TabbedDock.this.customizeContent(content);
            if (this.content != null) {
                this.add((Component)this.content, "Center");
            }
            this.revalidate();
            this.repaint();
        }
    }
}

