/*
 * Decompiled with CFR 0.152.
 */
package genj.report;

import ancestris.core.actions.SubMenuAction;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.io.Filter;
import genj.report.ReportPlugin;
import genj.report.ReportViewFactory;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ReportSubMenu
extends SubMenuAction {
    private Gedcom gedcom;
    private Filter filter;

    public ReportSubMenu(Gedcom gedcom, Filter filter) {
        this.filter = filter;
        this.gedcom = gedcom;
        this.setImage((Icon)ReportViewFactory.IMG);
        this.setTip(NbBundle.getMessage(ReportSubMenu.class, (String)"report.submenu.tip"));
    }

    public void actionPerformed(ActionEvent event) {
        Indi[] indis = this.getIndis();
        if (indis.length == 0) {
            return;
        }
        Collection<Action> actions = ReportPlugin.getReportActions(this.getIndis(), this.gedcom);
        JPopupMenu menu = Utilities.actionsToPopup((Action[])actions.toArray(new Action[0]), (Lookup)Lookup.EMPTY);
        Component source = (Component)event.getSource();
        menu.show(source, 0, source.getHeight());
    }

    private Indi[] getIndis() {
        ArrayList<Indi> indis = new ArrayList<Indi>();
        for (Indi indi : this.gedcom.getIndis()) {
            if (this.filter.veto((Entity)indi)) continue;
            indis.add(indi);
        }
        return indis.toArray(new Indi[indis.size()]);
    }
}

