/*
 * Decompiled with CFR 0.152.
 */
package genj.edit;

import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.util.Registry;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ChoosePropertyBean
extends JPanel {
    private Registry registry = Registry.get(this.getClass());
    private ButtonGroup buttonGroup1;
    private JLabel chooseLabel;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JSplitPane jSplitPane;
    private JList<MetaProperty> lChoose;
    private JRadioButton rbChoose;
    private JRadioButton rbCustom;
    private JCheckBox subPropCheck;
    private JTextField tfCustom;
    private JTextPane tpInfo;

    public ChoosePropertyBean(Property parent) {
        List<MetaProperty> defs = Arrays.asList(parent.getNestedMetaProperties(12));
        this.initComponents();
        Collections.sort(defs, (o1, o2) -> {
            MetaProperty m1 = (MetaProperty)o1;
            MetaProperty m2 = (MetaProperty)o2;
            return m1.getName().compareTo(m2.getName());
        });
        boolean listEmpty = defs.isEmpty();
        this.rbChoose.setSelected(!listEmpty);
        DefaultListModel<MetaProperty> list = new DefaultListModel<MetaProperty>();
        list.addAll(defs);
        this.lChoose.setModel(list);
        this.lChoose.setEnabled(!listEmpty);
        this.lChoose.setCellRenderer(new MetaDefRenderer());
        this.tpInfo.setText("");
        this.rbCustom.setSelected(listEmpty);
        this.tfCustom.setEnabled(listEmpty);
        if (!listEmpty) {
            this.lChoose.setSelectedIndex(0);
        }
        this.jSplitPane.setDividerLocation(this.registry.get("assistantDividerLocation", 300));
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.chooseLabel = new JLabel();
        this.rbChoose = new JRadioButton();
        this.rbCustom = new JRadioButton();
        this.tfCustom = new JTextField();
        this.subPropCheck = new JCheckBox();
        this.jSplitPane = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.lChoose = new JList();
        this.jScrollPane3 = new JScrollPane();
        this.tpInfo = new JTextPane();
        Mnemonics.setLocalizedText((JLabel)this.chooseLabel, (String)NbBundle.getMessage(ChoosePropertyBean.class, (String)"add.choose"));
        this.buttonGroup1.add(this.rbChoose);
        Mnemonics.setLocalizedText((AbstractButton)this.rbChoose, (String)NbBundle.getMessage(ChoosePropertyBean.class, (String)"choose.known"));
        this.rbChoose.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ChoosePropertyBean.this.rbChooseItemStateChanged(evt);
            }
        });
        this.buttonGroup1.add(this.rbCustom);
        Mnemonics.setLocalizedText((AbstractButton)this.rbCustom, (String)NbBundle.getMessage(ChoosePropertyBean.class, (String)"choose.new"));
        this.rbCustom.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ChoosePropertyBean.this.rbCustomItemStateChanged(evt);
            }
        });
        this.tfCustom.setText(NbBundle.getMessage(ChoosePropertyBean.class, (String)"ChoosePropertyBean.tfCustom.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.subPropCheck, (String)NbBundle.getMessage(ChoosePropertyBean.class, (String)"add.default_too"));
        this.lChoose.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ChoosePropertyBean.this.lChooseValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lChoose);
        this.jSplitPane.setLeftComponent(this.jScrollPane1);
        this.jScrollPane3.setViewportView(this.tpInfo);
        this.jSplitPane.setRightComponent(this.jScrollPane3);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane).addComponent(this.tfCustom).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chooseLabel).addComponent(this.rbChoose).addComponent(this.rbCustom).addComponent(this.subPropCheck)).addGap(0, 246, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.chooseLabel).addGap(18, 18, 18).addComponent(this.rbChoose).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane, -1, 214, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.rbCustom).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfCustom, -2, -1, -2).addGap(18, 18, 18).addComponent(this.subPropCheck).addContainerGap()));
    }

    private void rbChooseItemStateChanged(ItemEvent evt) {
        this.radioButtonChanged(evt);
    }

    private void rbCustomItemStateChanged(ItemEvent evt) {
        this.radioButtonChanged(evt);
    }

    private void lChooseValueChanged(ListSelectionEvent evt) {
        this.listSelectionChanged(evt);
    }

    public void radioButtonChanged(ItemEvent e) {
        if (e.getSource() == this.rbChoose) {
            this.lChoose.setEnabled(true);
            this.tfCustom.setEnabled(false);
            this.lChoose.requestFocusInWindow();
        }
        if (e.getSource() == this.rbCustom) {
            this.lChoose.clearSelection();
            this.lChoose.setEnabled(false);
            this.tfCustom.setEnabled(true);
            this.tfCustom.requestFocusInWindow();
        }
    }

    public void listSelectionChanged(ListSelectionEvent e) {
        List<MetaProperty> selection = this.lChoose.getSelectedValuesList();
        if (selection == null || selection.isEmpty()) {
            this.tpInfo.setText("");
            return;
        }
        MetaProperty meta = selection.get(selection.size() - 1);
        this.tpInfo.setText(meta.getInfo());
        if (!this.rbChoose.isSelected()) {
            this.rbChoose.doClick();
        }
    }

    public String[] getSelectedTags() {
        String[] stringArray;
        if (this.rbChoose.isSelected()) {
            List<MetaProperty> objs = this.lChoose.getSelectedValuesList();
            String[] result = new String[objs.size()];
            for (int i = 0; i < objs.size(); ++i) {
                result[i] = objs.get(i).getTag();
            }
            return result;
        }
        String tag = this.tfCustom.getText();
        if (tag != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = tag;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public boolean isCheckSelected() {
        return this.subPropCheck.isSelected();
    }

    public void saveSettings() {
        int size = Math.max(this.jSplitPane.getDividerLocation(), 100);
        this.registry.put("assistantDividerLocation", size);
    }

    class MetaDefRenderer
    extends DefaultListCellRenderer
    implements ListCellRenderer<Object> {
        MetaDefRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Object> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            MetaProperty def = (MetaProperty)value;
            this.setText(def.getName() + " (" + def.getTag() + ")");
            this.setIcon((Icon)def.getImage());
            return this;
        }
    }
}

