/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.edit.actions.CreateParent;
import genj.edit.actions.CreateRelationship;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.util.swing.ImageIcon;
import javax.swing.Icon;

public class CreateSpouse
extends CreateRelationship {
    private Indi spouse;
    private static final ImageIcon IMG_SPOUSE = new ImageIcon(CreateParent.class, "/genj/edit/images/Spouse.png");

    public CreateSpouse() {
        this(null);
    }

    public CreateSpouse(Indi spouse) {
        super(resources.getString("add.spouse"), "INDI");
        this.setImage((Icon)IMG_SPOUSE);
        this.setContextProperties((Property)spouse);
        this.contextChanged();
    }

    protected final void contextChanged() {
        Indi contextSpouse = null;
        if (this.contextProperties.size() == 1 && this.contextProperties.get(0) instanceof Indi) {
            contextSpouse = (Indi)this.contextProperties.get(0);
        }
        if (contextSpouse != null) {
            this.spouse = contextSpouse;
            this.setEnabled(true);
            this.setTip(this.getDescription());
        } else {
            this.setEnabled(false);
            this.setTip(null);
        }
    }

    @Override
    public String getWarning(Entity target) {
        Fam[] fams;
        if (this.spouse == null) {
            return null;
        }
        int n = 0;
        for (Fam fam : fams = this.spouse.getFamiliesWhereSpouse()) {
            if (fam.getOtherSpouse(this.spouse) == null) continue;
            ++n;
        }
        if (n > 0) {
            return resources.getString("add.spouse.warning", new Object[]{this.spouse.toString(), "" + n});
        }
        return null;
    }

    @Override
    public String getDescription() {
        return resources.getString("add.spouse.of", new Object[]{this.spouse});
    }

    @Override
    protected Property change(Entity target, boolean targetIsNew) throws GedcomException {
        Fam[] fams = this.spouse.getFamiliesWhereSpouse();
        Fam fam = null;
        Indi otherSpouse = (Indi)target;
        if (fams.length > 0) {
            fam = fams[0];
        }
        if (fam == null || fam.getNoOfSpouses() >= 2) {
            fam = (Fam)this.spouse.getGedcom().createEntity("FAM").addDefaultProperties();
            fam.setSpouse(this.spouse);
        }
        if (targetIsNew) {
            int spouseSex = this.spouse.getSex();
            if (1 == spouseSex) {
                otherSpouse.setSex(2);
            } else if (2 == spouseSex) {
                otherSpouse.setSex(1);
            }
        }
        return fam.setSpouse(otherSpouse).getTarget();
    }
}

