/*
 * Decompiled with CFR 0.152.
 */
package org.geonames;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Comparator;
import org.geonames.WebService;

public class WikipediaArticle {
    private String language;
    private String title;
    private String summary;
    private String wikipediaUrl;
    private String feature;
    private int population;
    private Integer elevation;
    private double latitude;
    private double longitude;
    private String thumbnailImg;
    private int rank;
    public static final Comparator ELEVATION_ORDER = new Comparator<WikipediaArticle>(){

        @Override
        public int compare(WikipediaArticle o1, WikipediaArticle o2) {
            return Double.compare(o2.elevation.intValue(), o1.elevation.intValue());
        }
    };
    public static final Comparator RANK_ORDER = new Comparator<WikipediaArticle>(){

        @Override
        public int compare(WikipediaArticle o1, WikipediaArticle o2) {
            return Double.compare(o2.rank, o1.rank);
        }
    };

    public Integer getElevation() {
        return this.elevation;
    }

    public void setElevation(int elevation) {
        this.elevation = elevation;
    }

    public String getFeature() {
        return this.feature;
    }

    public void setFeature(String feature) {
        this.feature = feature;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public int getPopulation() {
        return this.population;
    }

    public void setPopulation(int population) {
        this.population = population;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getWikipediaUrl() {
        if (this.wikipediaUrl == null || WebService.isAndroid()) {
            String urlTitle = this.title.replace(' ', '_');
            try {
                urlTitle = URLEncoder.encode(urlTitle, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            String lang = this.language;
            if (WebService.isAndroid()) {
                lang = lang + ".m";
            }
            return "http://" + lang + ".wikipedia.org/wiki/" + urlTitle;
        }
        return this.wikipediaUrl;
    }

    public void setWikipediaUrl(String wikipediaURL) {
        this.wikipediaUrl = wikipediaURL;
    }

    public String getThumbnailImg() {
        return this.thumbnailImg;
    }

    public void setThumbnailImg(String thumbnailImg) {
        this.thumbnailImg = thumbnailImg;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }
}

