/*
 * Decompiled with CFR 0.152.
 */
package org.geonames.utils;

public class Distance {
    public static final double EARTH_RADIUS_KM = 6372.0;
    public static final double EARTH_RADIUS_MILES = 3963.0;

    public static double distance(double lat1, double lng1, double lat2, double lng2, char unit, int numberOfDigits) {
        double a1 = Math.toRadians(lat1);
        double b1 = Math.toRadians(lng1);
        double a2 = Math.toRadians(lat2);
        double b2 = Math.toRadians(lng2);
        double d = Math.acos(Math.cos(a1) * Math.cos(b1) * Math.cos(a2) * Math.cos(b2) + Math.cos(a1) * Math.sin(b1) * Math.cos(a2) * Math.sin(b2) + Math.sin(a1) * Math.sin(a2));
        double dist = 0.0;
        dist = unit == 'M' ? d * 3963.0 : d * 6372.0;
        if (Double.isNaN(dist)) {
            dist = Math.sqrt(Math.pow(Math.abs(lat1 - lat2), 2.0) + Math.pow(Math.abs(lng1 - lng2), 2.0));
            dist = unit == 'M' ? (dist *= 69.0) : (dist *= 110.0);
        }
        if (numberOfDigits == 0) {
            dist = (int)dist;
        } else if (numberOfDigits > 0) {
            double factor = Math.pow(10.0, numberOfDigits);
            dist = Math.floor(dist * factor) / factor;
        }
        return dist;
    }

    public static double distanceKM(double lat1, double lng1, double lat2, double lng2) {
        return Distance.distance(lat1, lng1, lat2, lng2, 'K', 3);
    }

    public static double distanceMiles(double lat1, double lng1, double lat2, double lng2) {
        return Distance.distance(lat1, lng1, lat2, lng2, 'M', 3);
    }
}

