/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.viewers.media;

import ancestris.modules.viewers.media.MediaChooser;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.PropertyXRef;
import genj.util.Registry;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class MediaFilterPanel
extends JPanel {
    private String default_selection;
    private Registry registry = null;
    private MediaChooser parent = null;
    JRadioButton[] sortButtons = new JRadioButton[4];
    private boolean isReady = false;
    private JCheckBox asentityCheckBox;
    private JCheckBox aspropertyCheckBox;
    private JPanel criteriaPanel;
    private JComboBox<String> entitiesComboBox;
    private JLabel entitiesLabel;
    private JComboBox<String> eventsComboBox;
    private JLabel eventsLabel;
    private JRadioButton filenameRadioButton;
    private JRadioButton filepathRadioButton;
    private JLabel filterLabel;
    private JComboBox<String> foldersComboBox;
    private JLabel foldersLabel;
    private JCheckBox foundCheckBox;
    private JRadioButton frequencyRadioButton;
    private JLabel jLabel1;
    private JCheckBox localCheckBox;
    private JPanel minPanel;
    private JCheckBox monofilesCheckBox;
    private JCheckBox multifilesCheckBox;
    private JLabel nbLabel;
    private JCheckBox remoteCheckBox;
    private JToggleButton showMoreToggleButton;
    private ButtonGroup sortButtonGroup;
    private JLabel sortLabel;
    private JPanel sortPanel;
    private JTextField textFilter;
    private JRadioButton titleRadioButton;
    private JCheckBox unfoundCheckBox;
    private JCheckBox unusedCheckBox;
    private JCheckBox usedCheckBox;

    public MediaFilterPanel() {
        this.initComponents();
    }

    public MediaFilterPanel(Gedcom gedcom, MediaChooser parent) {
        this.default_selection = NbBundle.getMessage(this.getClass(), (String)"Cat_ALL");
        this.registry = gedcom.getRegistry();
        this.parent = parent;
        this.initComponents();
        this.sortButtons[0] = this.titleRadioButton;
        this.sortButtons[1] = this.filenameRadioButton;
        this.sortButtons[2] = this.filepathRadioButton;
        this.sortButtons[3] = this.frequencyRadioButton;
        this.updatePanels(false);
        this.textFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.filter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.filter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            private void filter() {
                MediaFilterPanel.this.updateList();
            }
        });
        this.resetCombosValues();
    }

    private void loadSettings() {
        this.showMoreToggleButton.setSelected(this.registry.get("media.filter.toggle", false));
        this.updatePanels(this.showMoreToggleButton.isSelected());
        this.textFilter.setText(this.registry.get("media.filter.text", ""));
        this.eventsComboBox.setSelectedItem(this.registry.get("media.filter.events", this.default_selection));
        this.entitiesComboBox.setSelectedItem(this.registry.get("media.filter.entities", this.default_selection));
        this.foldersComboBox.setSelectedItem(this.registry.get("media.filter.folders", this.default_selection));
        this.usedCheckBox.setSelected(this.registry.get("media.filter.used", true));
        this.unusedCheckBox.setSelected(this.registry.get("media.filter.unused", true));
        this.foundCheckBox.setSelected(this.registry.get("media.filter.found", true));
        this.unfoundCheckBox.setSelected(this.registry.get("media.filter.unfound", true));
        this.localCheckBox.setSelected(this.registry.get("media.filter.local", true));
        this.remoteCheckBox.setSelected(this.registry.get("media.filter.remote", true));
        this.monofilesCheckBox.setSelected(this.registry.get("media.filter.monofiles", true));
        this.multifilesCheckBox.setSelected(this.registry.get("media.filter.multifiles", true));
        this.asentityCheckBox.setSelected(this.registry.get("media.filter.asentity", true));
        this.aspropertyCheckBox.setSelected(this.registry.get("media.filter.asproperty", true));
        this.titleRadioButton.setSelected(this.registry.get("media.filter.title", true));
        this.filenameRadioButton.setSelected(this.registry.get("media.filter.filename", false));
        this.filepathRadioButton.setSelected(this.registry.get("media.filter.filepath", false));
        this.frequencyRadioButton.setSelected(this.registry.get("media.filter.frequency", false));
    }

    private void saveSettings() {
        this.registry.put("media.filter.toggle", Boolean.valueOf(this.showMoreToggleButton.isSelected()));
        this.registry.put("media.filter.text", this.textFilter.getText());
        this.registry.put("media.filter.events", this.eventsComboBox.getSelectedItem().toString());
        this.registry.put("media.filter.entities", this.entitiesComboBox.getSelectedItem().toString());
        this.registry.put("media.filter.folders", this.foldersComboBox.getSelectedItem().toString());
        this.registry.put("media.filter.used", Boolean.valueOf(this.usedCheckBox.isSelected()));
        this.registry.put("media.filter.unused", Boolean.valueOf(this.unusedCheckBox.isSelected()));
        this.registry.put("media.filter.found", Boolean.valueOf(this.foundCheckBox.isSelected()));
        this.registry.put("media.filter.unfound", Boolean.valueOf(this.unfoundCheckBox.isSelected()));
        this.registry.put("media.filter.local", Boolean.valueOf(this.localCheckBox.isSelected()));
        this.registry.put("media.filter.remote", Boolean.valueOf(this.remoteCheckBox.isSelected()));
        this.registry.put("media.filter.monofiles", Boolean.valueOf(this.monofilesCheckBox.isSelected()));
        this.registry.put("media.filter.multifiles", Boolean.valueOf(this.multifilesCheckBox.isSelected()));
        this.registry.put("media.filter.asentity", Boolean.valueOf(this.asentityCheckBox.isSelected()));
        this.registry.put("media.filter.asproperty", Boolean.valueOf(this.aspropertyCheckBox.isSelected()));
        this.registry.put("media.filter.title", Boolean.valueOf(this.titleRadioButton.isSelected()));
        this.registry.put("media.filter.filename", Boolean.valueOf(this.filenameRadioButton.isSelected()));
        this.registry.put("media.filter.filepath", Boolean.valueOf(this.filepathRadioButton.isSelected()));
        this.registry.put("media.filter.frequency", Boolean.valueOf(this.frequencyRadioButton.isSelected()));
    }

    private void initComponents() {
        this.sortButtonGroup = new ButtonGroup();
        this.minPanel = new JPanel();
        this.filterLabel = new JLabel();
        this.textFilter = new JTextField();
        this.showMoreToggleButton = new JToggleButton();
        this.nbLabel = new JLabel();
        this.criteriaPanel = new JPanel();
        this.eventsLabel = new JLabel();
        this.eventsComboBox = new JComboBox();
        this.entitiesLabel = new JLabel();
        this.entitiesComboBox = new JComboBox();
        this.foldersLabel = new JLabel();
        this.foldersComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.usedCheckBox = new JCheckBox();
        this.unusedCheckBox = new JCheckBox();
        this.foundCheckBox = new JCheckBox();
        this.unfoundCheckBox = new JCheckBox();
        this.monofilesCheckBox = new JCheckBox();
        this.asentityCheckBox = new JCheckBox();
        this.aspropertyCheckBox = new JCheckBox();
        this.multifilesCheckBox = new JCheckBox();
        this.localCheckBox = new JCheckBox();
        this.remoteCheckBox = new JCheckBox();
        this.sortPanel = new JPanel();
        this.sortLabel = new JLabel();
        this.titleRadioButton = new JRadioButton();
        this.filenameRadioButton = new JRadioButton();
        this.filepathRadioButton = new JRadioButton();
        this.frequencyRadioButton = new JRadioButton();
        Mnemonics.setLocalizedText((JLabel)this.filterLabel, (String)NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.filterLabel.text"));
        this.textFilter.setText(NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.textFilter.text"));
        this.showMoreToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/viewers/media/ShowMore.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.showMoreToggleButton, (String)NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.showMoreToggleButton.text"));
        this.showMoreToggleButton.setToolTipText(NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.showMoreToggleButton.toolTipText"));
        this.showMoreToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaFilterPanel.this.showMoreToggleButtonActionPerformed(evt);
            }
        });
        this.nbLabel.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.nbLabel, (String)NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.nbLabel.text"));
        this.nbLabel.setHorizontalTextPosition(4);
        GroupLayout minPanelLayout = new GroupLayout(this.minPanel);
        this.minPanel.setLayout(minPanelLayout);
        minPanelLayout.setHorizontalGroup(minPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(minPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.filterLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFilter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showMoreToggleButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nbLabel).addContainerGap()));
        minPanelLayout.setVerticalGroup(minPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(minPanelLayout.createSequentialGroup().addContainerGap().addGroup(minPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(minPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.filterLabel).addComponent(this.textFilter, -2, -1, -2).addComponent(this.nbLabel)).addComponent(this.showMoreToggleButton)).addContainerGap(-1, Short.MAX_VALUE)));
        Mnemonics.setLocalizedText((JLabel)this.eventsLabel, (String)NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.eventsLabel.text"));
        this.eventsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.eventsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaFilterPanel.this.eventsComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.entitiesLabel, (String)NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.entitiesLabel.text"));
        this.entitiesComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.entitiesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaFilterPanel.this.entitiesComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.foldersLabel, (String)NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.foldersLabel.text"));
        this.foldersComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.foldersComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaFilterPanel.this.foldersComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.jLabel1.text"));
        this.usedCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.usedCheckBox, (String)NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.usedCheckBox.text"));
        this.usedCheckBox.setToolTipText(NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.usedCheckBox.toolTipText"));
        this.usedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaFilterPanel.this.usedCheckBoxActionPerformed(evt);
            }
        });
        this.unusedCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.unusedCheckBox, (String)NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.unusedCheckBox.text"));
        this.unusedCheckBox.setToolTipText(NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.unusedCheckBox.toolTipText"));
        this.unusedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaFilterPanel.this.unusedCheckBoxActionPerformed(evt);
            }
        });
        this.foundCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.foundCheckBox, (String)NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.foundCheckBox.text"));
        this.foundCheckBox.setToolTipText(NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.foundCheckBox.toolTipText"));
        this.foundCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaFilterPanel.this.foundCheckBoxActionPerformed(evt);
            }
        });
        this.unfoundCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.unfoundCheckBox, (String)NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.unfoundCheckBox.text"));
        this.unfoundCheckBox.setToolTipText(NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.unfoundCheckBox.toolTipText"));
        this.unfoundCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaFilterPanel.this.unfoundCheckBoxActionPerformed(evt);
            }
        });
        this.monofilesCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.monofilesCheckBox, (String)NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.monofilesCheckBox.text"));
        this.monofilesCheckBox.setToolTipText(NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.monofilesCheckBox.toolTipText"));
        this.monofilesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaFilterPanel.this.monofilesCheckBoxActionPerformed(evt);
            }
        });
        this.asentityCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.asentityCheckBox, (String)NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.asentityCheckBox.text"));
        this.asentityCheckBox.setToolTipText(NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.asentityCheckBox.toolTipText"));
        this.asentityCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaFilterPanel.this.asentityCheckBoxActionPerformed(evt);
            }
        });
        this.aspropertyCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.aspropertyCheckBox, (String)NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.aspropertyCheckBox.text"));
        this.aspropertyCheckBox.setToolTipText(NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.aspropertyCheckBox.toolTipText"));
        this.aspropertyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaFilterPanel.this.aspropertyCheckBoxActionPerformed(evt);
            }
        });
        this.multifilesCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.multifilesCheckBox, (String)NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.multifilesCheckBox.text"));
        this.multifilesCheckBox.setToolTipText(NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.multifilesCheckBox.toolTipText"));
        this.multifilesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaFilterPanel.this.multifilesCheckBoxActionPerformed(evt);
            }
        });
        this.localCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.localCheckBox, (String)NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.localCheckBox.text"));
        this.localCheckBox.setToolTipText(NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.localCheckBox.toolTipText"));
        this.localCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaFilterPanel.this.localCheckBoxActionPerformed(evt);
            }
        });
        this.remoteCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.remoteCheckBox, (String)NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.remoteCheckBox.text"));
        this.remoteCheckBox.setToolTipText(NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.remoteCheckBox.toolTipText"));
        this.remoteCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaFilterPanel.this.remoteCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout criteriaPanelLayout = new GroupLayout(this.criteriaPanel);
        this.criteriaPanel.setLayout(criteriaPanelLayout);
        criteriaPanelLayout.setHorizontalGroup(criteriaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(criteriaPanelLayout.createSequentialGroup().addContainerGap().addGroup(criteriaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.eventsLabel).addComponent(this.foldersLabel).addComponent(this.jLabel1)).addGap(29, 29, 29).addGroup(criteriaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(criteriaPanelLayout.createSequentialGroup().addGroup(criteriaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.usedCheckBox).addComponent(this.unusedCheckBox)).addGap(18, 18, 18).addGroup(criteriaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.unfoundCheckBox).addComponent(this.foundCheckBox)).addGap(18, 18, 18).addGroup(criteriaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.localCheckBox).addComponent(this.remoteCheckBox)).addGap(18, 18, 18).addGroup(criteriaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.monofilesCheckBox).addComponent(this.multifilesCheckBox)).addGap(18, 18, 18).addGroup(criteriaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.aspropertyCheckBox).addComponent(this.asentityCheckBox)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(criteriaPanelLayout.createSequentialGroup().addComponent(this.eventsComboBox, 0, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.entitiesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.entitiesComboBox, 0, -1, Short.MAX_VALUE).addGap(6, 6, 6)).addGroup(criteriaPanelLayout.createSequentialGroup().addComponent(this.foldersComboBox, 0, -1, Short.MAX_VALUE).addContainerGap()))));
        criteriaPanelLayout.setVerticalGroup(criteriaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(criteriaPanelLayout.createSequentialGroup().addContainerGap().addGroup(criteriaPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.eventsComboBox, -2, -1, -2).addComponent(this.eventsLabel).addComponent(this.entitiesLabel).addComponent(this.entitiesComboBox, -2, -1, -2)).addGap(11, 11, 11).addGroup(criteriaPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.foldersLabel).addComponent(this.foldersComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(criteriaPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.usedCheckBox).addComponent(this.foundCheckBox).addComponent(this.jLabel1).addComponent(this.asentityCheckBox).addComponent(this.monofilesCheckBox).addComponent(this.localCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(criteriaPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.unusedCheckBox).addComponent(this.unfoundCheckBox).addComponent(this.aspropertyCheckBox).addComponent(this.multifilesCheckBox).addComponent(this.remoteCheckBox)).addContainerGap()));
        Mnemonics.setLocalizedText((JLabel)this.sortLabel, (String)NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.sortLabel.text"));
        this.sortButtonGroup.add(this.titleRadioButton);
        this.titleRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.titleRadioButton, (String)NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.titleRadioButton.text"));
        this.titleRadioButton.setToolTipText(NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.titleRadioButton.toolTipText"));
        this.titleRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaFilterPanel.this.titleRadioButtonActionPerformed(evt);
            }
        });
        this.sortButtonGroup.add(this.filenameRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.filenameRadioButton, (String)NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.filenameRadioButton.text"));
        this.filenameRadioButton.setToolTipText(NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.filenameRadioButton.toolTipText"));
        this.filenameRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaFilterPanel.this.filenameRadioButtonActionPerformed(evt);
            }
        });
        this.sortButtonGroup.add(this.filepathRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.filepathRadioButton, (String)NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.filepathRadioButton.text"));
        this.filepathRadioButton.setToolTipText(NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.filepathRadioButton.toolTipText"));
        this.filepathRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaFilterPanel.this.filepathRadioButtonActionPerformed(evt);
            }
        });
        this.sortButtonGroup.add(this.frequencyRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.frequencyRadioButton, (String)NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.frequencyRadioButton.text"));
        this.frequencyRadioButton.setToolTipText(NbBundle.getMessage(MediaFilterPanel.class, (String)"MediaFilterPanel.frequencyRadioButton.toolTipText"));
        this.frequencyRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaFilterPanel.this.frequencyRadioButtonActionPerformed(evt);
            }
        });
        GroupLayout sortPanelLayout = new GroupLayout(this.sortPanel);
        this.sortPanel.setLayout(sortPanelLayout);
        sortPanelLayout.setHorizontalGroup(sortPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sortPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(sortPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sortLabel).addComponent(this.titleRadioButton).addComponent(this.filenameRadioButton).addComponent(this.filepathRadioButton).addComponent(this.frequencyRadioButton)).addContainerGap()));
        sortPanelLayout.setVerticalGroup(sortPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sortPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.sortLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.titleRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filenameRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filepathRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.frequencyRadioButton).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.criteriaPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sortPanel, -2, -1, -2)).addComponent(this.minPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.minPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.criteriaPanel, -2, -1, -2).addComponent(this.sortPanel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void showMoreToggleButtonActionPerformed(ActionEvent evt) {
        this.updatePanels(this.showMoreToggleButton.isSelected());
        this.saveSettings();
    }

    private void titleRadioButtonActionPerformed(ActionEvent evt) {
        this.updateList();
    }

    private void filenameRadioButtonActionPerformed(ActionEvent evt) {
        this.updateList();
    }

    private void filepathRadioButtonActionPerformed(ActionEvent evt) {
        this.updateList();
    }

    private void frequencyRadioButtonActionPerformed(ActionEvent evt) {
        this.updateList();
    }

    private void usedCheckBoxActionPerformed(ActionEvent evt) {
        this.updateList();
    }

    private void unusedCheckBoxActionPerformed(ActionEvent evt) {
        this.updateList();
    }

    private void foundCheckBoxActionPerformed(ActionEvent evt) {
        this.updateList();
    }

    private void unfoundCheckBoxActionPerformed(ActionEvent evt) {
        this.updateList();
    }

    private void multifilesCheckBoxActionPerformed(ActionEvent evt) {
        this.updateList();
    }

    private void monofilesCheckBoxActionPerformed(ActionEvent evt) {
        this.updateList();
    }

    private void asentityCheckBoxActionPerformed(ActionEvent evt) {
        this.updateList();
    }

    private void aspropertyCheckBoxActionPerformed(ActionEvent evt) {
        this.updateList();
    }

    private void eventsComboBoxActionPerformed(ActionEvent evt) {
        this.updateList();
    }

    private void entitiesComboBoxActionPerformed(ActionEvent evt) {
        this.updateList();
    }

    private void foldersComboBoxActionPerformed(ActionEvent evt) {
        this.updateList();
    }

    private void localCheckBoxActionPerformed(ActionEvent evt) {
        this.updateList();
    }

    private void remoteCheckBoxActionPerformed(ActionEvent evt) {
        this.updateList();
    }

    private void updateList() {
        if (this.isReady) {
            this.parent.filterModel();
            this.saveSettings();
        }
    }

    public void update(int size) {
        this.nbLabel.setText(this.getLabel(size));
    }

    public int getSortOrder() {
        for (int i = 0; i < 4; ++i) {
            if (!this.sortButtons[i].isSelected()) continue;
            return i;
        }
        return 0;
    }

    private void updatePanels(boolean isVisible) {
        this.criteriaPanel.setVisible(isVisible);
        this.sortPanel.setVisible(isVisible);
        this.showMoreToggleButton.setIcon(new ImageIcon(this.getClass().getResource(isVisible ? "/ancestris/modules/viewers/media/ShowLess.png" : "/ancestris/modules/viewers/media/ShowMore.png")));
        this.showMoreToggleButton.setToolTipText(NbBundle.getMessage(MediaFilterPanel.class, (String)(isVisible ? "MediaFilterPanel.showMoreToggleButton.toolTipTextLess" : "MediaFilterPanel.showMoreToggleButton.toolTipText")));
    }

    private String getLabel(int size) {
        return NbBundle.getMessage(MediaChooser.class, (String)"MediaFilterPanel.nbLabel.text", (Object)size);
    }

    public String getText() {
        return this.textFilter.getText();
    }

    public boolean getUsed() {
        return this.usedCheckBox.isSelected();
    }

    private void resetCombosValues() {
        this.resetCombosValues(null);
    }

    public void resetCombosValues(TreeSet<MediaChooser.MediaThumb> allMedia) {
        TreeSet<String> eventsOfMedia = new TreeSet<String>();
        TreeSet<String> entitiesOfMedia = new TreeSet<String>();
        TreeSet<String> foldersOfMedia = new TreeSet<String>();
        eventsOfMedia.add(this.default_selection);
        entitiesOfMedia.add(this.default_selection);
        foldersOfMedia.add(this.default_selection);
        if (allMedia != null) {
            for (MediaChooser.MediaThumb media : allMedia) {
                eventsOfMedia.addAll(media.tagEvents);
                for (Entity ent : media.entities) {
                    entitiesOfMedia.add(Gedcom.getName((String)ent.getTag()));
                }
                foldersOfMedia.add(this.getMediaFolder(media));
            }
        }
        this.eventsComboBox.setModel(new DefaultComboBoxModel<String>((String[])eventsOfMedia.toArray(String[]::new)));
        this.entitiesComboBox.setModel(new DefaultComboBoxModel<String>((String[])entitiesOfMedia.toArray(String[]::new)));
        this.foldersComboBox.setModel(new DefaultComboBoxModel<String>((String[])foldersOfMedia.toArray(String[]::new)));
        if (allMedia != null) {
            this.loadSettings();
            this.isReady = true;
        }
    }

    private String getMediaFolder(MediaChooser.MediaThumb media) {
        String location = media.inputSource != null ? media.inputSource.getLocation() : media.fileLocation;
        int index = location.lastIndexOf(File.separator);
        String folder = location;
        if (index != -1) {
            folder = location.substring(0, index);
        }
        return folder;
    }

    protected boolean matches(MediaChooser.MediaThumb media) {
        return this.matchesText(media) && this.matchesFlagsUsed(media) && this.matchesFlagsFound(media) && this.matchesFlagsLocal(media) && this.matchesFlagsMulti(media) && this.matchesFlagsEntity(media) && this.matchesEvent(media) && this.matchesEntity(media) && this.matchesFolder(media);
    }

    private boolean matchesText(MediaChooser.MediaThumb media) {
        Entity[] ents;
        String text = this.getText();
        if (media.title.toLowerCase().contains(text.toLowerCase())) {
            return true;
        }
        if (media.inputSource != null && media.inputSource.getLocation().toLowerCase().contains(text.toLowerCase())) {
            return true;
        }
        for (Entity ent : ents = PropertyXRef.getReferences((Entity)media.entity)) {
            Entity[] ent2s;
            for (Entity ent2 : ent2s = PropertyXRef.getReferences((Entity)ent)) {
                if (!ent2.getDisplayTitle().toLowerCase().contains(text.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesFlagsUsed(MediaChooser.MediaThumb media) {
        return !media.isUnused && this.usedCheckBox.isSelected() || media.isUnused && this.unusedCheckBox.isSelected();
    }

    private boolean matchesFlagsFound(MediaChooser.MediaThumb media) {
        return media.isFound() && this.foundCheckBox.isSelected() || !media.isFound() && this.unfoundCheckBox.isSelected();
    }

    private boolean matchesFlagsLocal(MediaChooser.MediaThumb media) {
        return media.isFileLocal && this.localCheckBox.isSelected() || media.isFileRemote && this.remoteCheckBox.isSelected();
    }

    private boolean matchesFlagsMulti(MediaChooser.MediaThumb media) {
        return media.nbFileUsed > 1 && this.multifilesCheckBox.isSelected() || media.nbFileUsed == 1 && this.monofilesCheckBox.isSelected();
    }

    private boolean matchesFlagsEntity(MediaChooser.MediaThumb media) {
        return media.isMedia && this.asentityCheckBox.isSelected() || !media.isMedia && this.aspropertyCheckBox.isSelected();
    }

    private boolean matchesFolder(MediaChooser.MediaThumb media) {
        String folder1 = this.foldersComboBox.getSelectedItem().toString();
        String folder2 = this.getMediaFolder(media);
        return this.default_selection.equals(folder1) || folder2.equals(folder1);
    }

    private boolean matchesEvent(MediaChooser.MediaThumb media) {
        String event = this.eventsComboBox.getSelectedItem().toString();
        return this.default_selection.equals(event) || media.tagEvents.contains(event);
    }

    private boolean matchesEntity(MediaChooser.MediaThumb media) {
        String entityTag = this.entitiesComboBox.getSelectedItem().toString();
        for (Entity ent : media.entities) {
            if (!Gedcom.getName((String)ent.getTag()).equals(entityTag)) continue;
            return true;
        }
        return this.default_selection.equals(entityTag);
    }
}

