/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.circdesc;

import ancestris.reports.FormatPlaceOptions;
import ancestris.reports.ScopeIndiMiniOptions;
import ancestris.reports.circdesc.Cellule;
import ancestris.reports.utils.ColorUtils;
import ancestris.reports.utils.SvgUtils;
import ancestris.util.Utilities;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReportCircDesc
extends Report {
    public FormatOptions formattingOptions = new FormatOptions();
    public ScopeIndiMiniOptions scope = new ScopeIndiMiniOptions();
    public FormatContent content = new FormatContent();
    public FormatPlaceOptions dataFormatOptions = new FormatPlaceOptions();
    public MyColorOptions colorOptions = new MyColorOptions();
    private Document document;
    private final List<Element> texts = new ArrayList<Element>();
    private SVGGraphics2D svgGenerator;
    private final Set<Cellule> cellules = new HashSet<Cellule>();
    private final Map<Integer, List<Cellule>> generations = new HashMap<Integer, List<Cellule>>();
    private final Map<String, Color> nameColor = new HashMap<String, Color>();
    private final Set<Color> colorUsed = new HashSet<Color>();
    private int nbChildMax;
    private int currentMaxLevel;

    public File start(Gedcom gedcom) {
        Indi indi = this.scope.getScope(gedcom, this);
        return indi != null ? this.start(indi) : null;
    }

    public File start(Indi indi) {
        File file;
        this.init();
        try {
            file = File.createTempFile("ancestris_svg", ".svg");
            file.deleteOnExit();
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, this.translate("output.error"), ex);
            return null;
        }
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        this.document = domImpl.createDocument("http://www.w3.org/2000/svg", "svg", null);
        this.svgGenerator = new SVGGraphics2D(this.document);
        this.svgGenerator.getGeneratorContext().setComment("Generated by Ancestris with Batik SVG Generator");
        Font myFont = new Font(this.formattingOptions.fontNames[this.formattingOptions.fontName], 0, 12);
        this.svgGenerator.setFont(myFont);
        this.mainSvg(indi);
        try {
            PrintWriter writer = SvgUtils.getWriter(new FileOutputStream(file));
            this.svgGenerator.stream((Writer)writer);
            writer.flush();
            writer.close();
        }
        catch (FileNotFoundException | SVGGraphics2DIOException ex) {
            LOG.log(Level.INFO, this.translate("output.error"), ex);
            return null;
        }
        try {
            SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());
            Document doc = factory.createDocument(file.getAbsolutePath(), (InputStream)new FileInputStream(file));
            doc.getDocumentElement().normalize();
            doc.getDocumentElement().setAttribute("font-family", this.formattingOptions.fontNames[this.formattingOptions.fontName]);
            for (Element ele : this.texts) {
                Node node = doc.importNode(ele, true);
                doc.getDocumentElement().appendChild(node);
            }
            PrintWriter writer = SvgUtils.getWriter(new FileOutputStream(file));
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
            writer.flush();
            writer.close();
        }
        catch (IOException | TransformerException ex) {
            LOG.log(Level.INFO, this.translate("output.error"), ex);
        }
        return file;
    }

    private void init() {
        this.texts.clear();
        this.cellules.clear();
        this.generations.clear();
        this.nameColor.clear();
        this.colorUsed.clear();
    }

    private void mainSvg(Indi indi) {
        this.constructTree(indi);
        this.draw();
    }

    private void constructTree(Indi indi) {
        int i;
        this.cellules.clear();
        this.generations.clear();
        for (int i2 = 0; i2 < this.content.umaxlevel + 4; ++i2) {
            ArrayList gen = new ArrayList();
            this.generations.put(i2, gen);
        }
        Cellule souche = new Cellule(indi);
        souche.setIndiName(this.getName(indi));
        FontMetrics metrics = this.svgGenerator.getFontMetrics();
        souche.setMaxBounds(metrics.getStringBounds(souche.getIndiName(), (Graphics)this.svgGenerator));
        souche.setGeneration(0);
        this.generations.get(0).add(souche);
        this.cellules.add(souche);
        for (i = 0; i < this.content.umaxlevel + 4; ++i) {
            for (Cellule cell : this.generations.get(i)) {
                this.setColor(cell, i);
                cell.setMaxBounds(metrics.getStringBounds(cell.getIndiName(), (Graphics)this.svgGenerator));
                cell.setMaxText(cell.getIndiName());
                for (Fam fam : cell.getIndi().getFamiliesWhereSpouse(true)) {
                    Indi spouse = fam.getOtherSpouse(cell.getIndi());
                    if (spouse != null) {
                        Object spouseName = this.getName(spouse);
                        if (this.content.printWeddingYear && fam.getMarriageDate() != null) {
                            spouseName = "x" + this.getYear(fam.getMarriageDate()) + " " + (String)spouseName;
                        }
                        cell.getSpouse().add((String)spouseName);
                        Rectangle2D spouseBounds = metrics.getStringBounds((String)spouseName, (Graphics)this.svgGenerator);
                        if (cell.getMaxBounds().getWidth() < spouseBounds.getWidth()) {
                            cell.setMaxBounds(spouseBounds);
                            cell.setMaxText((String)spouseName);
                        }
                    } else {
                        cell.getSpouse().add(" - -");
                    }
                    if (i >= this.content.umaxlevel + 3 || cell.isDuplicate()) continue;
                    for (Indi child : fam.getChildren(true)) {
                        Cellule cellChild = new Cellule(child);
                        cellChild.setIndiName(this.getName(child));
                        cellChild.setGeneration(i + 1);
                        cellChild.setParent(cell);
                        cellChild.setParentWedding(cell.getSpouse().size());
                        if (this.cellules.contains(cellChild)) {
                            cellChild.setDuplicate(true);
                        } else {
                            this.cellules.add(cellChild);
                        }
                        this.generations.get(cellChild.getGeneration()).add(cellChild);
                    }
                }
            }
        }
        this.nbChildMax = 0;
        this.currentMaxLevel = this.content.umaxlevel + 4;
        for (i = this.content.umaxlevel + 3; i > 0; --i) {
            if (this.generations.get(i).isEmpty()) {
                this.currentMaxLevel = i;
            }
            for (Cellule cell : this.generations.get(i)) {
                int nbChild = (cell.getNbChild() == 0 ? 1 : cell.getNbChild()) + cell.getParent().getNbChild();
                cell.getParent().setNbChild(nbChild);
                if (nbChild <= this.nbChildMax) continue;
                this.nbChildMax = nbChild;
            }
        }
    }

    private String getName(Indi indi) {
        StringBuilder retour = new StringBuilder();
        retour.append(indi.getReportName());
        if (this.content.printYears) {
            int birth = this.getYear(indi.getBirthDateOption());
            int death = this.getYear(indi.getDeathDateOption());
            if (birth == -1) {
                retour.append(" (-");
            } else {
                retour.append(" (").append(birth).append("-");
            }
            if (death == -1) {
                retour.append(")");
            } else {
                retour.append(death).append(")");
            }
        }
        return retour.toString();
    }

    private void setColor(Cellule cell, int i) {
        block0 : switch (this.colorOptions.colorScheme) {
            case 0: {
                cell.setBgColor(Color.WHITE);
                cell.setFgColor(Color.BLACK);
                break;
            }
            case 1: {
                switch (cell.getIndi().getSex()) {
                    case 1: {
                        cell.setBgColor(this.colorOptions.sexMColor);
                        cell.setFgColor(this.colorOptions.sexMText);
                        break block0;
                    }
                    case 2: {
                        cell.setBgColor(this.colorOptions.sexFColor);
                        cell.setFgColor(this.colorOptions.sexFText);
                        break block0;
                    }
                }
                cell.setBgColor(Color.WHITE);
                cell.setFgColor(Color.BLACK);
                break;
            }
            case 2: {
                cell.setFgColor(this.colorOptions.gradientText);
                int red = this.colorOptions.gradientColor.getRed();
                int green = this.colorOptions.gradientColor.getGreen();
                int blue = this.colorOptions.gradientColor.getBlue();
                if (i == 0) {
                    cell.setBgColor(this.colorOptions.gradientColor);
                    break;
                }
                double percent = (double)i / ((double)this.content.umaxlevel + 4.0);
                red = (int)((double)red * (1.0 - percent));
                green = (int)((double)green * (1.0 - percent));
                blue = (int)((double)blue * (1.0 - percent));
                cell.setBgColor(new Color(red, green, blue));
                break;
            }
            case 3: {
                cell.setFgColor(Color.BLACK);
                cell.setBgColor(this.getRandomColor(cell.getIndi().getLastName()));
                break;
            }
            case 4: {
                cell.setFgColor(Color.BLACK);
                cell.setBgColor(this.getGeoColor(cell.getIndi()));
                break;
            }
            case 5: {
                cell.setFgColor(Color.BLACK);
                cell.setBgColor(this.getLifeSpanColor(cell.getIndi()));
                break;
            }
            default: {
                cell.setBgColor(Color.WHITE);
                cell.setFgColor(Color.BLACK);
            }
        }
    }

    private Color getGeoColor(Indi indi) {
        Fam[] families;
        PropertyPlace place = indi.getBirthPlaceOption();
        if (place == null) {
            place = indi.getDeathPlaceOption();
        }
        if (place == null && (families = indi.getFamiliesWhereSpouse()) != null && families.length > 0 && families[0] != null) {
            place = indi.getFamiliesWhereSpouse()[0].getMarriagePlace();
        }
        if (place != null) {
            String value = this.dataFormatOptions.getPlace((Property)place);
            return this.getRandomColor(value);
        }
        return Color.WHITE;
    }

    private Color getLifeSpanColor(Indi indi) {
        int lifeSpan = this.lifeSpan(indi);
        if (lifeSpan == -100) {
            this.nameColor.put(this.translate("undecidable"), Color.LIGHT_GRAY);
            return Color.LIGHT_GRAY;
        }
        if (lifeSpan < 5) {
            return this.getRandomColor("0 - 5");
        }
        if (lifeSpan < 10) {
            return this.getRandomColor("5 - 10");
        }
        if (lifeSpan < 10) {
            return this.getRandomColor("10 - 20");
        }
        if (lifeSpan < 30) {
            return this.getRandomColor("20 - 30");
        }
        if (lifeSpan < 40) {
            return this.getRandomColor("30 - 40");
        }
        if (lifeSpan < 50) {
            return this.getRandomColor("40 - 50");
        }
        if (lifeSpan < 60) {
            return this.getRandomColor("50 - 60");
        }
        if (lifeSpan < 70) {
            return this.getRandomColor("60 - 70");
        }
        if (lifeSpan < 80) {
            return this.getRandomColor("70 - 80");
        }
        if (lifeSpan < 90) {
            return this.getRandomColor("80 - 90");
        }
        return this.getRandomColor("90+");
    }

    private int lifeSpan(Indi indi) {
        PropertyDate birth = indi.getBirthDateOption();
        PropertyDate death = indi.getDeathDateOption();
        if (birth == null && death == null) {
            return -100;
        }
        if (birth == null || !birth.isValid() || birth.getAnniversary() == null) {
            return -100;
        }
        if (death == null || !death.isValid()) {
            if (((Indi)birth.getEntity()).isDeceased()) {
                return -100;
            }
            return birth.getAnniversary().getYears();
        }
        return Delta.get((PointInTime)birth.getStart(), (PointInTime)death.getStart()).getYears();
    }

    private Color getRandomColor(String value) {
        if ("".equals(value)) {
            return Color.WHITE;
        }
        Color color = this.nameColor.get(value);
        if (color != null) {
            return color;
        }
        color = ColorUtils.getRandomColor();
        while (this.colorUsed.contains(color)) {
            color = ColorUtils.getRandomColor();
        }
        this.nameColor.put(value, color);
        this.colorUsed.add(color);
        return color;
    }

    private void draw() {
        int r = 300 + 15 * (this.nbChildMax > 40 ? 40 : this.nbChildMax) / 10;
        int width = r * this.currentMaxLevel;
        int height = r * this.currentMaxLevel;
        this.svgGenerator.setSVGCanvasSize(new Dimension(width, height));
        BasicStroke ligne = new BasicStroke(1.0f);
        this.svgGenerator.setColor(Color.BLACK);
        this.svgGenerator.setStroke((Stroke)ligne);
        FontMetrics metrics = this.svgGenerator.getFontMetrics();
        this.svgGenerator.drawRect(10, 10, width - 20, height - 20);
        double centerY = height / 2;
        double centerX = width / 2;
        double currentR = 200.0;
        double currentAng = 360.0;
        double rOuterMax = currentR;
        for (int i = 0; i < this.currentMaxLevel; ++i) {
            Cellule cellParent = null;
            for (Cellule cell : this.generations.get(i)) {
                boolean parentsseveralWedding;
                if (!(cellParent != null && cellParent.equals(cell.getParent()) || (cellParent = cell.getParent()) == null)) {
                    currentR = cellParent.getrOuter();
                    currentAng = cellParent.getStartAng();
                }
                int nbChild = cell.getNbChild() == 0 ? 1 : cell.getNbChild();
                double pourcent = (double)nbChild / (double)this.nbChildMax;
                if (i == 0) {
                    Object content = cell.getMaxText();
                    Rectangle2D boundary = metrics.getStringBounds((String)content, (Graphics)this.svgGenerator);
                    if (boundary.getWidth() > 2.0 * currentR) {
                        currentR = boundary.getWidth() + 10.0;
                    }
                    boundary = metrics.getStringBounds(cell.getIndiName(), (Graphics)this.svgGenerator);
                    this.svgGenerator.setColor(cell.getBgColor());
                    this.svgGenerator.fill((Shape)new Ellipse2D.Double(centerX - currentR / 2.0, centerY - currentR / 2.0, currentR, currentR));
                    this.svgGenerator.setColor(Color.BLACK);
                    this.svgGenerator.draw((Shape)new Ellipse2D.Double(centerX - currentR / 2.0, centerY - currentR / 2.0, currentR, currentR));
                    this.svgGenerator.setColor(cell.getFgColor());
                    this.svgGenerator.drawString(cell.getIndiName(), (int)(centerX - boundary.getWidth() / 2.0), (int)(centerY - boundary.getHeight()));
                    int j = 1;
                    double heightSpouse = centerY;
                    boolean drawJ = cell.getSpouse().size() > 1;
                    for (String spouse : cell.getSpouse()) {
                        content = drawJ ? j + ". " + spouse : spouse;
                        Rectangle2D bound = metrics.getStringBounds((String)content, (Graphics)this.svgGenerator);
                        this.svgGenerator.setColor(cell.getFgColor());
                        this.svgGenerator.drawString((String)content, (int)(centerX - bound.getWidth() / 2.0), (int)(heightSpouse += bound.getHeight()));
                        ++j;
                    }
                    cell.setStartAng(360.0);
                    cell.setrOuter(currentR);
                    continue;
                }
                double rInner = currentR + (double)metrics.getHeight() + 15.0;
                double rAdd = 200.0;
                if (this.nbChildMax > 10) {
                    rAdd += 50.0;
                }
                if (this.nbChildMax > 20 && i > 3) {
                    rAdd += 50.0;
                }
                if (this.nbChildMax > 30 && i > 6) {
                    rAdd += 50.0;
                }
                if (this.nbChildMax > 40 && i > 9) {
                    rAdd += 50.0;
                }
                double rOuter = rInner + rAdd;
                double ang1 = currentAng;
                double ang2 = currentAng - 360.0 * pourcent;
                double angularStep = ang2 - ang1;
                boolean inverted = (ang1 + ang2) / 2.0 <= 180.0;
                GeneralPath path = new GeneralPath();
                if (cell.isDuplicate()) {
                    pourcent = (double)cell.getParent().getNbChild() / (double)this.nbChildMax;
                    ang2 = currentAng - 360.0 * pourcent;
                    angularStep = ang2 - ang1;
                    double rText = currentR + (double)(metrics.getHeight() / 2) + 10.0;
                    Arc2D.Double dup = new Arc2D.Double(centerX - rText / 2.0, centerY - rText / 2.0, rText, rText, ang2, -angularStep, 0);
                    Element pathElement = this.svgGenerator.getShapeConverter().toSVG((Shape)dup);
                    this.addText(pathElement, this.calculateOffsetCircle(0.495, rText, angularStep, "+ + +"), cell.getIndi().getId(), "+ + +", -1, Color.BLACK);
                    continue;
                }
                boolean bl = parentsseveralWedding = cell.getParent().getSpouse().size() > 1;
                if (parentsseveralWedding) {
                    double rText = inverted ? currentR + (double)(metrics.getHeight() / 2) + 5.0 : currentR + (double)(metrics.getHeight() / 2) + 10.0;
                    Arc2D.Double fam = inverted ? new Arc2D.Double(centerX - rText / 2.0, centerY - rText / 2.0, rText, rText, ang1, angularStep, 0) : new Arc2D.Double(centerX - rText / 2.0, centerY - rText / 2.0, rText, rText, ang2, -angularStep, 0);
                    Element pathElement = this.svgGenerator.getShapeConverter().toSVG((Shape)fam);
                    this.addText(pathElement, this.calculateOffsetCircle(0.5, rText, angularStep, String.valueOf(cell.getParentWedding())), cell.getIndi().getId(), String.valueOf(cell.getParentWedding()), -1, Color.BLACK);
                }
                Arc2D.Double inner = new Arc2D.Double(centerX - rInner / 2.0, centerY - rInner / 2.0, rInner, rInner, ang2, -angularStep, 0);
                Arc2D.Double outer = new Arc2D.Double(centerX - rOuter / 2.0, centerY - rOuter / 2.0, rOuter, rOuter, ang1, angularStep, 0);
                path.append(inner, false);
                Point2D point = outer.getStartPoint();
                path.lineTo(point.getX(), point.getY());
                path.append(outer, true);
                path.closePath();
                this.svgGenerator.setColor(cell.getBgColor());
                this.svgGenerator.fill((Shape)path);
                this.svgGenerator.setColor(Color.BLACK);
                this.svgGenerator.draw((Shape)path);
                cell.setrOuter(rOuter);
                cell.setStartAng(currentAng);
                currentAng = ang2;
                this.fillText(inverted, rOuter, rAdd, cell, rInner, centerX, centerY, ang1, angularStep, ang2);
                rOuterMax = rOuter;
            }
        }
        if (this.formattingOptions.printDate) {
            this.svgGenerator.setColor(Color.BLACK);
            this.svgGenerator.setFont(new Font(this.formattingOptions.fontNames[this.formattingOptions.fontName], 0, 8));
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("uuuu/MM/dd HH:mm:ss");
            LocalDateTime now = LocalDateTime.now();
            String date = dtf.format(now);
            this.svgGenerator.drawString(date, width - 120, height - 20);
        }
        if (this.formattingOptions.drawLegend) {
            Ellipse2D.Double cercle = new Ellipse2D.Double(centerX - rOuterMax / 2.0, centerY - rOuterMax / 2.0, rOuterMax, rOuterMax);
            this.drawLegend(cercle, height);
        }
    }

    private void fillText(boolean inverted, double rOuter, double rAdd, Cellule cell, double rInner, double centerX, double centerY, double ang1, double angularStep, double ang2) {
        float fontSize;
        boolean isChangeOrientation;
        double rMin = rInner + rAdd / (double)(2 + cell.getSpouse().size());
        double rName = inverted ? rOuter - rAdd / (double)(2 + cell.getSpouse().size()) : rMin;
        Arc2D.Double aName = inverted ? new Arc2D.Double(centerX - rName / 2.0, centerY - rName / 2.0, rName, rName, ang1, angularStep, 0) : new Arc2D.Double(centerX - rName / 2.0, centerY - rName / 2.0, rName, rName, ang2, -angularStep, 0);
        GeneralPath rPath = new GeneralPath();
        rPath.append(aName, false);
        Element pathElement = this.svgGenerator.getShapeConverter().toSVG((Shape)rPath);
        double arcLName = rMin * Math.toRadians(Math.abs(angularStep)) / 2.0;
        double offset = cell.getMaxBounds().getWidth() / arcLName;
        boolean bl = isChangeOrientation = offset > 0.9 && arcLName < rAdd / 2.0;
        if (isChangeOrientation) {
            double arcLMilieu = (rInner + rAdd / 2.0) * Math.toRadians(Math.abs(angularStep)) / 2.0;
            fontSize = this.adjustFontSize(cell, arcLMilieu, rAdd / 2.0, isChangeOrientation);
            pathElement = this.addLine(ang1, ang2, centerX, rInner, centerY, angularStep, cell, rOuter, 1);
        } else {
            fontSize = this.adjustFontSize(cell, rAdd / 2.0, arcLName, isChangeOrientation);
            arcLName = rName * Math.toRadians(Math.abs(angularStep)) / 2.0;
        }
        FontMetrics metrics = this.svgGenerator.getFontMetrics();
        String value = cell.getIndiName();
        Rectangle2D bounds = metrics.getStringBounds(value, (Graphics)this.svgGenerator);
        offset = (isChangeOrientation ? rAdd / 4.0 : arcLName / 2.0) - bounds.getWidth() / 2.0;
        this.addText(pathElement, offset, cell.getIndi().getId(), value, 0, cell.getFgColor(), fontSize);
        boolean hasSpouses = cell.getSpouse().size() > 1;
        double spouseStep = inverted ? rOuter - rName : rName - rInner;
        int j = 1;
        for (String spouse : cell.getSpouse()) {
            rName = inverted ? rName - spouseStep : rName + spouseStep;
            Object sName = hasSpouses ? j + ". " + spouse : spouse;
            Arc2D.Double aSName = inverted ? new Arc2D.Double(centerX - rName / 2.0, centerY - rName / 2.0, rName, rName, ang1, angularStep, 0) : new Arc2D.Double(centerX - rName / 2.0, centerY - rName / 2.0, rName, rName, ang2, -angularStep, 0);
            GeneralPath inPath = new GeneralPath();
            inPath.append(aSName, false);
            Element sPathElement = this.svgGenerator.getShapeConverter().toSVG((Shape)inPath);
            double arcLSName = rName * Math.toRadians(Math.abs(angularStep)) / 2.0;
            Rectangle2D sBounds = metrics.getStringBounds((String)sName, (Graphics)this.svgGenerator);
            double sOffset = arcLSName / 2.0 - sBounds.getWidth() / 2.0;
            if (isChangeOrientation) {
                sPathElement = this.addLine(ang1, ang2, centerX, rInner, centerY, angularStep, cell, rOuter, 1 + j);
                sOffset = rAdd / 4.0 - sBounds.getWidth() / 2.0;
            }
            this.addText(sPathElement, sOffset, cell.getIndi().getId(), (String)sName, j, cell.getFgColor(), fontSize);
            ++j;
        }
        Font currentFont = this.svgGenerator.getFont();
        this.svgGenerator.setFont(currentFont.deriveFont(12.0f));
    }

    private float adjustFontSize(Cellule cell, double arcLength, double lineLength, boolean isChangeOrientation) {
        int nbLine = cell.getSpouse().size() + 1;
        float currentSize = 12.0f;
        Font currentFont = this.svgGenerator.getFont();
        FontMetrics currentMetrics = this.svgGenerator.getFontMetrics(currentFont);
        Rectangle2D bound = currentMetrics.getStringBounds(cell.getMaxText(), (Graphics)this.svgGenerator);
        while (currentSize > 6.0f && (bound.getHeight() + 1.0) * (double)nbLine > arcLength) {
            currentFont = currentFont.deriveFont(currentSize -= 2.0f);
            this.svgGenerator.setFont(currentFont);
            currentMetrics = this.svgGenerator.getFontMetrics();
            bound = currentMetrics.getStringBounds(cell.getMaxText(), (Graphics)this.svgGenerator);
        }
        while ((isChangeOrientation ? currentSize > 6.0f : currentSize > 8.0f) && bound.getWidth() > lineLength) {
            currentFont = currentFont.deriveFont(currentSize -= 1.0f);
            this.svgGenerator.setFont(currentFont);
            currentMetrics = this.svgGenerator.getFontMetrics();
            bound = currentMetrics.getStringBounds(cell.getMaxText(), (Graphics)this.svgGenerator);
        }
        return currentSize;
    }

    private Element addLine(double ang1, double ang2, double centerX, double rInner, double centerY, double angularStep, Cellule cell, double rOuter, int nLine) {
        boolean textUp = (ang1 + ang2) / 2.0 < 90.0 || (ang1 + ang2) / 2.0 > 270.0;
        Arc2D.Double aInner = textUp ? new Arc2D.Double(centerX - rInner / 2.0, centerY - rInner / 2.0, rInner, rInner, ang1 + (double)nLine * angularStep / (double)(2 + cell.getSpouse().size()), angularStep, 0) : new Arc2D.Double(centerX - rOuter / 2.0, centerY - rOuter / 2.0, rOuter, rOuter, ang2 - (double)nLine * angularStep / (double)(2 + cell.getSpouse().size()), -angularStep, 0);
        Arc2D.Double aOuter = textUp ? new Arc2D.Double(centerX - rOuter / 2.0, centerY - rOuter / 2.0, rOuter, rOuter, ang1 + (double)nLine * angularStep / (double)(2 + cell.getSpouse().size()), angularStep, 0) : new Arc2D.Double(centerX - rInner / 2.0, centerY - rInner / 2.0, rInner, rInner, ang2 - (double)nLine * angularStep / (double)(2 + cell.getSpouse().size()), -angularStep, 0);
        Line2D.Double lName = new Line2D.Double(aInner.getStartPoint(), aOuter.getStartPoint());
        GeneralPath inPath = new GeneralPath();
        inPath.append(lName, false);
        Element pathElement = this.svgGenerator.getShapeConverter().toSVG((Shape)inPath);
        return pathElement;
    }

    private void addText(Element pathElement, double offset, String id, String value, int line, Color fontColor, float fontSize) {
        String ref = String.valueOf(line) + "indi" + id;
        pathElement.setAttribute("visibility", "hidden");
        pathElement.setAttribute("style", "display:none");
        this.texts.add(SvgUtils.drawTextOnPath(this.document, pathElement, offset, false, ref, value, fontColor, (int)fontSize));
    }

    private void addText(Element pathElement, double offset, String id, String value, int line, Color fontColor) {
        String ref = String.valueOf(line) + "indi" + id;
        pathElement.setAttribute("visibility", "hidden");
        pathElement.setAttribute("style", "display:none");
        this.texts.add(SvgUtils.drawTextOnPath(this.document, pathElement, offset, false, ref, value, fontColor, 0));
    }

    public int getYear(PropertyDate someDate) {
        if (someDate == null || !someDate.isValid() || someDate.isRange()) {
            return -1;
        }
        int year = -1;
        try {
            year = someDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
        }
        catch (GedcomException ex) {
            LOG.log(Level.INFO, "", ex);
        }
        return year;
    }

    private void drawLegend(Ellipse2D cercle, int totalHeight) {
        this.svgGenerator.setFont(new Font(this.formattingOptions.fontNames[this.formattingOptions.fontName], 0, 9));
        FontMetrics metrics = this.svgGenerator.getFontMetrics();
        double maxWidth = 0.0;
        int debutX = 15;
        int debutY = totalHeight - 25;
        Area areaCercle = new Area(cercle);
        ArrayList<String> values = new ArrayList<String>(this.nameColor.keySet());
        Collections.sort(values, (o1, o2) -> Utilities.removeDiacritics((String)o1).compareTo(Utilities.removeDiacritics((String)o2)));
        Collections.reverse(values);
        for (String value : values) {
            Rectangle2D boundary = metrics.getStringBounds(value, (Graphics)this.svgGenerator);
            Rectangle2D.Double texteRect = new Rectangle2D.Double(debutX, debutY, 12.0 + boundary.getWidth(), 10.0);
            while (areaCercle.intersects(texteRect)) {
                debutY = totalHeight - 25;
                maxWidth = 0.0;
                texteRect = new Rectangle2D.Double(debutX += (int)maxWidth + 20, debutY, 12.0 + boundary.getWidth(), 10.0);
            }
            maxWidth = Math.max(maxWidth, boundary.getWidth());
            this.svgGenerator.setColor(this.nameColor.get(value));
            this.svgGenerator.fillRect(debutX, debutY, 10, 10);
            this.svgGenerator.setColor(Color.BLACK);
            this.svgGenerator.drawString(value, debutX + 12, debutY + 8);
            debutY -= 12;
        }
    }

    private double calculateOffsetCircle(double percent, double rayon, double angulardegre, String text) {
        FontMetrics metrics = this.svgGenerator.getFontMetrics();
        Rectangle2D bounds = metrics.getStringBounds(text, (Graphics)this.svgGenerator);
        return percent * rayon * Math.toRadians(Math.abs(angulardegre)) / 2.0 - bounds.getWidth() / 2.0;
    }

    public class FormatOptions {
        public int fontName = 0;
        public String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        public boolean printDate;
        public boolean drawLegend;
    }

    public class FormatContent {
        public int umaxlevel = 4;
        public String[] umaxlevels = new String[]{ReportCircDesc.this.translate("umaxlevel.3"), ReportCircDesc.this.translate("umaxlevel.4"), ReportCircDesc.this.translate("umaxlevel.5"), ReportCircDesc.this.translate("umaxlevel.6"), ReportCircDesc.this.translate("umaxlevel.7"), ReportCircDesc.this.translate("umaxlevel.8"), ReportCircDesc.this.translate("umaxlevel.9"), ReportCircDesc.this.translate("umaxlevel.10"), ReportCircDesc.this.translate("umaxlevel.11"), ReportCircDesc.this.translate("umaxlevel.12")};
        public boolean printYears;
        public boolean printWeddingYear;
    }

    public final class MyColorOptions {
        public int colorScheme = 0;
        public String[] colorSchemes = new String[]{ReportCircDesc.this.translate("colouroption.0"), ReportCircDesc.this.translate("colouroption.1"), ReportCircDesc.this.translate("colouroption.2"), ReportCircDesc.this.translate("colouroption.3"), ReportCircDesc.this.translate("colouroption.4"), ReportCircDesc.this.translate("colouroption.5")};
        public Color sexMColor = new Color(255, 200, 200);
        public Color sexMText = Color.BLUE;
        public Color sexFColor = new Color(200, 200, 255);
        public Color sexFText = Color.RED;
        public Color gradientColor = new Color(130, 255, 130);
        public Color gradientText = Color.WHITE;
    }
}

