/*
 * Decompiled with CFR 0.152.
 */
package org.miv.pherd.geom;

import java.io.Serializable;
import org.miv.pherd.geom.Point2;

public class Vector2
implements Serializable {
    private static final long serialVersionUID = 8839258036865851454L;
    public double[] data = new double[2];

    public Vector2() {
        this.data[0] = 0.0;
        this.data[1] = 0.0;
    }

    public Vector2(double x, double y) {
        this.data[0] = x;
        this.data[1] = y;
    }

    public Vector2(Vector2 other) {
        this.copy(other);
    }

    public Vector2(Point2 point) {
        this.copy(point);
    }

    public boolean isZero() {
        return this.data[0] == 0.0 && this.data[1] == 0.0;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Vector2)) {
            return false;
        }
        Vector2 v = (Vector2)other;
        return this.data[0] == v.data[0] && this.data[1] == v.data[1];
    }

    public boolean equals(Vector2 other) {
        return this.data[0] == other.data[0] && this.data[1] == other.data[1];
    }

    public boolean validComponent(int i) {
        return i >= 0 && i < 2;
    }

    public double at(int i) {
        return this.data[i];
    }

    public Object clone() {
        return new Vector2(this);
    }

    public double dotProduct(Vector2 other) {
        return this.data[0] * other.data[0] + this.data[1] * other.data[1];
    }

    public double length() {
        return Math.sqrt(this.data[0] * this.data[0] + this.data[1] * this.data[1]);
    }

    public void fill(double value) {
        this.data[0] = this.data[1] = value;
    }

    public void set(int i, double value) {
        this.data[i] = value;
    }

    public void set(double x, double y) {
        this.data[0] = x;
        this.data[1] = y;
    }

    public void add(Vector2 other) {
        this.data[0] = this.data[0] + other.data[0];
        this.data[1] = this.data[1] + other.data[1];
    }

    public void sub(Vector2 other) {
        this.data[0] = this.data[0] - other.data[0];
        this.data[1] = this.data[1] - other.data[1];
    }

    public void mult(Vector2 other) {
        this.data[0] = this.data[0] * other.data[0];
        this.data[1] = this.data[1] * other.data[1];
    }

    public void scalarAdd(double value) {
        this.data[0] = this.data[0] + value;
        this.data[1] = this.data[1] + value;
    }

    public void scalarSub(double value) {
        this.data[0] = this.data[0] - value;
        this.data[1] = this.data[1] - value;
    }

    public void scalarMult(double value) {
        this.data[0] = this.data[0] * value;
        this.data[1] = this.data[1] * value;
    }

    public void scalarDiv(double value) {
        this.data[0] = this.data[0] / value;
        this.data[1] = this.data[1] / value;
    }

    public double normalize() {
        double len = this.length();
        if (len != 0.0) {
            this.data[0] = this.data[0] / len;
            this.data[1] = this.data[1] / len;
        }
        return len;
    }

    public void copy(Vector2 other) {
        this.data[0] = other.data[0];
        this.data[1] = other.data[1];
    }

    public void copy(Point2 point) {
        this.data[0] = point.x;
        this.data[1] = point.y;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        sb.append(this.data[0]);
        sb.append('|');
        sb.append(this.data[1]);
        sb.append(']');
        return sb.toString();
    }
}

