/*
 * Decompiled with CFR 0.152.
 */
package org.miv.pherd.ntree;

import java.util.Iterator;
import org.miv.pherd.Particle;
import org.miv.pherd.geom.Point3;
import org.miv.pherd.ntree.Cell;
import org.miv.pherd.ntree.CellData;
import org.miv.pherd.ntree.NTreeListener;

public class BarycenterCellData
implements CellData {
    public Point3 center = new Point3(0.0, 0.0, 0.0);
    public double weight;
    public Cell cell;
    public Object marked = null;

    public Point3 getCenter() {
        return this.center;
    }

    public double getWeight() {
        return this.weight;
    }

    public double distanceFrom(Point3 p) {
        return p.distance(this.center);
    }

    public CellData newCellData() {
        return new BarycenterCellData();
    }

    public void setCell(Cell cell) {
        this.cell = cell;
    }

    public void recompute() {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double n = 0.0;
        this.weight = 0.0;
        if (this.cell.isLeaf()) {
            Iterator<? extends Particle> particles = this.cell.getParticles();
            while (particles.hasNext()) {
                Particle particle = particles.next();
                x += particle.getPosition().x;
                y += particle.getPosition().y;
                z += particle.getPosition().z;
                this.weight += particle.getWeight();
                n += 1.0;
            }
            if (n > 0.0) {
                x /= n;
                y /= n;
                z /= n;
            }
            this.center.set(x, y, z);
        } else {
            double subcnt = this.cell.getSpace().getDivisions();
            double totpop = this.cell.population;
            int verif = 0;
            if (totpop > 0.0) {
                int i = 0;
                while ((double)i < subcnt) {
                    Cell subcell = this.cell.getSub(i);
                    BarycenterCellData data = (BarycenterCellData)subcell.getData();
                    double pop = subcell.population;
                    verif = (int)((double)verif + pop);
                    x += data.center.x * pop;
                    y += data.center.y * pop;
                    z += data.center.z * pop;
                    this.weight += data.weight;
                    ++i;
                }
                assert ((double)verif == totpop) : "Discrepancy in population counts ?";
                x /= totpop;
                y /= totpop;
                z /= totpop;
            }
            this.center.set(x, y, z);
        }
        for (NTreeListener listener : this.cell.tree.listeners) {
            listener.cellData(this.cell.getId(), "barycenter", this);
        }
    }
}

