/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.exports.geneanet.utils;

import ancestris.modules.exports.geneanet.GeneanetSynchronizePanel;
import ancestris.modules.exports.geneanet.entity.GeneanetMedia;
import ancestris.modules.exports.geneanet.entity.GeneanetMediaTypeEnum;
import ancestris.modules.exports.geneanet.entity.GeneanetToken;
import ancestris.modules.exports.geneanet.utils.GeneanetException;
import ancestris.modules.exports.geneanet.utils.GeneanetQueueManager;
import ancestris.modules.exports.geneanet.utils.GeneanetUtil;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import org.openide.util.NbBundle;

public class GeneanetMediaWorker
implements Runnable {
    private static final Logger LOG = Logger.getLogger("ancestris.app", null);
    private final GeneanetQueueManager queueManager;
    private final GeneanetToken theToken;
    private final Set<String> mediaAlreadySentList;
    private final JLabel nbEncoursFile;
    private JLabel encoursFile;

    public GeneanetMediaWorker(GeneanetQueueManager gqm, GeneanetToken token, Set<String> mediaAlreadySentList, JLabel nbEncoursFile, JLabel encoursFile) {
        this.queueManager = gqm;
        this.theToken = token;
        this.mediaAlreadySentList = mediaAlreadySentList;
        this.nbEncoursFile = nbEncoursFile;
        this.encoursFile = encoursFile;
    }

    @Override
    public void run() {
        block4: while (true) {
            try {
                while (true) {
                    GeneanetMedia media;
                    if ((media = this.queueManager.takeMedia()).getType() == GeneanetMediaTypeEnum.STOP) {
                        this.queueManager.putUpdate("STOP");
                        return;
                    }
                    this.nbEncoursFile.setText(String.valueOf(this.queueManager.getCurentNb()));
                    this.encoursFile.setText(media.getPathName());
                    try {
                        GeneanetUtil.sendMedia(this.theToken, media);
                        GeneanetUtil.referenceMedia(this.theToken, media);
                        this.mediaAlreadySentList.add(media.getPathName());
                        continue block4;
                    }
                    catch (GeneanetException e) {
                        LOG.log(Level.INFO, "Error with media : " + media.getPathName(), e);
                        this.queueManager.putUpdate(NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"media.deposit.error") + " " + media.getPathName());
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                LOG.log(Level.INFO, "Interrupted worker.", e);
                return;
            }
        }
    }
}

