// Gamma tables for using with freetype
// don't edit: this file is generated by crengine/Tools/GammaGen/gammagen.cpp
// to rebuild, run crengine/Tools/GammaGen/gen.sh
// 
#define GAMMA_LEVELS 57
#define GAMMA_NO_CORRECTION_INDEX 15


// gamma correction tables, 0..56
extern const unsigned char * cr_gamma_tables[GAMMA_LEVELS];
// gamma correction levels table 0..56
extern const double cr_gamma_levels[GAMMA_LEVELS];
// corrects gamma for value 0..255, gamma_index must be 0..56 (15 means no correction)
inline unsigned char cr_correct_gamma( unsigned char value, int gamma_index ) { return cr_gamma_tables[gamma_index][value]; } 
// corrects gamma for byte buffer; gamma_index must be 0..56 (15 means no correction)
void cr_correct_gamma_buf( unsigned char * buf, int size, int gamma_index );


#ifdef GAMMA_TABLES_IMPL
static const unsigned char gamma_table_0[256] = { // gamma=0.300000
      0,   0,   1,   1,   1,   2,   2,   2,   2,   3,   3,   3,   4,   4,   4,   5,   5,   5,   6,   6,   6,   6, 
      7,   7,   7,   8,   8,   8,   9,   9,   9,  10,  10,  10,  11,  11,  11,  12,  12,  12,  13,  13,  13,  14, 
     14,  14,  15,  15,  15,  16,  16,  17,  17,  17,  18,  18,  18,  19,  19,  19,  20,  20,  20,  21,  21,  22, 
     22,  22,  23,  23,  23,  24,  24,  25,  25,  25,  26,  26,  26,  27,  27,  28,  28,  28,  29,  29,  30,  30, 
     30,  31,  31,  32,  32,  32,  33,  33,  34,  34,  35,  35,  35,  36,  36,  37,  37,  38,  38,  38,  39,  39, 
     40,  40,  41,  41,  42,  42,  42,  43,  43,  44,  44,  45,  45,  46,  46,  47,  47,  48,  48,  49,  49,  50, 
     50,  51,  51,  52,  52,  53,  53,  54,  54,  55,  55,  56,  56,  57,  57,  58,  58,  59,  60,  60,  61,  61, 
     62,  62,  63,  64,  64,  65,  65,  66,  67,  67,  68,  68,  69,  70,  70,  71,  72,  72,  73,  74,  74,  75, 
     76,  76,  77,  78,  78,  79,  80,  81,  81,  82,  83,  83,  84,  85,  86,  87,  87,  88,  89,  90,  91,  91, 
     92,  93,  94,  95,  96,  97,  98,  99, 100, 100, 101, 102, 103, 104, 106, 107, 108, 109, 110, 111, 112, 113, 
    114, 116, 117, 118, 119, 121, 122, 124, 125, 126, 128, 130, 131, 133, 134, 136, 138, 140, 142, 144, 146, 148, 
    151, 153, 156, 158, 161, 165, 168, 172, 177, 182, 188, 195, 207, 255, };
static const unsigned char gamma_table_1[256] = { // gamma=0.350000
      0,   0,   1,   1,   1,   2,   2,   2,   3,   3,   4,   4,   4,   5,   5,   5,   6,   6,   6,   7,   7,   8, 
      8,   8,   9,   9,   9,  10,  10,  11,  11,  11,  12,  12,  12,  13,  13,  14,  14,  14,  15,  15,  16,  16, 
     16,  17,  17,  18,  18,  18,  19,  19,  20,  20,  20,  21,  21,  22,  22,  22,  23,  23,  24,  24,  25,  25, 
     25,  26,  26,  27,  27,  28,  28,  28,  29,  29,  30,  30,  31,  31,  31,  32,  32,  33,  33,  34,  34,  35, 
     35,  36,  36,  37,  37,  37,  38,  38,  39,  39,  40,  40,  41,  41,  42,  42,  43,  43,  44,  44,  45,  45, 
     46,  46,  47,  47,  48,  48,  49,  49,  50,  50,  51,  51,  52,  52,  53,  54,  54,  55,  55,  56,  56,  57, 
     57,  58,  59,  59,  60,  60,  61,  61,  62,  63,  63,  64,  64,  65,  66,  66,  67,  67,  68,  69,  69,  70, 
     71,  71,  72,  73,  73,  74,  75,  75,  76,  77,  77,  78,  79,  79,  80,  81,  81,  82,  83,  84,  84,  85, 
     86,  87,  87,  88,  89,  90,  90,  91,  92,  93,  94,  94,  95,  96,  97,  98,  99, 100, 100, 101, 102, 103, 
    104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 122, 123, 124, 125, 126, 
    128, 129, 130, 132, 133, 134, 136, 137, 139, 140, 142, 143, 145, 147, 149, 150, 152, 154, 156, 158, 160, 163, 
    165, 168, 170, 173, 176, 179, 183, 186, 191, 195, 201, 208, 218, 255, };
static const unsigned char gamma_table_2[256] = { // gamma=0.400000
      0,   0,   1,   1,   2,   2,   2,   3,   3,   4,   4,   4,   5,   5,   6,   6,   7,   7,   7,   8,   8,   9, 
      9,   9,  10,  10,  11,  11,  12,  12,  12,  13,  13,  14,  14,  15,  15,  15,  16,  16,  17,  17,  18,  18, 
     19,  19,  20,  20,  20,  21,  21,  22,  22,  23,  23,  24,  24,  25,  25,  25,  26,  26,  27,  27,  28,  28, 
     29,  29,  30,  30,  31,  31,  32,  32,  33,  33,  34,  34,  35,  35,  36,  36,  37,  37,  38,  38,  39,  39, 
     40,  40,  41,  41,  42,  42,  43,  43,  44,  44,  45,  46,  46,  47,  47,  48,  48,  49,  49,  50,  50,  51, 
     52,  52,  53,  53,  54,  54,  55,  56,  56,  57,  57,  58,  58,  59,  60,  60,  61,  61,  62,  63,  63,  64, 
     65,  65,  66,  66,  67,  68,  68,  69,  70,  70,  71,  72,  72,  73,  73,  74,  75,  76,  76,  77,  78,  78, 
     79,  80,  80,  81,  82,  82,  83,  84,  85,  85,  86,  87,  88,  88,  89,  90,  91,  91,  92,  93,  94,  95, 
     95,  96,  97,  98,  99, 100, 100, 101, 102, 103, 104, 105, 106, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
    115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 128, 129, 130, 131, 132, 133, 135, 136, 137, 138, 
    140, 141, 142, 144, 145, 147, 148, 150, 151, 153, 154, 156, 158, 159, 161, 163, 165, 167, 169, 171, 173, 175, 
    177, 180, 182, 185, 188, 191, 194, 198, 202, 207, 212, 218, 227, 255, };
static const unsigned char gamma_table_3[256] = { // gamma=0.450000
      0,   0,   1,   1,   2,   2,   3,   3,   4,   4,   5,   5,   5,   6,   6,   7,   7,   8,   8,   9,   9,  10, 
     10,  11,  11,  12,  12,  13,  13,  13,  14,  14,  15,  15,  16,  16,  17,  17,  18,  18,  19,  19,  20,  20, 
     21,  21,  22,  22,  23,  23,  24,  24,  25,  25,  26,  26,  27,  27,  28,  28,  29,  30,  30,  31,  31,  32, 
     32,  33,  33,  34,  34,  35,  35,  36,  36,  37,  38,  38,  39,  39,  40,  40,  41,  41,  42,  43,  43,  44, 
     44,  45,  45,  46,  47,  47,  48,  48,  49,  49,  50,  51,  51,  52,  52,  53,  54,  54,  55,  55,  56,  57, 
     57,  58,  58,  59,  60,  60,  61,  62,  62,  63,  63,  64,  65,  65,  66,  67,  67,  68,  69,  69,  70,  71, 
     71,  72,  73,  73,  74,  75,  75,  76,  77,  77,  78,  79,  80,  80,  81,  82,  82,  83,  84,  85,  85,  86, 
     87,  88,  88,  89,  90,  91,  91,  92,  93,  94,  95,  95,  96,  97,  98,  99,  99, 100, 101, 102, 103, 104, 
    105, 105, 106, 107, 108, 109, 110, 111, 112, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 
    125, 126, 127, 128, 129, 130, 131, 133, 134, 135, 136, 137, 138, 139, 141, 142, 143, 144, 145, 147, 148, 149, 
    151, 152, 153, 155, 156, 158, 159, 161, 162, 164, 165, 167, 169, 170, 172, 174, 176, 178, 180, 182, 184, 186, 
    188, 191, 193, 196, 198, 201, 204, 208, 212, 216, 220, 226, 234, 255, };
static const unsigned char gamma_table_4[256] = { // gamma=0.500000
      0,   1,   1,   2,   2,   3,   3,   4,   4,   5,   5,   6,   6,   7,   7,   8,   8,   9,   9,  10,  10,  11, 
     11,  12,  12,  13,  13,  14,  14,  15,  15,  16,  17,  17,  18,  18,  19,  19,  20,  20,  21,  21,  22,  22, 
     23,  24,  24,  25,  25,  26,  26,  27,  27,  28,  29,  29,  30,  30,  31,  31,  32,  33,  33,  34,  34,  35, 
     35,  36,  37,  37,  38,  38,  39,  40,  40,  41,  41,  42,  43,  43,  44,  44,  45,  46,  46,  47,  47,  48, 
     49,  49,  50,  51,  51,  52,  52,  53,  54,  54,  55,  56,  56,  57,  57,  58,  59,  59,  60,  61,  61,  62, 
     63,  63,  64,  65,  65,  66,  67,  67,  68,  69,  69,  70,  71,  72,  72,  73,  74,  74,  75,  76,  76,  77, 
     78,  79,  79,  80,  81,  82,  82,  83,  84,  85,  85,  86,  87,  88,  88,  89,  90,  91,  91,  92,  93,  94, 
     95,  95,  96,  97,  98,  99,  99, 100, 101, 102, 103, 104, 104, 105, 106, 107, 108, 109, 110, 110, 111, 112, 
    113, 114, 115, 116, 117, 118, 119, 120, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 
    134, 136, 137, 138, 139, 140, 141, 142, 143, 144, 146, 147, 148, 149, 150, 152, 153, 154, 155, 157, 158, 159, 
    161, 162, 163, 165, 166, 168, 169, 171, 172, 174, 175, 177, 178, 180, 182, 184, 185, 187, 189, 191, 193, 195, 
    197, 200, 202, 205, 207, 210, 213, 216, 219, 223, 227, 232, 239, 255, };
static const unsigned char gamma_table_5[256] = { // gamma=0.550000
      0,   1,   1,   2,   2,   3,   3,   4,   4,   5,   6,   6,   7,   7,   8,   8,   9,   9,  10,  11,  11,  12, 
     12,  13,  13,  14,  15,  15,  16,  16,  17,  18,  18,  19,  19,  20,  20,  21,  22,  22,  23,  23,  24,  25, 
     25,  26,  26,  27,  28,  28,  29,  29,  30,  31,  31,  32,  33,  33,  34,  34,  35,  36,  36,  37,  37,  38, 
     39,  39,  40,  41,  41,  42,  43,  43,  44,  44,  45,  46,  46,  47,  48,  48,  49,  50,  50,  51,  52,  52, 
     53,  54,  54,  55,  56,  56,  57,  58,  58,  59,  60,  60,  61,  62,  62,  63,  64,  65,  65,  66,  67,  67, 
     68,  69,  69,  70,  71,  72,  72,  73,  74,  75,  75,  76,  77,  77,  78,  79,  80,  80,  81,  82,  83,  83, 
     84,  85,  86,  87,  87,  88,  89,  90,  90,  91,  92,  93,  94,  94,  95,  96,  97,  98,  98,  99, 100, 101, 
    102, 103, 103, 104, 105, 106, 107, 108, 109, 109, 110, 111, 112, 113, 114, 115, 116, 117, 117, 118, 119, 120, 
    121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 
    143, 144, 145, 146, 148, 149, 150, 151, 152, 153, 154, 156, 157, 158, 159, 160, 162, 163, 164, 165, 167, 168, 
    169, 171, 172, 174, 175, 176, 178, 179, 181, 182, 184, 185, 187, 189, 190, 192, 194, 196, 197, 199, 201, 203, 
    205, 208, 210, 212, 214, 217, 220, 223, 226, 229, 233, 237, 243, 255, };
static const unsigned char gamma_table_6[256] = { // gamma=0.600000
      0,   1,   1,   2,   2,   3,   4,   4,   5,   5,   6,   7,   7,   8,   8,   9,  10,  10,  11,  12,  12,  13, 
     13,  14,  15,  15,  16,  17,  17,  18,  18,  19,  20,  20,  21,  22,  22,  23,  24,  24,  25,  25,  26,  27, 
     27,  28,  29,  29,  30,  31,  31,  32,  33,  33,  34,  35,  35,  36,  37,  37,  38,  39,  39,  40,  41,  41, 
     42,  43,  43,  44,  45,  45,  46,  47,  47,  48,  49,  49,  50,  51,  52,  52,  53,  54,  54,  55,  56,  56, 
     57,  58,  59,  59,  60,  61,  61,  62,  63,  64,  64,  65,  66,  67,  67,  68,  69,  70,  70,  71,  72,  73, 
     73,  74,  75,  76,  76,  77,  78,  79,  79,  80,  81,  82,  82,  83,  84,  85,  86,  86,  87,  88,  89,  90, 
     90,  91,  92,  93,  94,  94,  95,  96,  97,  98,  99,  99, 100, 101, 102, 103, 104, 104, 105, 106, 107, 108, 
    109, 110, 110, 111, 112, 113, 114, 115, 116, 117, 118, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 
    129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 
    151, 152, 153, 155, 156, 157, 158, 159, 160, 161, 163, 164, 165, 166, 167, 169, 170, 171, 172, 174, 175, 176, 
    178, 179, 180, 182, 183, 184, 186, 187, 189, 190, 192, 193, 195, 196, 198, 200, 201, 203, 205, 207, 208, 210, 
    212, 214, 216, 218, 221, 223, 226, 228, 231, 234, 237, 241, 246, 255, };
static const unsigned char gamma_table_7[256] = { // gamma=0.650000
      0,   1,   1,   2,   3,   3,   4,   5,   5,   6,   7,   7,   8,   9,   9,  10,  11,  11,  12,  13,  13,  14, 
     15,  15,  16,  17,  17,  18,  19,  19,  20,  21,  21,  22,  23,  23,  24,  25,  25,  26,  27,  27,  28,  29, 
     30,  30,  31,  32,  32,  33,  34,  34,  35,  36,  37,  37,  38,  39,  39,  40,  41,  42,  42,  43,  44,  44, 
     45,  46,  47,  47,  48,  49,  49,  50,  51,  52,  52,  53,  54,  55,  55,  56,  57,  58,  58,  59,  60,  61, 
     61,  62,  63,  64,  64,  65,  66,  67,  67,  68,  69,  70,  70,  71,  72,  73,  74,  74,  75,  76,  77,  78, 
     78,  79,  80,  81,  82,  82,  83,  84,  85,  86,  86,  87,  88,  89,  90,  90,  91,  92,  93,  94,  95,  95, 
     96,  97,  98,  99, 100, 100, 101, 102, 103, 104, 105, 106, 106, 107, 108, 109, 110, 111, 112, 113, 114, 114, 
    115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 
    136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 157, 158, 
    159, 160, 161, 162, 163, 164, 165, 167, 168, 169, 170, 171, 172, 174, 175, 176, 177, 179, 180, 181, 182, 184, 
    185, 186, 187, 189, 190, 192, 193, 194, 196, 197, 199, 200, 202, 203, 205, 206, 208, 209, 211, 213, 215, 216, 
    218, 220, 222, 224, 226, 228, 230, 233, 235, 238, 241, 244, 248, 255, };
static const unsigned char gamma_table_8[256] = { // gamma=0.700000
      0,   1,   1,   2,   3,   4,   4,   5,   6,   6,   7,   8,   8,   9,  10,  11,  11,  12,  13,  13,  14,  15, 
     16,  16,  17,  18,  18,  19,  20,  21,  21,  22,  23,  24,  24,  25,  26,  27,  27,  28,  29,  29,  30,  31, 
     32,  32,  33,  34,  35,  35,  36,  37,  38,  38,  39,  40,  41,  41,  42,  43,  44,  44,  45,  46,  47,  47, 
     48,  49,  50,  51,  51,  52,  53,  54,  54,  55,  56,  57,  58,  58,  59,  60,  61,  61,  62,  63,  64,  65, 
     65,  66,  67,  68,  69,  69,  70,  71,  72,  73,  73,  74,  75,  76,  77,  77,  78,  79,  80,  81,  82,  82, 
     83,  84,  85,  86,  87,  87,  88,  89,  90,  91,  92,  92,  93,  94,  95,  96,  97,  98,  98,  99, 100, 101, 
    102, 103, 104, 105, 105, 106, 107, 108, 109, 110, 111, 112, 113, 113, 114, 115, 116, 117, 118, 119, 120, 121, 
    122, 123, 124, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 
    143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 165, 
    166, 167, 168, 169, 170, 171, 172, 173, 175, 176, 177, 178, 179, 180, 182, 183, 184, 185, 186, 188, 189, 190, 
    191, 193, 194, 195, 197, 198, 199, 201, 202, 203, 205, 206, 208, 209, 211, 212, 214, 215, 217, 218, 220, 222, 
    223, 225, 227, 229, 230, 232, 234, 237, 239, 241, 244, 246, 250, 255, };
static const unsigned char gamma_table_9[256] = { // gamma=0.750000
      0,   1,   2,   2,   3,   4,   5,   5,   6,   7,   8,   8,   9,  10,  11,  11,  12,  13,  14,  14,  15,  16, 
     17,  17,  18,  19,  20,  21,  21,  22,  23,  24,  24,  25,  26,  27,  28,  28,  29,  30,  31,  31,  32,  33, 
     34,  35,  35,  36,  37,  38,  39,  39,  40,  41,  42,  42,  43,  44,  45,  46,  46,  47,  48,  49,  50,  50, 
     51,  52,  53,  54,  55,  55,  56,  57,  58,  59,  59,  60,  61,  62,  63,  64,  64,  65,  66,  67,  68,  69, 
     69,  70,  71,  72,  73,  74,  74,  75,  76,  77,  78,  79,  79,  80,  81,  82,  83,  84,  85,  85,  86,  87, 
     88,  89,  90,  91,  91,  92,  93,  94,  95,  96,  97,  98,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 
    107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
    128, 129, 130, 131, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 
    149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 164, 165, 166, 167, 168, 169, 170, 171, 
    172, 173, 174, 175, 177, 178, 179, 180, 181, 182, 183, 184, 186, 187, 188, 189, 190, 191, 193, 194, 195, 196, 
    197, 199, 200, 201, 203, 204, 205, 206, 208, 209, 210, 212, 213, 214, 216, 217, 219, 220, 222, 223, 225, 226, 
    228, 229, 231, 233, 234, 236, 238, 240, 242, 244, 246, 248, 251, 255, };
static const unsigned char gamma_table_10[256] = { // gamma=0.800000
      0,   1,   2,   2,   3,   4,   5,   6,   6,   7,   8,   9,  10,  10,  11,  12,  13,  14,  15,  15,  16,  17, 
     18,  19,  19,  20,  21,  22,  23,  23,  24,  25,  26,  27,  28,  28,  29,  30,  31,  32,  33,  33,  34,  35, 
     36,  37,  38,  38,  39,  40,  41,  42,  43,  43,  44,  45,  46,  47,  48,  48,  49,  50,  51,  52,  53,  53, 
     54,  55,  56,  57,  58,  59,  59,  60,  61,  62,  63,  64,  65,  65,  66,  67,  68,  69,  70,  71,  72,  72, 
     73,  74,  75,  76,  77,  78,  78,  79,  80,  81,  82,  83,  84,  85,  86,  86,  87,  88,  89,  90,  91,  92, 
     93,  94,  94,  95,  96,  97,  98,  99, 100, 101, 102, 103, 104, 104, 105, 106, 107, 108, 109, 110, 111, 112, 
    113, 114, 115, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 132, 
    133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 
    155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 169, 170, 171, 172, 173, 174, 175, 176, 177, 
    178, 179, 180, 181, 182, 184, 185, 186, 187, 188, 189, 190, 191, 192, 194, 195, 196, 197, 198, 199, 201, 202, 
    203, 204, 205, 207, 208, 209, 210, 211, 213, 214, 215, 216, 218, 219, 220, 222, 223, 224, 226, 227, 229, 230, 
    231, 233, 234, 236, 237, 239, 241, 242, 244, 246, 248, 250, 252, 255, };
static const unsigned char gamma_table_11[256] = { // gamma=0.850000
      0,   1,   2,   3,   3,   4,   5,   6,   7,   8,   9,   9,  10,  11,  12,  13,  14,  15,  15,  16,  17,  18, 
     19,  20,  21,  21,  22,  23,  24,  25,  26,  27,  27,  28,  29,  30,  31,  32,  33,  34,  34,  35,  36,  37, 
     38,  39,  40,  41,  41,  42,  43,  44,  45,  46,  47,  48,  48,  49,  50,  51,  52,  53,  54,  55,  56,  56, 
     57,  58,  59,  60,  61,  62,  63,  64,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  73,  74,  75,  76, 
     77,  78,  79,  80,  81,  82,  83,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  93,  94,  95,  96, 
     97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 
    118, 119, 120, 121, 122, 123, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 
    139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 
    161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 182, 183, 
    184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 196, 197, 198, 199, 200, 201, 202, 203, 204, 206, 207, 
    208, 209, 210, 211, 212, 214, 215, 216, 217, 218, 220, 221, 222, 223, 224, 226, 227, 228, 229, 231, 232, 233, 
    235, 236, 237, 239, 240, 242, 243, 244, 246, 248, 249, 251, 253, 255, };
static const unsigned char gamma_table_12[256] = { // gamma=0.900000
      0,   1,   2,   3,   4,   5,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  14,  15,  16,  17,  18,  19, 
     20,  21,  22,  23,  24,  24,  25,  26,  27,  28,  29,  30,  31,  32,  33,  34,  34,  35,  36,  37,  38,  39, 
     40,  41,  42,  43,  44,  45,  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  57,  58,  59, 
     60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,  80, 
     81,  82,  83,  84,  85,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,  96,  97,  98,  99, 100, 101, 
    102, 103, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 
    123, 124, 125, 126, 127, 128, 129, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 
    144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 
    166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 182, 183, 184, 185, 186, 187, 188, 
    189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 203, 204, 205, 206, 207, 208, 209, 210, 211, 
    212, 213, 215, 216, 217, 218, 219, 220, 221, 222, 223, 225, 226, 227, 228, 229, 230, 232, 233, 234, 235, 236, 
    237, 239, 240, 241, 242, 244, 245, 246, 248, 249, 250, 252, 253, 255, };
static const unsigned char gamma_table_13[256] = { // gamma=0.950000
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  10,  11,  12,  13,  14,  15,  16,  17,  18,  19,  20, 
     21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41, 
     42,  43,  44,  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  54,  55,  56,  57,  58,  59,  60,  61,  62, 
     63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,  80,  81,  82,  82,  83, 
     84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 
    106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 123, 124, 125, 126, 
    127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 
    149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 
    171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 192, 193, 
    194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 
    216, 217, 218, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 236, 237, 238, 239, 
    240, 241, 242, 243, 244, 245, 247, 248, 249, 250, 251, 252, 254, 255, };
static const unsigned char gamma_table_14[256] = { // gamma=0.980000
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,  16,  17,  18,  19,  20,  21, 
     22,  23,  24,  25,  26,  26,  27,  28,  29,  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42, 
     43,  44,  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,  64, 
     65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86, 
     87,  88,  89,  90,  91,  92,  93,  94,  94,  95,  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 
    108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 
    130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 
    152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 
    174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 
    196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 215, 216, 217, 218, 
    219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 
    241, 242, 243, 244, 245, 246, 247, 249, 250, 251, 252, 253, 254, 255, };
static const unsigned char gamma_table_15[256] = { // gamma=1.000000
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,  16,  17,  18,  19,  20,  21, 
     22,  23,  24,  25,  26,  27,  28,  29,  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43, 
     44,  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,  64,  65, 
     66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87, 
     88,  89,  90,  91,  92,  93,  94,  95,  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 
    110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 
    132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
    154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 
    176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 
    198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 
    220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 
    242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, };
static const unsigned char gamma_table_16[256] = { // gamma=1.020000
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,  16,  17,  18,  19,  20,  21, 
     22,  23,  24,  25,  26,  28,  29,  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44, 
     45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,  64,  65,  66, 
     67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88, 
     89,  90,  91,  92,  93,  94,  95,  96,  97,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 
    112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 
    134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 
    156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 
    178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 
    200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 214, 215, 216, 217, 218, 219, 220, 
    221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 
    243, 244, 245, 246, 247, 248, 248, 249, 250, 251, 252, 253, 254, 255, };
static const unsigned char gamma_table_17[256] = { // gamma=1.050000
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  12,  13,  14,  15,  16,  17,  18,  19,  20,  21,  22, 
     23,  24,  25,  26,  27,  28,  29,  30,  31,  32,  33,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45, 
     46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  61,  62,  63,  64,  65,  66,  67,  68, 
     69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, 
     91,  93,  94,  95,  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
    114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 
    136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 
    159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 
    180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 
    202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 219, 220, 221, 222, 
    223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 236, 237, 238, 239, 240, 241, 242, 243, 
    244, 245, 246, 246, 247, 248, 249, 250, 251, 252, 253, 253, 254, 255, };
static const unsigned char gamma_table_18[256] = { // gamma=1.100000
      0,   1,   2,   3,   4,   5,   7,   8,   9,  10,  11,  12,  13,  14,  15,  16,  18,  19,  20,  21,  22,  23, 
     24,  25,  26,  27,  28,  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  43,  44,  45,  46,  47, 
     48,  49,  50,  51,  52,  53,  54,  56,  57,  58,  59,  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  71, 
     72,  73,  74,  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  88,  89,  90,  91,  92,  93,  94, 
     95,  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 
    118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 136, 137, 138, 139, 140, 
    141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 
    163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 
    185, 186, 187, 188, 189, 190, 191, 192, 193, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 
    206, 207, 208, 209, 210, 211, 212, 213, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 224, 225, 
    226, 227, 228, 229, 230, 231, 232, 233, 233, 234, 235, 236, 237, 238, 239, 239, 240, 241, 242, 243, 244, 245, 
    245, 246, 247, 248, 249, 249, 250, 251, 252, 252, 253, 254, 254, 255, };
static const unsigned char gamma_table_19[256] = { // gamma=1.150000
      0,   1,   2,   3,   5,   6,   7,   8,   9,  10,  11,  13,  14,  15,  16,  17,  18,  19,  21,  22,  23,  24, 
     25,  26,  27,  29,  30,  31,  32,  33,  34,  35,  36,  38,  39,  40,  41,  42,  43,  44,  45,  47,  48,  49, 
     50,  51,  52,  53,  54,  55,  57,  58,  59,  60,  61,  62,  63,  64,  65,  67,  68,  69,  70,  71,  72,  73, 
     74,  75,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  89,  90,  91,  92,  93,  94,  95,  96,  97, 
     98,  99, 100, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 118, 119, 120, 121, 
    122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 139, 140, 141, 142, 143, 144, 
    145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
    167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 
    189, 190, 191, 192, 193, 194, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 
    209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 219, 220, 221, 222, 223, 224, 225, 226, 226, 227, 228, 
    229, 230, 231, 232, 232, 233, 234, 235, 236, 237, 237, 238, 239, 240, 241, 241, 242, 243, 244, 244, 245, 246, 
    247, 247, 248, 249, 250, 250, 251, 252, 252, 253, 253, 254, 255, 255, };
static const unsigned char gamma_table_20[256] = { // gamma=1.200000
      0,   1,   2,   4,   5,   6,   7,   8,  10,  11,  12,  13,  14,  16,  17,  18,  19,  20,  21,  23,  24,  25, 
     26,  27,  29,  30,  31,  32,  33,  34,  36,  37,  38,  39,  40,  41,  43,  44,  45,  46,  47,  48,  50,  51, 
     52,  53,  54,  55,  56,  58,  59,  60,  61,  62,  63,  64,  66,  67,  68,  69,  70,  71,  72,  74,  75,  76, 
     77,  78,  79,  80,  82,  83,  84,  85,  86,  87,  88,  89,  90,  92,  93,  94,  95,  96,  97,  98,  99, 100, 
    102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 
    125, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 145, 146, 147, 148, 
    149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 
    171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 
    193, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 206, 207, 208, 209, 210, 211, 212, 
    213, 214, 215, 215, 216, 217, 218, 219, 220, 221, 221, 222, 223, 224, 225, 226, 227, 227, 228, 229, 230, 231, 
    231, 232, 233, 234, 235, 235, 236, 237, 238, 239, 239, 240, 241, 242, 242, 243, 244, 244, 245, 246, 246, 247, 
    248, 248, 249, 250, 250, 251, 252, 252, 253, 253, 254, 254, 255, 255, };
static const unsigned char gamma_table_21[256] = { // gamma=1.250000
      0,   1,   2,   4,   5,   6,   7,   9,  10,  11,  12,  14,  15,  16,  17,  19,  20,  21,  22,  24,  25,  26, 
     27,  28,  30,  31,  32,  33,  35,  36,  37,  38,  39,  41,  42,  43,  44,  45,  47,  48,  49,  50,  51,  53, 
     54,  55,  56,  57,  59,  60,  61,  62,  63,  64,  66,  67,  68,  69,  70,  71,  73,  74,  75,  76,  77,  78, 
     80,  81,  82,  83,  84,  85,  87,  88,  89,  90,  91,  92,  93,  95,  96,  97,  98,  99, 100, 101, 103, 104, 
    105, 106, 107, 108, 109, 110, 111, 113, 114, 115, 116, 117, 118, 119, 120, 121, 123, 124, 125, 126, 127, 128, 
    129, 130, 131, 132, 133, 134, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 
    152, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 
    175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 189, 190, 191, 192, 193, 194, 195, 
    196, 197, 198, 199, 200, 201, 202, 203, 203, 204, 205, 206, 207, 208, 209, 210, 211, 211, 212, 213, 214, 215, 
    216, 217, 218, 218, 219, 220, 221, 222, 223, 223, 224, 225, 226, 227, 227, 228, 229, 230, 231, 231, 232, 233, 
    234, 234, 235, 236, 237, 237, 238, 239, 240, 240, 241, 242, 242, 243, 244, 244, 245, 246, 246, 247, 248, 248, 
    249, 249, 250, 251, 251, 252, 252, 253, 253, 254, 254, 254, 255, 255, };
static const unsigned char gamma_table_22[256] = { // gamma=1.300000
      0,   1,   3,   4,   5,   6,   8,   9,  10,  12,  13,  14,  15,  17,  18,  19,  21,  22,  23,  24,  26,  27, 
     28,  29,  31,  32,  33,  35,  36,  37,  38,  40,  41,  42,  43,  45,  46,  47,  48,  49,  51,  52,  53,  54, 
     56,  57,  58,  59,  61,  62,  63,  64,  65,  67,  68,  69,  70,  71,  73,  74,  75,  76,  77,  79,  80,  81, 
     82,  83,  85,  86,  87,  88,  89,  91,  92,  93,  94,  95,  96,  98,  99, 100, 101, 102, 103, 104, 106, 107, 
    108, 109, 110, 111, 112, 114, 115, 116, 117, 118, 119, 120, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 
    133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 
    156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 
    179, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 198, 
    199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 208, 209, 210, 211, 212, 213, 214, 214, 215, 216, 217, 218, 
    219, 219, 220, 221, 222, 223, 224, 224, 225, 226, 227, 227, 228, 229, 230, 231, 231, 232, 233, 234, 234, 235, 
    236, 236, 237, 238, 239, 239, 240, 241, 241, 242, 243, 243, 244, 244, 245, 246, 246, 247, 247, 248, 249, 249, 
    250, 250, 251, 251, 252, 252, 253, 253, 253, 254, 254, 255, 255, 255, };
static const unsigned char gamma_table_23[256] = { // gamma=1.350000
      0,   1,   3,   4,   5,   7,   8,   9,  11,  12,  13,  15,  16,  17,  19,  20,  21,  23,  24,  25,  27,  28, 
     29,  31,  32,  33,  34,  36,  37,  38,  40,  41,  42,  44,  45,  46,  47,  49,  50,  51,  52,  54,  55,  56, 
     58,  59,  60,  61,  63,  64,  65,  66,  68,  69,  70,  71,  73,  74,  75,  76,  77,  79,  80,  81,  82,  84, 
     85,  86,  87,  88,  90,  91,  92,  93,  94,  96,  97,  98,  99, 100, 102, 103, 104, 105, 106, 107, 109, 110, 
    111, 112, 113, 114, 116, 117, 118, 119, 120, 121, 123, 124, 125, 126, 127, 128, 129, 130, 132, 133, 134, 135, 
    136, 137, 138, 139, 140, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 157, 158, 159, 
    160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 
    182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 
    203, 203, 204, 205, 206, 207, 208, 209, 210, 210, 211, 212, 213, 214, 215, 216, 216, 217, 218, 219, 220, 220, 
    221, 222, 223, 224, 224, 225, 226, 227, 227, 228, 229, 230, 230, 231, 232, 233, 233, 234, 235, 235, 236, 237, 
    238, 238, 239, 240, 240, 241, 241, 242, 243, 243, 244, 245, 245, 246, 246, 247, 247, 248, 248, 249, 249, 250, 
    250, 251, 251, 252, 252, 253, 253, 253, 254, 254, 254, 255, 255, 255, };
static const unsigned char gamma_table_24[256] = { // gamma=1.400000
      0,   1,   3,   4,   6,   7,   8,  10,  11,  13,  14,  15,  17,  18,  19,  21,  22,  23,  25,  26,  28,  29, 
     30,  32,  33,  34,  36,  37,  38,  40,  41,  42,  44,  45,  46,  48,  49,  50,  52,  53,  54,  55,  57,  58, 
     59,  61,  62,  63,  65,  66,  67,  68,  70,  71,  72,  74,  75,  76,  77,  79,  80,  81,  82,  84,  85,  86, 
     87,  89,  90,  91,  92,  94,  95,  96,  97,  98, 100, 101, 102, 103, 104, 106, 107, 108, 109, 110, 112, 113, 
    114, 115, 116, 118, 119, 120, 121, 122, 123, 125, 126, 127, 128, 129, 130, 131, 133, 134, 135, 136, 137, 138, 
    139, 140, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 154, 155, 156, 157, 158, 159, 160, 161, 162, 
    163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 
    185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 198, 199, 200, 201, 202, 203, 204, 205, 
    206, 206, 207, 208, 209, 210, 211, 212, 212, 213, 214, 215, 216, 217, 217, 218, 219, 220, 221, 221, 222, 223, 
    224, 224, 225, 226, 227, 227, 228, 229, 230, 230, 231, 232, 233, 233, 234, 235, 235, 236, 237, 237, 238, 239, 
    239, 240, 240, 241, 242, 242, 243, 243, 244, 245, 245, 246, 246, 247, 247, 248, 248, 249, 249, 250, 250, 251, 
    251, 251, 252, 252, 253, 253, 253, 254, 254, 254, 254, 255, 255, 255, };
static const unsigned char gamma_table_25[256] = { // gamma=1.450000
      0,   1,   3,   4,   6,   7,   9,  10,  12,  13,  14,  16,  17,  19,  20,  21,  23,  24,  26,  27,  28,  30, 
     31,  33,  34,  35,  37,  38,  40,  41,  42,  44,  45,  46,  48,  49,  50,  52,  53,  55,  56,  57,  59,  60, 
     61,  63,  64,  65,  67,  68,  69,  70,  72,  73,  74,  76,  77,  78,  80,  81,  82,  83,  85,  86,  87,  89, 
     90,  91,  92,  94,  95,  96,  97,  99, 100, 101, 102, 104, 105, 106, 107, 108, 110, 111, 112, 113, 115, 116, 
    117, 118, 119, 121, 122, 123, 124, 125, 126, 128, 129, 130, 131, 132, 133, 135, 136, 137, 138, 139, 140, 141, 
    143, 144, 145, 146, 147, 148, 149, 150, 151, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 
    166, 167, 168, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 187, 
    188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 200, 201, 202, 203, 204, 205, 206, 207, 208, 
    208, 209, 210, 211, 212, 213, 213, 214, 215, 216, 217, 217, 218, 219, 220, 221, 221, 222, 223, 224, 224, 225, 
    226, 227, 227, 228, 229, 230, 230, 231, 232, 232, 233, 234, 234, 235, 236, 236, 237, 238, 238, 239, 239, 240, 
    241, 241, 242, 242, 243, 244, 244, 245, 245, 246, 246, 247, 247, 248, 248, 249, 249, 250, 250, 250, 251, 251, 
    252, 252, 252, 253, 253, 253, 254, 254, 254, 254, 255, 255, 255, 255, };
static const unsigned char gamma_table_26[256] = { // gamma=1.500000
      0,   1,   3,   4,   6,   7,   9,  10,  12,  13,  15,  16,  18,  19,  21,  22,  24,  25,  27,  28,  29,  31, 
     32,  34,  35,  37,  38,  39,  41,  42,  44,  45,  46,  48,  49,  51,  52,  53,  55,  56,  58,  59,  60,  62, 
     63,  64,  66,  67,  68,  70,  71,  73,  74,  75,  77,  78,  79,  81,  82,  83,  84,  86,  87,  88,  90,  91, 
     92,  94,  95,  96,  97,  99, 100, 101, 103, 104, 105, 106, 108, 109, 110, 111, 113, 114, 115, 116, 117, 119, 
    120, 121, 122, 123, 125, 126, 127, 128, 129, 131, 132, 133, 134, 135, 136, 138, 139, 140, 141, 142, 143, 145, 
    146, 147, 148, 149, 150, 151, 152, 153, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 169, 
    170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 190, 
    191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 202, 203, 204, 205, 206, 207, 208, 209, 209, 210, 
    211, 212, 213, 214, 214, 215, 216, 217, 218, 218, 219, 220, 221, 221, 222, 223, 224, 224, 225, 226, 227, 227, 
    228, 229, 229, 230, 231, 232, 232, 233, 234, 234, 235, 235, 236, 237, 237, 238, 239, 239, 240, 240, 241, 241, 
    242, 243, 243, 244, 244, 245, 245, 246, 246, 247, 247, 248, 248, 249, 249, 249, 250, 250, 251, 251, 251, 252, 
    252, 252, 253, 253, 253, 254, 254, 254, 254, 254, 255, 255, 255, 255, };
static const unsigned char gamma_table_27[256] = { // gamma=1.600000
      0,   2,   3,   5,   6,   8,  10,  11,  13,  14,  16,  17,  19,  20,  22,  24,  25,  27,  28,  30,  31,  33, 
     34,  36,  37,  39,  40,  42,  43,  45,  46,  48,  49,  51,  52,  54,  55,  57,  58,  59,  61,  62,  64,  65, 
     67,  68,  70,  71,  72,  74,  75,  77,  78,  79,  81,  82,  84,  85,  86,  88,  89,  90,  92,  93,  94,  96, 
     97,  98, 100, 101, 102, 104, 105, 106, 108, 109, 110, 112, 113, 114, 115, 117, 118, 119, 120, 122, 123, 124, 
    125, 127, 128, 129, 130, 132, 133, 134, 135, 136, 138, 139, 140, 141, 142, 144, 145, 146, 147, 148, 149, 151, 
    152, 153, 154, 155, 156, 157, 158, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 174, 175, 
    176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 191, 192, 193, 194, 195, 196, 
    197, 198, 199, 200, 201, 202, 202, 203, 204, 205, 206, 207, 208, 209, 209, 210, 211, 212, 213, 213, 214, 215, 
    216, 217, 217, 218, 219, 220, 221, 221, 222, 223, 224, 224, 225, 226, 226, 227, 228, 228, 229, 230, 230, 231, 
    232, 232, 233, 234, 234, 235, 236, 236, 237, 237, 238, 239, 239, 240, 240, 241, 241, 242, 242, 243, 243, 244, 
    244, 245, 245, 246, 246, 247, 247, 248, 248, 248, 249, 249, 250, 250, 250, 251, 251, 251, 252, 252, 252, 253, 
    253, 253, 253, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_28[256] = { // gamma=1.700000
      0,   2,   3,   5,   7,   8,  10,  12,  13,  15,  17,  18,  20,  22,  23,  25,  27,  28,  30,  31,  33,  35, 
     36,  38,  39,  41,  43,  44,  46,  47,  49,  50,  52,  54,  55,  57,  58,  60,  61,  63,  64,  66,  67,  69, 
     70,  72,  73,  75,  76,  78,  79,  81,  82,  83,  85,  86,  88,  89,  91,  92,  93,  95,  96,  98,  99, 100, 
    102, 103, 104, 106, 107, 109, 110, 111, 113, 114, 115, 117, 118, 119, 121, 122, 123, 124, 126, 127, 128, 130, 
    131, 132, 133, 135, 136, 137, 138, 140, 141, 142, 143, 144, 146, 147, 148, 149, 150, 152, 153, 154, 155, 156, 
    157, 158, 160, 161, 162, 163, 164, 165, 166, 167, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 
    181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 199, 200, 201, 
    202, 203, 204, 205, 206, 207, 207, 208, 209, 210, 211, 212, 212, 213, 214, 215, 216, 216, 217, 218, 219, 219, 
    220, 221, 222, 222, 223, 224, 225, 225, 226, 227, 227, 228, 229, 229, 230, 231, 231, 232, 233, 233, 234, 234, 
    235, 236, 236, 237, 237, 238, 238, 239, 240, 240, 241, 241, 242, 242, 243, 243, 244, 244, 245, 245, 245, 246, 
    246, 247, 247, 248, 248, 248, 249, 249, 249, 250, 250, 250, 251, 251, 251, 252, 252, 252, 252, 253, 253, 253, 
    253, 254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_29[256] = { // gamma=1.800000
      0,   2,   4,   5,   7,   9,  11,  12,  14,  16,  18,  19,  21,  23,  25,  26,  28,  30,  31,  33,  35,  37, 
     38,  40,  42,  43,  45,  47,  48,  50,  51,  53,  55,  56,  58,  60,  61,  63,  64,  66,  67,  69,  71,  72, 
     74,  75,  77,  78,  80,  81,  83,  84,  86,  87,  89,  90,  92,  93,  95,  96,  98,  99, 101, 102, 103, 105, 
    106, 108, 109, 110, 112, 113, 115, 116, 117, 119, 120, 121, 123, 124, 126, 127, 128, 129, 131, 132, 133, 135, 
    136, 137, 139, 140, 141, 142, 144, 145, 146, 147, 148, 150, 151, 152, 153, 155, 156, 157, 158, 159, 160, 162, 
    163, 164, 165, 166, 167, 168, 169, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 
    186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 202, 203, 204, 205, 206, 
    207, 208, 209, 209, 210, 211, 212, 213, 214, 214, 215, 216, 217, 217, 218, 219, 220, 220, 221, 222, 223, 223, 
    224, 225, 225, 226, 227, 227, 228, 229, 229, 230, 231, 231, 232, 233, 233, 234, 234, 235, 236, 236, 237, 237, 
    238, 238, 239, 239, 240, 240, 241, 241, 242, 242, 243, 243, 244, 244, 245, 245, 245, 246, 246, 247, 247, 247, 
    248, 248, 249, 249, 249, 250, 250, 250, 251, 251, 251, 251, 252, 252, 252, 252, 253, 253, 253, 253, 253, 254, 
    254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_30[256] = { // gamma=1.900000
      0,   2,   4,   6,   8,   9,  11,  13,  15,  17,  19,  20,  22,  24,  26,  28,  30,  31,  33,  35,  37,  38, 
     40,  42,  44,  45,  47,  49,  51,  52,  54,  56,  57,  59,  61,  62,  64,  66,  67,  69,  71,  72,  74,  75, 
     77,  79,  80,  82,  83,  85,  87,  88,  90,  91,  93,  94,  96,  97,  99, 100, 102, 103, 105, 106, 108, 109, 
    111, 112, 114, 115, 116, 118, 119, 121, 122, 123, 125, 126, 128, 129, 130, 132, 133, 134, 136, 137, 138, 140, 
    141, 142, 143, 145, 146, 147, 149, 150, 151, 152, 154, 155, 156, 157, 158, 160, 161, 162, 163, 164, 165, 167, 
    168, 169, 170, 171, 172, 173, 174, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 
    191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 202, 203, 204, 205, 206, 207, 208, 209, 209, 210, 
    211, 212, 213, 214, 214, 215, 216, 217, 217, 218, 219, 220, 220, 221, 222, 223, 223, 224, 225, 225, 226, 227, 
    227, 228, 229, 229, 230, 231, 231, 232, 233, 233, 234, 234, 235, 235, 236, 237, 237, 238, 238, 239, 239, 240, 
    240, 241, 241, 242, 242, 243, 243, 243, 244, 244, 245, 245, 246, 246, 246, 247, 247, 247, 248, 248, 248, 249, 
    249, 249, 250, 250, 250, 251, 251, 251, 251, 252, 252, 252, 252, 253, 253, 253, 253, 253, 254, 254, 254, 254, 
    254, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_31[256] = { // gamma=2.000000
      0,   2,   4,   6,   8,  10,  12,  14,  16,  18,  20,  22,  23,  25,  27,  29,  31,  33,  35,  37,  38,  40, 
     42,  44,  46,  48,  49,  51,  53,  55,  56,  58,  60,  62,  63,  65,  67,  69,  70,  72,  74,  75,  77,  79, 
     80,  82,  84,  85,  87,  89,  90,  92,  93,  95,  97,  98, 100, 101, 103, 104, 106, 107, 109, 110, 112, 113, 
    115, 116, 118, 119, 121, 122, 124, 125, 127, 128, 129, 131, 132, 134, 135, 136, 138, 139, 140, 142, 143, 144, 
    146, 147, 148, 150, 151, 152, 153, 155, 156, 157, 158, 160, 161, 162, 163, 164, 166, 167, 168, 169, 170, 171, 
    173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 
    196, 197, 198, 199, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 208, 209, 210, 211, 212, 213, 213, 214, 
    215, 216, 217, 217, 218, 219, 220, 220, 221, 222, 223, 223, 224, 225, 225, 226, 227, 227, 228, 229, 229, 230, 
    231, 231, 232, 232, 233, 234, 234, 235, 235, 236, 236, 237, 237, 238, 238, 239, 239, 240, 240, 241, 241, 242, 
    242, 243, 243, 244, 244, 244, 245, 245, 246, 246, 246, 247, 247, 247, 248, 248, 248, 249, 249, 249, 250, 250, 
    250, 250, 251, 251, 251, 251, 252, 252, 252, 252, 253, 253, 253, 253, 253, 253, 254, 254, 254, 254, 254, 254, 
    254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_32[256] = { // gamma=2.100000
      0,   2,   4,   6,   8,  10,  12,  14,  17,  19,  21,  23,  25,  27,  29,  30,  32,  34,  36,  38,  40,  42, 
     44,  46,  48,  50,  52,  53,  55,  57,  59,  61,  63,  64,  66,  68,  70,  72,  73,  75,  77,  79,  80,  82, 
     84,  85,  87,  89,  90,  92,  94,  95,  97,  99, 100, 102, 104, 105, 107, 108, 110, 111, 113, 114, 116, 118, 
    119, 121, 122, 124, 125, 126, 128, 129, 131, 132, 134, 135, 137, 138, 139, 141, 142, 143, 145, 146, 148, 149, 
    150, 151, 153, 154, 155, 157, 158, 159, 160, 162, 163, 164, 165, 167, 168, 169, 170, 171, 172, 174, 175, 176, 
    177, 178, 179, 180, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 
    200, 201, 202, 203, 204, 204, 205, 206, 207, 208, 209, 210, 211, 211, 212, 213, 214, 215, 215, 216, 217, 218, 
    219, 219, 220, 221, 222, 222, 223, 224, 224, 225, 226, 226, 227, 228, 228, 229, 230, 230, 231, 231, 232, 233, 
    233, 234, 234, 235, 235, 236, 237, 237, 238, 238, 239, 239, 240, 240, 241, 241, 241, 242, 242, 243, 243, 244, 
    244, 244, 245, 245, 246, 246, 246, 247, 247, 247, 248, 248, 248, 249, 249, 249, 250, 250, 250, 250, 251, 251, 
    251, 251, 252, 252, 252, 252, 252, 253, 253, 253, 253, 253, 253, 254, 254, 254, 254, 254, 254, 254, 254, 254, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_33[256] = { // gamma=2.200000
      0,   2,   4,   7,   9,  11,  13,  15,  17,  19,  21,  24,  26,  28,  30,  32,  34,  36,  38,  40,  42,  44, 
     46,  48,  50,  52,  54,  56,  58,  59,  61,  63,  65,  67,  69,  71,  73,  74,  76,  78,  80,  82,  83,  85, 
     87,  89,  90,  92,  94,  96,  97,  99, 101, 102, 104, 106, 107, 109, 110, 112, 114, 115, 117, 118, 120, 122, 
    123, 125, 126, 128, 129, 131, 132, 134, 135, 136, 138, 139, 141, 142, 144, 145, 146, 148, 149, 150, 152, 153, 
    155, 156, 157, 158, 160, 161, 162, 164, 165, 166, 167, 168, 170, 171, 172, 173, 174, 176, 177, 178, 179, 180, 
    181, 182, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 
    204, 205, 206, 206, 207, 208, 209, 210, 211, 212, 212, 213, 214, 215, 216, 216, 217, 218, 219, 220, 220, 221, 
    222, 222, 223, 224, 225, 225, 226, 227, 227, 228, 229, 229, 230, 230, 231, 232, 232, 233, 233, 234, 235, 235, 
    236, 236, 237, 237, 238, 238, 239, 239, 240, 240, 241, 241, 242, 242, 242, 243, 243, 244, 244, 244, 245, 245, 
    246, 246, 246, 247, 247, 247, 248, 248, 248, 249, 249, 249, 249, 250, 250, 250, 250, 251, 251, 251, 251, 252, 
    252, 252, 252, 252, 253, 253, 253, 253, 253, 253, 253, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_34[256] = { // gamma=2.300000
      0,   2,   5,   7,   9,  11,  14,  16,  18,  20,  22,  25,  27,  29,  31,  33,  35,  37,  40,  42,  44,  46, 
     48,  50,  52,  54,  56,  58,  60,  62,  64,  66,  68,  70,  72,  73,  75,  77,  79,  81,  83,  85,  86,  88, 
     90,  92,  94,  95,  97,  99, 101, 102, 104, 106, 107, 109, 111, 112, 114, 116, 117, 119, 121, 122, 124, 125, 
    127, 129, 130, 132, 133, 135, 136, 138, 139, 141, 142, 143, 145, 146, 148, 149, 151, 152, 153, 155, 156, 157, 
    159, 160, 161, 163, 164, 165, 166, 168, 169, 170, 171, 173, 174, 175, 176, 177, 179, 180, 181, 182, 183, 184, 
    185, 186, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 206, 
    207, 208, 209, 210, 211, 212, 213, 213, 214, 215, 216, 217, 217, 218, 219, 220, 220, 221, 222, 223, 223, 224, 
    225, 225, 226, 227, 227, 228, 229, 229, 230, 231, 231, 232, 232, 233, 234, 234, 235, 235, 236, 236, 237, 237, 
    238, 238, 239, 239, 240, 240, 241, 241, 242, 242, 242, 243, 243, 244, 244, 244, 245, 245, 245, 246, 246, 247, 
    247, 247, 248, 248, 248, 248, 249, 249, 249, 250, 250, 250, 250, 251, 251, 251, 251, 251, 252, 252, 252, 252, 
    252, 253, 253, 253, 253, 253, 253, 253, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_35[256] = { // gamma=2.400000
      0,   2,   5,   7,   9,  12,  14,  16,  19,  21,  23,  26,  28,  30,  32,  35,  37,  39,  41,  43,  45,  48, 
     50,  52,  54,  56,  58,  60,  62,  64,  66,  68,  70,  72,  74,  76,  78,  80,  82,  84,  86,  88,  89,  91, 
     93,  95,  97,  99, 100, 102, 104, 106, 107, 109, 111, 113, 114, 116, 118, 119, 121, 123, 124, 126, 128, 129, 
    131, 132, 134, 135, 137, 138, 140, 141, 143, 144, 146, 147, 149, 150, 152, 153, 155, 156, 157, 159, 160, 161, 
    163, 164, 165, 167, 168, 169, 170, 172, 173, 174, 175, 177, 178, 179, 180, 181, 182, 184, 185, 186, 187, 188, 
    189, 190, 191, 192, 193, 195, 196, 197, 198, 199, 200, 201, 202, 202, 203, 204, 205, 206, 207, 208, 209, 210, 
    211, 212, 212, 213, 214, 215, 216, 216, 217, 218, 219, 220, 220, 221, 222, 223, 223, 224, 225, 225, 226, 227, 
    227, 228, 229, 229, 230, 231, 231, 232, 232, 233, 233, 234, 235, 235, 236, 236, 237, 237, 238, 238, 239, 239, 
    240, 240, 241, 241, 241, 242, 242, 243, 243, 244, 244, 244, 245, 245, 245, 246, 246, 246, 247, 247, 247, 248, 
    248, 248, 249, 249, 249, 249, 250, 250, 250, 250, 251, 251, 251, 251, 251, 252, 252, 252, 252, 252, 253, 253, 
    253, 253, 253, 253, 253, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_36[256] = { // gamma=2.500000
      0,   2,   5,   7,  10,  12,  15,  17,  20,  22,  24,  27,  29,  31,  34,  36,  38,  40,  43,  45,  47,  49, 
     51,  54,  56,  58,  60,  62,  64,  66,  69,  71,  73,  75,  77,  79,  81,  83,  85,  87,  89,  90,  92,  94, 
     96,  98, 100, 102, 104, 105, 107, 109, 111, 113, 114, 116, 118, 120, 121, 123, 125, 126, 128, 130, 131, 133, 
    134, 136, 138, 139, 141, 142, 144, 145, 147, 148, 150, 151, 153, 154, 156, 157, 158, 160, 161, 162, 164, 165, 
    166, 168, 169, 170, 172, 173, 174, 175, 177, 178, 179, 180, 182, 183, 184, 185, 186, 187, 188, 190, 191, 192, 
    193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 209, 210, 211, 212, 213, 
    214, 215, 215, 216, 217, 218, 219, 219, 220, 221, 222, 222, 223, 224, 225, 225, 226, 227, 227, 228, 229, 229, 
    230, 230, 231, 232, 232, 233, 233, 234, 235, 235, 236, 236, 237, 237, 238, 238, 239, 239, 240, 240, 240, 241, 
    241, 242, 242, 243, 243, 243, 244, 244, 245, 245, 245, 246, 246, 246, 247, 247, 247, 248, 248, 248, 248, 249, 
    249, 249, 249, 250, 250, 250, 250, 251, 251, 251, 251, 251, 252, 252, 252, 252, 252, 253, 253, 253, 253, 253, 
    253, 253, 253, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_37[256] = { // gamma=2.600000
      0,   3,   5,   8,  10,  13,  15,  18,  20,  23,  25,  28,  30,  32,  35,  37,  40,  42,  44,  46,  49,  51, 
     53,  56,  58,  60,  62,  64,  67,  69,  71,  73,  75,  77,  79,  81,  83,  85,  87,  89,  91,  93,  95,  97, 
     99, 101, 103, 105, 107, 109, 110, 112, 114, 116, 118, 119, 121, 123, 125, 126, 128, 130, 131, 133, 135, 136, 
    138, 140, 141, 143, 144, 146, 147, 149, 150, 152, 153, 155, 156, 158, 159, 161, 162, 163, 165, 166, 167, 169, 
    170, 171, 173, 174, 175, 177, 178, 179, 180, 182, 183, 184, 185, 186, 187, 189, 190, 191, 192, 193, 194, 195, 
    196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 213, 214, 215, 216, 
    217, 217, 218, 219, 220, 221, 221, 222, 223, 224, 224, 225, 226, 226, 227, 228, 228, 229, 230, 230, 231, 231, 
    232, 233, 233, 234, 234, 235, 235, 236, 236, 237, 237, 238, 238, 239, 239, 240, 240, 241, 241, 242, 242, 242, 
    243, 243, 244, 244, 244, 245, 245, 245, 246, 246, 246, 247, 247, 247, 248, 248, 248, 249, 249, 249, 249, 250, 
    250, 250, 250, 250, 251, 251, 251, 251, 252, 252, 252, 252, 252, 252, 253, 253, 253, 253, 253, 253, 253, 253, 
    254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_38[256] = { // gamma=2.700000
      0,   3,   5,   8,  11,  13,  16,  18,  21,  24,  26,  29,  31,  34,  36,  39,  41,  43,  46,  48,  50,  53, 
     55,  57,  60,  62,  64,  67,  69,  71,  73,  75,  77,  80,  82,  84,  86,  88,  90,  92,  94,  96,  98, 100, 
    102, 104, 106, 108, 110, 112, 114, 115, 117, 119, 121, 123, 124, 126, 128, 130, 131, 133, 135, 136, 138, 140, 
    141, 143, 145, 146, 148, 149, 151, 152, 154, 155, 157, 158, 160, 161, 163, 164, 166, 167, 168, 170, 171, 172, 
    174, 175, 176, 178, 179, 180, 181, 183, 184, 185, 186, 187, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 
    199, 200, 202, 203, 204, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 214, 215, 216, 217, 218, 219, 
    219, 220, 221, 222, 222, 223, 224, 225, 225, 226, 227, 227, 228, 229, 229, 230, 231, 231, 232, 232, 233, 234, 
    234, 235, 235, 236, 236, 237, 237, 238, 238, 239, 239, 240, 240, 241, 241, 241, 242, 242, 243, 243, 243, 244, 
    244, 245, 245, 245, 246, 246, 246, 247, 247, 247, 248, 248, 248, 248, 249, 249, 249, 249, 250, 250, 250, 250, 
    251, 251, 251, 251, 251, 252, 252, 252, 252, 252, 252, 252, 253, 253, 253, 253, 253, 253, 253, 254, 254, 254, 
    254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_39[256] = { // gamma=2.800000
      0,   3,   6,   8,  11,  14,  16,  19,  22,  24,  27,  30,  32,  35,  37,  40,  42,  45,  47,  50,  52,  55, 
     57,  59,  62,  64,  66,  69,  71,  73,  75,  78,  80,  82,  84,  86,  88,  91,  93,  95,  97,  99, 101, 103, 
    105, 107, 109, 111, 113, 115, 117, 118, 120, 122, 124, 126, 128, 129, 131, 133, 135, 136, 138, 140, 141, 143, 
    145, 146, 148, 150, 151, 153, 154, 156, 157, 159, 160, 162, 163, 165, 166, 168, 169, 170, 172, 173, 174, 176, 
    177, 178, 180, 181, 182, 183, 185, 186, 187, 188, 189, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 
    203, 204, 205, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 216, 217, 218, 219, 220, 220, 221, 
    222, 223, 223, 224, 225, 226, 226, 227, 228, 228, 229, 230, 230, 231, 231, 232, 233, 233, 234, 234, 235, 235, 
    236, 236, 237, 237, 238, 238, 239, 239, 240, 240, 241, 241, 242, 242, 242, 243, 243, 244, 244, 244, 245, 245, 
    245, 246, 246, 246, 247, 247, 247, 248, 248, 248, 248, 249, 249, 249, 249, 250, 250, 250, 250, 251, 251, 251, 
    251, 251, 252, 252, 252, 252, 252, 252, 252, 253, 253, 253, 253, 253, 253, 253, 253, 254, 254, 254, 254, 254, 
    254, 254, 254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_40[256] = { // gamma=2.900000
      0,   3,   6,   9,  11,  14,  17,  20,  23,  25,  28,  31,  33,  36,  39,  41,  44,  46,  49,  51,  54,  56, 
     59,  61,  64,  66,  68,  71,  73,  75,  78,  80,  82,  84,  87,  89,  91,  93,  95,  97, 100, 102, 104, 106, 
    108, 110, 112, 114, 116, 118, 120, 121, 123, 125, 127, 129, 131, 133, 134, 136, 138, 140, 141, 143, 145, 146, 
    148, 150, 151, 153, 154, 156, 158, 159, 161, 162, 164, 165, 167, 168, 169, 171, 172, 174, 175, 176, 178, 179, 
    180, 182, 183, 184, 185, 187, 188, 189, 190, 191, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 
    205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 216, 217, 218, 219, 220, 220, 221, 222, 223, 223, 
    224, 225, 226, 226, 227, 228, 228, 229, 230, 230, 231, 232, 232, 233, 233, 234, 234, 235, 236, 236, 237, 237, 
    238, 238, 239, 239, 240, 240, 240, 241, 241, 242, 242, 243, 243, 243, 244, 244, 244, 245, 245, 246, 246, 246, 
    246, 247, 247, 247, 248, 248, 248, 248, 249, 249, 249, 249, 250, 250, 250, 250, 251, 251, 251, 251, 251, 252, 
    252, 252, 252, 252, 252, 252, 253, 253, 253, 253, 253, 253, 253, 253, 254, 254, 254, 254, 254, 254, 254, 254, 
    254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_41[256] = { // gamma=3.000000
      0,   3,   6,   9,  12,  15,  18,  20,  23,  26,  29,  32,  34,  37,  40,  42,  45,  48,  50,  53,  55,  58, 
     60,  63,  65,  68,  70,  73,  75,  77,  80,  82,  84,  87,  89,  91,  93,  96,  98, 100, 102, 104, 106, 108, 
    111, 113, 115, 117, 119, 121, 123, 124, 126, 128, 130, 132, 134, 136, 137, 139, 141, 143, 144, 146, 148, 150, 
    151, 153, 154, 156, 158, 159, 161, 162, 164, 165, 167, 168, 170, 171, 173, 174, 175, 177, 178, 179, 181, 182, 
    183, 185, 186, 187, 188, 190, 191, 192, 193, 194, 195, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 
    208, 209, 210, 211, 212, 213, 214, 215, 215, 216, 217, 218, 219, 220, 220, 221, 222, 223, 223, 224, 225, 226, 
    226, 227, 228, 228, 229, 230, 230, 231, 232, 232, 233, 233, 234, 235, 235, 236, 236, 237, 237, 238, 238, 239, 
    239, 240, 240, 241, 241, 241, 242, 242, 243, 243, 243, 244, 244, 245, 245, 245, 246, 246, 246, 247, 247, 247, 
    247, 248, 248, 248, 249, 249, 249, 249, 249, 250, 250, 250, 250, 251, 251, 251, 251, 251, 252, 252, 252, 252, 
    252, 252, 252, 253, 253, 253, 253, 253, 253, 253, 253, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 
    254, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_42[256] = { // gamma=3.500000
      0,   3,   7,  10,  14,  17,  20,  24,  27,  30,  33,  36,  40,  43,  46,  49,  52,  55,  58,  61,  63,  66, 
     69,  72,  75,  77,  80,  83,  85,  88,  90,  93,  96,  98, 100, 103, 105, 108, 110, 112, 115, 117, 119, 121, 
    124, 126, 128, 130, 132, 134, 136, 138, 140, 142, 144, 146, 148, 150, 152, 153, 155, 157, 159, 161, 162, 164, 
    166, 167, 169, 170, 172, 174, 175, 177, 178, 180, 181, 183, 184, 185, 187, 188, 189, 191, 192, 193, 195, 196, 
    197, 198, 199, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 
    220, 220, 221, 222, 223, 224, 225, 225, 226, 227, 227, 228, 229, 230, 230, 231, 232, 232, 233, 233, 234, 235, 
    235, 236, 236, 237, 237, 238, 238, 239, 239, 240, 240, 241, 241, 242, 242, 242, 243, 243, 244, 244, 244, 245, 
    245, 245, 246, 246, 246, 247, 247, 247, 248, 248, 248, 248, 249, 249, 249, 249, 250, 250, 250, 250, 250, 251, 
    251, 251, 251, 251, 251, 252, 252, 252, 252, 252, 252, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 254, 
    254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_43[256] = { // gamma=4.000000
      0,   4,   8,  12,  16,  19,  23,  27,  31,  34,  38,  41,  45,  48,  52,  55,  58,  61,  65,  68,  71,  74, 
     77,  80,  83,  86,  89,  92,  95,  98, 100, 103, 106, 109, 111, 114, 116, 119, 121, 124, 126, 129, 131, 133, 
    135, 138, 140, 142, 144, 146, 148, 151, 153, 155, 157, 159, 160, 162, 164, 166, 168, 170, 171, 173, 175, 176, 
    178, 180, 181, 183, 184, 186, 187, 189, 190, 192, 193, 194, 196, 197, 198, 200, 201, 202, 203, 205, 206, 207, 
    208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 224, 225, 226, 227, 228, 
    228, 229, 230, 230, 231, 232, 232, 233, 234, 234, 235, 236, 236, 237, 237, 238, 238, 239, 239, 240, 240, 241, 
    241, 242, 242, 242, 243, 243, 244, 244, 244, 245, 245, 246, 246, 246, 246, 247, 247, 247, 248, 248, 248, 248, 
    249, 249, 249, 249, 250, 250, 250, 250, 250, 251, 251, 251, 251, 251, 252, 252, 252, 252, 252, 252, 252, 253, 
    253, 253, 253, 253, 253, 253, 253, 253, 253, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 
    254, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_44[256] = { // gamma=4.500000
      0,   4,   9,  13,  18,  22,  26,  30,  34,  38,  42,  46,  50,  53,  57,  61,  64,  68,  72,  75,  78,  82, 
     85,  88,  92,  95,  98, 101, 104, 107, 110, 113, 116, 118, 121, 124, 126, 129, 132, 134, 137, 139, 142, 144, 
    146, 149, 151, 153, 155, 157, 160, 162, 164, 166, 168, 170, 171, 173, 175, 177, 179, 180, 182, 184, 186, 187, 
    189, 190, 192, 193, 195, 196, 198, 199, 200, 202, 203, 204, 206, 207, 208, 209, 211, 212, 213, 214, 215, 216, 
    217, 218, 219, 220, 221, 222, 223, 224, 225, 225, 226, 227, 228, 229, 229, 230, 231, 232, 232, 233, 234, 234, 
    235, 236, 236, 237, 237, 238, 238, 239, 239, 240, 240, 241, 241, 242, 242, 243, 243, 244, 244, 244, 245, 245, 
    245, 246, 246, 246, 247, 247, 247, 248, 248, 248, 248, 249, 249, 249, 249, 250, 250, 250, 250, 250, 251, 251, 
    251, 251, 251, 252, 252, 252, 252, 252, 252, 252, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 254, 254, 
    254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_45[256] = { // gamma=5.000000
      0,   5,  10,  15,  19,  24,  29,  33,  38,  42,  46,  50,  55,  59,  63,  67,  71,  74,  78,  82,  85,  89, 
     93,  96,  99, 103, 106, 109, 112, 116, 119, 122, 125, 127, 130, 133, 136, 139, 141, 144, 146, 149, 151, 154, 
    156, 158, 161, 163, 165, 167, 169, 171, 173, 175, 177, 179, 181, 183, 185, 187, 188, 190, 192, 193, 195, 196, 
    198, 199, 201, 202, 204, 205, 206, 208, 209, 210, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 
    224, 225, 226, 227, 228, 229, 229, 230, 231, 232, 232, 233, 234, 235, 235, 236, 236, 237, 238, 238, 239, 239, 
    240, 240, 241, 241, 242, 242, 243, 243, 244, 244, 244, 245, 245, 246, 246, 246, 247, 247, 247, 247, 248, 248, 
    248, 249, 249, 249, 249, 250, 250, 250, 250, 250, 251, 251, 251, 251, 251, 252, 252, 252, 252, 252, 252, 252, 
    253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 
    254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_46[256] = { // gamma=5.500000
      0,   5,  11,  16,  21,  26,  31,  36,  41,  46,  50,  55,  59,  64,  68,  72,  76,  81,  85,  88,  92,  96, 
    100, 103, 107, 110, 114, 117, 121, 124, 127, 130, 133, 136, 139, 142, 145, 147, 150, 153, 155, 158, 160, 163, 
    165, 167, 170, 172, 174, 176, 178, 180, 182, 184, 186, 188, 190, 192, 193, 195, 197, 198, 200, 201, 203, 204, 
    206, 207, 209, 210, 211, 213, 214, 215, 216, 217, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 228, 229, 
    230, 231, 232, 232, 233, 234, 235, 235, 236, 237, 237, 238, 239, 239, 240, 240, 241, 241, 242, 242, 243, 243, 
    244, 244, 244, 245, 245, 246, 246, 246, 247, 247, 247, 248, 248, 248, 248, 249, 249, 249, 249, 250, 250, 250, 
    250, 251, 251, 251, 251, 251, 251, 252, 252, 252, 252, 252, 252, 252, 253, 253, 253, 253, 253, 253, 253, 253, 
    253, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_47[256] = { // gamma=6.000000
      0,   6,  12,  17,  23,  29,  34,  39,  44,  49,  54,  59,  64,  69,  73,  78,  82,  86,  91,  95,  99, 103, 
    107, 110, 114, 118, 121, 125, 128, 131, 135, 138, 141, 144, 147, 150, 153, 155, 158, 161, 163, 166, 168, 171, 
    173, 175, 178, 180, 182, 184, 186, 188, 190, 192, 194, 196, 197, 199, 201, 202, 204, 206, 207, 209, 210, 211, 
    213, 214, 215, 217, 218, 219, 220, 221, 222, 223, 224, 226, 226, 227, 228, 229, 230, 231, 232, 233, 233, 234, 
    235, 236, 236, 237, 238, 238, 239, 239, 240, 241, 241, 242, 242, 243, 243, 244, 244, 244, 245, 245, 246, 246, 
    246, 247, 247, 247, 248, 248, 248, 249, 249, 249, 249, 250, 250, 250, 250, 251, 251, 251, 251, 251, 251, 252, 
    252, 252, 252, 252, 252, 252, 253, 253, 253, 253, 253, 253, 253, 253, 253, 254, 254, 254, 254, 254, 254, 254, 
    254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_48[256] = { // gamma=7.000000
      0,   7,  14,  20,  27,  33,  39,  45,  51,  57,  62,  68,  73,  78,  83,  88,  93,  98, 102, 107, 111, 115, 
    119, 123, 127, 131, 135, 139, 142, 145, 149, 152, 155, 158, 161, 164, 167, 170, 173, 175, 178, 180, 183, 185, 
    187, 189, 192, 194, 196, 198, 200, 202, 203, 205, 207, 208, 210, 212, 213, 215, 216, 217, 219, 220, 221, 222, 
    224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 234, 235, 236, 237, 237, 238, 239, 239, 240, 241, 241, 
    242, 242, 243, 243, 244, 244, 245, 245, 246, 246, 246, 247, 247, 248, 248, 248, 248, 249, 249, 249, 250, 250, 
    250, 250, 251, 251, 251, 251, 251, 252, 252, 252, 252, 252, 252, 252, 253, 253, 253, 253, 253, 253, 253, 253, 
    253, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_49[256] = { // gamma=8.000000
      0,   8,  16,  23,  30,  37,  44,  51,  57,  64,  70,  76,  82,  87,  93,  98, 103, 108, 113, 118, 122, 127, 
    131, 135, 139, 143, 147, 151, 154, 158, 161, 165, 168, 171, 174, 177, 180, 182, 185, 187, 190, 192, 195, 197, 
    199, 201, 203, 205, 207, 209, 211, 212, 214, 215, 217, 218, 220, 221, 223, 224, 225, 226, 228, 229, 230, 231, 
    232, 233, 234, 235, 235, 236, 237, 238, 239, 239, 240, 241, 241, 242, 242, 243, 244, 244, 245, 245, 246, 246, 
    246, 247, 247, 248, 248, 248, 249, 249, 249, 249, 250, 250, 250, 250, 251, 251, 251, 251, 252, 252, 252, 252, 
    252, 252, 253, 253, 253, 253, 253, 253, 253, 253, 253, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 
    254, 254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_50[256] = { // gamma=9.000000
      0,   9,  17,  26,  34,  42,  49,  57,  64,  70,  77,  84,  90,  96, 102, 107, 113, 118, 123, 128, 133, 137, 
    142, 146, 150, 154, 158, 162, 165, 169, 172, 176, 179, 182, 185, 187, 190, 193, 195, 198, 200, 202, 205, 207, 
    209, 211, 212, 214, 216, 218, 219, 221, 222, 224, 225, 226, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 
    238, 239, 239, 240, 241, 241, 242, 243, 243, 244, 244, 245, 245, 246, 246, 247, 247, 248, 248, 248, 249, 249, 
    249, 250, 250, 250, 250, 251, 251, 251, 251, 252, 252, 252, 252, 252, 252, 253, 253, 253, 253, 253, 253, 253, 
    253, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_51[256] = { // gamma=10.000000
      0,  10,  19,  28,  37,  46,  54,  62,  70,  77,  84,  91,  98, 104, 110, 116, 122, 127, 132, 137, 142, 147, 
    152, 156, 160, 164, 168, 172, 175, 179, 182, 185, 188, 191, 194, 197, 199, 202, 204, 207, 209, 211, 213, 215, 
    217, 218, 220, 222, 223, 225, 226, 228, 229, 230, 231, 233, 234, 235, 236, 237, 238, 238, 239, 240, 241, 242, 
    242, 243, 244, 244, 245, 245, 246, 246, 247, 247, 248, 248, 248, 249, 249, 249, 250, 250, 250, 251, 251, 251, 
    251, 252, 252, 252, 252, 252, 252, 253, 253, 253, 253, 253, 253, 253, 253, 254, 254, 254, 254, 254, 254, 254, 
    254, 254, 254, 254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_52[256] = { // gamma=11.000000
      0,  11,  21,  31,  41,  50,  59,  67,  75,  83,  91,  98, 105, 112, 118, 124, 130, 136, 141, 146, 151, 156, 
    160, 165, 169, 173, 177, 181, 184, 187, 191, 194, 197, 199, 202, 205, 207, 210, 212, 214, 216, 218, 220, 222, 
    223, 225, 226, 228, 229, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 242, 243, 244, 244, 245, 
    246, 246, 247, 247, 248, 248, 248, 249, 249, 249, 250, 250, 250, 251, 251, 251, 251, 252, 252, 252, 252, 252, 
    253, 253, 253, 253, 253, 253, 253, 253, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 
    254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_53[256] = { // gamma=12.000000
      0,  12,  23,  34,  44,  54,  63,  72,  81,  89,  97, 105, 112, 119, 126, 132, 138, 144, 149, 154, 159, 164, 
    169, 173, 177, 181, 185, 188, 192, 195, 198, 201, 204, 207, 209, 212, 214, 216, 218, 220, 222, 224, 226, 227, 
    229, 230, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 243, 244, 245, 245, 246, 247, 247, 248, 
    248, 248, 249, 249, 250, 250, 250, 251, 251, 251, 251, 252, 252, 252, 252, 252, 253, 253, 253, 253, 253, 253, 
    253, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_54[256] = { // gamma=13.000000
      0,  13,  25,  36,  47,  58,  68,  77,  87,  95, 103, 111, 119, 126, 133, 139, 145, 151, 157, 162, 167, 172, 
    176, 180, 184, 188, 192, 195, 199, 202, 205, 208, 210, 213, 215, 218, 220, 222, 224, 226, 227, 229, 230, 232, 
    233, 235, 236, 237, 238, 239, 240, 241, 242, 243, 243, 244, 245, 245, 246, 247, 247, 248, 248, 249, 249, 249, 
    250, 250, 250, 251, 251, 251, 252, 252, 252, 252, 252, 253, 253, 253, 253, 253, 253, 253, 254, 254, 254, 254, 
    254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_55[256] = { // gamma=14.000000
      0,  14,  27,  39,  51,  62,  72,  82,  92, 101, 109, 117, 125, 132, 139, 146, 152, 158, 163, 169, 174, 178, 
    183, 187, 191, 195, 198, 202, 205, 208, 211, 213, 216, 218, 221, 223, 225, 227, 228, 230, 232, 233, 234, 236, 
    237, 238, 239, 240, 241, 242, 243, 244, 245, 245, 246, 247, 247, 248, 248, 249, 249, 249, 250, 250, 251, 251, 
    251, 251, 252, 252, 252, 252, 253, 253, 253, 253, 253, 253, 253, 254, 254, 254, 254, 254, 254, 254, 254, 254, 
    254, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };
static const unsigned char gamma_table_56[256] = { // gamma=15.000000
      0,  15,  28,  41,  54,  66,  77,  87,  97, 106, 115, 123, 131, 139, 146, 152, 159, 164, 170, 175, 180, 185, 
    189, 193, 197, 201, 204, 207, 210, 213, 216, 219, 221, 223, 225, 227, 229, 231, 232, 234, 235, 237, 238, 239, 
    240, 241, 242, 243, 244, 245, 245, 246, 247, 247, 248, 248, 249, 249, 250, 250, 250, 251, 251, 251, 252, 252, 
    252, 252, 253, 253, 253, 253, 253, 253, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };

const unsigned char * cr_gamma_tables[GAMMA_LEVELS] = {
    gamma_table_0, // 0.300000 
    gamma_table_1, // 0.350000 
    gamma_table_2, // 0.400000 
    gamma_table_3, // 0.450000 
    gamma_table_4, // 0.500000 
    gamma_table_5, // 0.550000 
    gamma_table_6, // 0.600000 
    gamma_table_7, // 0.650000 
    gamma_table_8, // 0.700000 
    gamma_table_9, // 0.750000 
    gamma_table_10, // 0.800000 
    gamma_table_11, // 0.850000 
    gamma_table_12, // 0.900000 
    gamma_table_13, // 0.950000 
    gamma_table_14, // 0.980000 
    gamma_table_15, // 1.000000 
    gamma_table_16, // 1.020000 
    gamma_table_17, // 1.050000 
    gamma_table_18, // 1.100000 
    gamma_table_19, // 1.150000 
    gamma_table_20, // 1.200000 
    gamma_table_21, // 1.250000 
    gamma_table_22, // 1.300000 
    gamma_table_23, // 1.350000 
    gamma_table_24, // 1.400000 
    gamma_table_25, // 1.450000 
    gamma_table_26, // 1.500000 
    gamma_table_27, // 1.600000 
    gamma_table_28, // 1.700000 
    gamma_table_29, // 1.800000 
    gamma_table_30, // 1.900000 
    gamma_table_31, // 2.000000 
    gamma_table_32, // 2.100000 
    gamma_table_33, // 2.200000 
    gamma_table_34, // 2.300000 
    gamma_table_35, // 2.400000 
    gamma_table_36, // 2.500000 
    gamma_table_37, // 2.600000 
    gamma_table_38, // 2.700000 
    gamma_table_39, // 2.800000 
    gamma_table_40, // 2.900000 
    gamma_table_41, // 3.000000 
    gamma_table_42, // 3.500000 
    gamma_table_43, // 4.000000 
    gamma_table_44, // 4.500000 
    gamma_table_45, // 5.000000 
    gamma_table_46, // 5.500000 
    gamma_table_47, // 6.000000 
    gamma_table_48, // 7.000000 
    gamma_table_49, // 8.000000 
    gamma_table_50, // 9.000000 
    gamma_table_51, // 10.000000 
    gamma_table_52, // 11.000000 
    gamma_table_53, // 12.000000 
    gamma_table_54, // 13.000000 
    gamma_table_55, // 14.000000 
    gamma_table_56, // 15.000000 
};


const double cr_gamma_levels[GAMMA_LEVELS] = {
    0.300000,
    0.350000,
    0.400000,
    0.450000,
    0.500000,
    0.550000,
    0.600000,
    0.650000,
    0.700000,
    0.750000,
    0.800000,
    0.850000,
    0.900000,
    0.950000,
    0.980000,
    1.000000,
    1.020000,
    1.050000,
    1.100000,
    1.150000,
    1.200000,
    1.250000,
    1.300000,
    1.350000,
    1.400000,
    1.450000,
    1.500000,
    1.600000,
    1.700000,
    1.800000,
    1.900000,
    2.000000,
    2.100000,
    2.200000,
    2.300000,
    2.400000,
    2.500000,
    2.600000,
    2.700000,
    2.800000,
    2.900000,
    3.000000,
    3.500000,
    4.000000,
    4.500000,
    5.000000,
    5.500000,
    6.000000,
    7.000000,
    8.000000,
    9.000000,
    10.000000,
    11.000000,
    12.000000,
    13.000000,
    14.000000,
    15.000000,
};

// corrects gamma for byte buffer; gamma_index must be 0..56 (15 means no correction)
void cr_correct_gamma_buf( unsigned char * buf, int size, int gamma_index ) {
    const unsigned char * table = cr_gamma_tables[gamma_index];
    for ( int i=0; i<size; i++ )
        buf[i] = table[buf[i]];
}

#endif
