; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -avr-shift-expand -S %s -o - | FileCheck %s

; The avr-shift-expand pass expands large shifts with a non-constant shift
; amount to a loop. These loops avoid generating a (non-existing) builtin such
; as __ashlsi3.

target datalayout = "e-P1-p:16:8-i8:8-i16:8-i32:8-i64:8-f32:8-f64:8-n8-a:8"
target triple = "avr"

define i16 @shl16(i16 %value, i16 %amount) addrspace(1) {
; CHECK-LABEL: @shl16(
; CHECK-NEXT:    [[RESULT:%.*]] = shl i16 [[VALUE:%.*]], [[AMOUNT:%.*]]
; CHECK-NEXT:    ret i16 [[RESULT]]
;
  %result = shl i16 %value, %amount
  ret i16 %result
}

define i32 @shl32(i32 %value, i32 %amount) addrspace(1) {
; CHECK-LABEL: @shl32(
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i32 [[AMOUNT:%.*]] to i8
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[TMP1]], 0
; CHECK-NEXT:    br i1 [[TMP2]], label [[SHIFT_DONE:%.*]], label [[SHIFT_LOOP:%.*]]
; CHECK:       shift.loop:
; CHECK-NEXT:    [[TMP3:%.*]] = phi i8 [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[SHIFT_LOOP]] ]
; CHECK-NEXT:    [[TMP4:%.*]] = phi i32 [ [[VALUE:%.*]], [[TMP0]] ], [ [[TMP6:%.*]], [[SHIFT_LOOP]] ]
; CHECK-NEXT:    [[TMP5]] = sub i8 [[TMP3]], 1
; CHECK-NEXT:    [[TMP6]] = shl i32 [[TMP4]], 1
; CHECK-NEXT:    [[TMP7:%.*]] = icmp eq i8 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[TMP7]], label [[SHIFT_DONE]], label [[SHIFT_LOOP]]
; CHECK:       shift.done:
; CHECK-NEXT:    [[TMP8:%.*]] = phi i32 [ [[VALUE]], [[TMP0]] ], [ [[TMP6]], [[SHIFT_LOOP]] ]
; CHECK-NEXT:    ret i32 [[TMP8]]
;
  %result = shl i32 %value, %amount
  ret i32 %result
}

define i40 @shl40(i40 %value, i40 %amount) addrspace(1) {
; CHECK-LABEL: @shl40(
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i40 [[AMOUNT:%.*]] to i8
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[TMP1]], 0
; CHECK-NEXT:    br i1 [[TMP2]], label [[SHIFT_DONE:%.*]], label [[SHIFT_LOOP:%.*]]
; CHECK:       shift.loop:
; CHECK-NEXT:    [[TMP3:%.*]] = phi i8 [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[SHIFT_LOOP]] ]
; CHECK-NEXT:    [[TMP4:%.*]] = phi i40 [ [[VALUE:%.*]], [[TMP0]] ], [ [[TMP6:%.*]], [[SHIFT_LOOP]] ]
; CHECK-NEXT:    [[TMP5]] = sub i8 [[TMP3]], 1
; CHECK-NEXT:    [[TMP6]] = shl i40 [[TMP4]], 1
; CHECK-NEXT:    [[TMP7:%.*]] = icmp eq i8 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[TMP7]], label [[SHIFT_DONE]], label [[SHIFT_LOOP]]
; CHECK:       shift.done:
; CHECK-NEXT:    [[TMP8:%.*]] = phi i40 [ [[VALUE]], [[TMP0]] ], [ [[TMP6]], [[SHIFT_LOOP]] ]
; CHECK-NEXT:    ret i40 [[TMP8]]
;
  %result = shl i40 %value, %amount
  ret i40 %result
}

; ------------------------------------------------------------------------------

define i16 @lshr16(i16 %value, i16 %amount) addrspace(1) {
; CHECK-LABEL: @lshr16(
; CHECK-NEXT:    [[RESULT:%.*]] = lshr i16 [[VALUE:%.*]], [[AMOUNT:%.*]]
; CHECK-NEXT:    ret i16 [[RESULT]]
;
  %result = lshr i16 %value, %amount
  ret i16 %result
}

define i32 @lshr32(i32 %value, i32 %amount) addrspace(1) {
; CHECK-LABEL: @lshr32(
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i32 [[AMOUNT:%.*]] to i8
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[TMP1]], 0
; CHECK-NEXT:    br i1 [[TMP2]], label [[SHIFT_DONE:%.*]], label [[SHIFT_LOOP:%.*]]
; CHECK:       shift.loop:
; CHECK-NEXT:    [[TMP3:%.*]] = phi i8 [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[SHIFT_LOOP]] ]
; CHECK-NEXT:    [[TMP4:%.*]] = phi i32 [ [[VALUE:%.*]], [[TMP0]] ], [ [[TMP6:%.*]], [[SHIFT_LOOP]] ]
; CHECK-NEXT:    [[TMP5]] = sub i8 [[TMP3]], 1
; CHECK-NEXT:    [[TMP6]] = lshr i32 [[TMP4]], 1
; CHECK-NEXT:    [[TMP7:%.*]] = icmp eq i8 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[TMP7]], label [[SHIFT_DONE]], label [[SHIFT_LOOP]]
; CHECK:       shift.done:
; CHECK-NEXT:    [[TMP8:%.*]] = phi i32 [ [[VALUE]], [[TMP0]] ], [ [[TMP6]], [[SHIFT_LOOP]] ]
; CHECK-NEXT:    ret i32 [[TMP8]]
;
  %result = lshr i32 %value, %amount
  ret i32 %result
}

define i40 @lshr40(i40 %value, i40 %amount) addrspace(1) {
; CHECK-LABEL: @lshr40(
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i40 [[AMOUNT:%.*]] to i8
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[TMP1]], 0
; CHECK-NEXT:    br i1 [[TMP2]], label [[SHIFT_DONE:%.*]], label [[SHIFT_LOOP:%.*]]
; CHECK:       shift.loop:
; CHECK-NEXT:    [[TMP3:%.*]] = phi i8 [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[SHIFT_LOOP]] ]
; CHECK-NEXT:    [[TMP4:%.*]] = phi i40 [ [[VALUE:%.*]], [[TMP0]] ], [ [[TMP6:%.*]], [[SHIFT_LOOP]] ]
; CHECK-NEXT:    [[TMP5]] = sub i8 [[TMP3]], 1
; CHECK-NEXT:    [[TMP6]] = lshr i40 [[TMP4]], 1
; CHECK-NEXT:    [[TMP7:%.*]] = icmp eq i8 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[TMP7]], label [[SHIFT_DONE]], label [[SHIFT_LOOP]]
; CHECK:       shift.done:
; CHECK-NEXT:    [[TMP8:%.*]] = phi i40 [ [[VALUE]], [[TMP0]] ], [ [[TMP6]], [[SHIFT_LOOP]] ]
; CHECK-NEXT:    ret i40 [[TMP8]]
;
  %result = lshr i40 %value, %amount
  ret i40 %result
}

; ------------------------------------------------------------------------------

define i16 @ashr16(i16 %value, i16 %amount) addrspace(1) {
; CHECK-LABEL: @ashr16(
; CHECK-NEXT:    [[RESULT:%.*]] = ashr i16 [[VALUE:%.*]], [[AMOUNT:%.*]]
; CHECK-NEXT:    ret i16 [[RESULT]]
;
  %result = ashr i16 %value, %amount
  ret i16 %result
}

define i32 @ashr32(i32 %value, i32 %amount) addrspace(1) {
; CHECK-LABEL: @ashr32(
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i32 [[AMOUNT:%.*]] to i8
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[TMP1]], 0
; CHECK-NEXT:    br i1 [[TMP2]], label [[SHIFT_DONE:%.*]], label [[SHIFT_LOOP:%.*]]
; CHECK:       shift.loop:
; CHECK-NEXT:    [[TMP3:%.*]] = phi i8 [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[SHIFT_LOOP]] ]
; CHECK-NEXT:    [[TMP4:%.*]] = phi i32 [ [[VALUE:%.*]], [[TMP0]] ], [ [[TMP6:%.*]], [[SHIFT_LOOP]] ]
; CHECK-NEXT:    [[TMP5]] = sub i8 [[TMP3]], 1
; CHECK-NEXT:    [[TMP6]] = ashr i32 [[TMP4]], 1
; CHECK-NEXT:    [[TMP7:%.*]] = icmp eq i8 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[TMP7]], label [[SHIFT_DONE]], label [[SHIFT_LOOP]]
; CHECK:       shift.done:
; CHECK-NEXT:    [[TMP8:%.*]] = phi i32 [ [[VALUE]], [[TMP0]] ], [ [[TMP6]], [[SHIFT_LOOP]] ]
; CHECK-NEXT:    ret i32 [[TMP8]]
;
  %result = ashr i32 %value, %amount
  ret i32 %result
}

define i40 @ashr40(i40 %value, i40 %amount) addrspace(1) {
; CHECK-LABEL: @ashr40(
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i40 [[AMOUNT:%.*]] to i8
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[TMP1]], 0
; CHECK-NEXT:    br i1 [[TMP2]], label [[SHIFT_DONE:%.*]], label [[SHIFT_LOOP:%.*]]
; CHECK:       shift.loop:
; CHECK-NEXT:    [[TMP3:%.*]] = phi i8 [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP5:%.*]], [[SHIFT_LOOP]] ]
; CHECK-NEXT:    [[TMP4:%.*]] = phi i40 [ [[VALUE:%.*]], [[TMP0]] ], [ [[TMP6:%.*]], [[SHIFT_LOOP]] ]
; CHECK-NEXT:    [[TMP5]] = sub i8 [[TMP3]], 1
; CHECK-NEXT:    [[TMP6]] = ashr i40 [[TMP4]], 1
; CHECK-NEXT:    [[TMP7:%.*]] = icmp eq i8 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[TMP7]], label [[SHIFT_DONE]], label [[SHIFT_LOOP]]
; CHECK:       shift.done:
; CHECK-NEXT:    [[TMP8:%.*]] = phi i40 [ [[VALUE]], [[TMP0]] ], [ [[TMP6]], [[SHIFT_LOOP]] ]
; CHECK-NEXT:    ret i40 [[TMP8]]
;
  %result = ashr i40 %value, %amount
  ret i40 %result
}
