if(CLANG_SCAN_DEPS)
    find_package(nlohmann_json REQUIRED)
endif()

if(BUILD_STATIC)
    find_package(ZLIB REQUIRED)
    # When statically linking against grpc++, it would appear
    # that providing -lgrpc++ is not enough. There are known issues
    # with this - one example is https://github.com/grpc/grpc/issues/15054.
    # Some experimentation revealed that including a "-L</path/to/other/grpc/libs -lgrpc"
    # rule allowed the linker to resolve all symbols and succeed.
    # To accomplish this, we use any one of the populated CMake variables
    # that provides the path and then set the
    # 'STATIC_GRPC_LINKER_RULE' to be used in downstream CMake code.
    if (NOT ${gRPC_LIBRARY_DIRS} STREQUAL "")
        set(STATIC_GRPC_LINKER_RULE "-L${gRPC_LIBRARY_DIRS} -lgrpc")
    elseif (NOT ${gRPC_LIBDIR} STREQUAL "")
        set(STATIC_GRPC_LINKER_RULE "-L${gRPC_LIBDIR} -lgrpc")
    endif()
endif()
