/*
 * Jalview - A Sequence Alignment Editor and Viewer (2.11.5.0)
 * Copyright (C) 2025 The Jalview Authors
 * 
 * This file is part of Jalview.
 * 
 * Jalview is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 *  
 * Jalview is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty 
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Jalview.  If not, see <http://www.gnu.org/licenses/>.
 * The Jalview Authors are detailed in the 'AUTHORS' file.
 */
package jalview.util;

import jalview.bin.Cache;

public class UserAgent
{
  private static String userAgentFormat = null;

  public static String getUserAgent(String className)
  {
    if (userAgentFormat == null)
    {
      StringBuilder sb = new StringBuilder();
      sb.append(ChannelProperties.getProperty("app_name"));
      if (Platform.isJS())
      {
        sb.append(" JS");
      }
      else
      {
        sb.append(" Desktop");
      }
      sb.append('/');
      sb.append(Cache.getDefault("VERSION", "Unknown"));
      sb.append(" (");
      sb.append(System.getProperty("os.name"));
      sb.append("; ");
      sb.append(System.getProperty("os.arch"));
      sb.append(' ');
      sb.append(System.getProperty("os.name"));
      sb.append(' ');
      sb.append(System.getProperty("os.version"));
      sb.append("; ");
      sb.append("java/");
      sb.append(System.getProperty("java.version"));
      sb.append("; ");
      sb.append("jalview/");
      sb.append(ChannelProperties.getProperty("channel"));
      sb.append("%s");
      String installation = Cache.applicationProperties
              .getProperty("INSTALLATION");
      if (installation != null)
      {
        sb.append("; ");
        sb.append(installation);
      }
      sb.append(')');
      sb.append(" help@jalview.org");

      userAgentFormat = sb.toString();
    }

    return String.format(userAgentFormat,
            className == null ? "" : "; " + className);
  }

  public static String getUserAgent()
  {
    return getUserAgent(null);
  }

}
