---
title: "1.0 Roadmap 🗺"
menu:
  main:
    parent: "contributing"
    identifier: "1.0-roadmap"
    weight: 4
toc: true
description: |-
  New year, new roadmap 🎉

  This document outlines some goals, non-goals, and future aspirations for kind
  as a project.
---
## Beta Requirements

To reach "beta" [grade][deprecation-policy] kind needs to at minimum:

- [x] Improve documentation (Though this will eternally be "In Progress" !)
  - [X] create a documentation site - [#268]
  - [x] expand examples of using kind (We can always use more, but we have more of this now)
  - [x] cover known issues, debugging, work-arounds, etc.
- [x] Reliably [pass][kind-conformance-dashboard] the Kubernetes [conformance tests]
 - [x] [Certify][certified] Conformance
- [x] Support multi-node clusters - [#117]
- [x] Support offline / air-gapped clusters
  - [x] pre-loaded / offline CNI - [#200]
- [x] Support mounting host directories - [#62]
- [x] Improve Windows support
  - [x] add Windows binaries to releases - [#155]
  - [x] improve instructions for KUBECONFIG in particular
- [ ] Support usage as a properly versioned, supported, and documented library. This includes following semver without every release being a major / breaking change to the API (which must be extensible without breakage), ensuring the CLI only uses a suitable public library surface, documentation and examples for the library, versioned types for public APIs (E.G. config format), etc.
  - TODO: what exactly do we want here? Should this really be beta blocking?
- [x] should be possible to troubleshoot kind without needing to modify kind ~or use external debugging tools~ (this should be possible now, if not perfect!)
  - [x] consistent logging (what is logged, when should it be logged, what levels are used) (this is consistent-ish now, if not perfect)
  - [x] errors have appropriate context (this is debatable and never perfect, but improved a lot, especially if you use `-v 1` or greater)
for managing clusters in test harnesses
- [x] move API types / labels from `*.k8s.io` into [`*.x-k8s.io`][api-review-voluntary]
- [x] Support all currently [upstream-supported Kubernetes versions][version-skew-policy]
- [ ] come up with a plan for stable node image <-> KIND compatibility

## GA Requirements

To reach "GA" [grade][deprecation-policy] kind needs to at minimum:

- [x] Support non-AMD64 architectures (namely ARM) - [#166]
- [ ] Automated publishing of Kubernetes release based kind "node" images - [#197]
- [x] Support for runtimes other than docker/default including podman, ignite etc.
- [x] First class support for skewed node (Kubernetes) versions (I believe this is relatively first-class now, things should work fine if you specify different node images)
- ... TBD, more will be added here ...

## Non-Goals

- Supporting every possible Kubernetes configuration
  - In order to best support offline / hermetic clusters, we will likely not
  offer many options for CNI etc. out of the box. We may revisit this later.
- Being "production workload ready" - kind is meant to be used:
  - for testing Kubernetes itself
  - for testing against Kubernetes (EG in CI on Travis, Circle, etc.)
  - for "local" clusters on developer machines
  - NOT to host workloads serving user traffic etc.
- Replacing [Phippy] 🦒 -- kind isn't trying to replace all the things
and Phippy is awesome ❤️

Longer Term goals include:

- Enabling a suitable local storage provider for testing applications that need
persistent storage

## Misc

- [x] setup a regular Zoom meeting for the project [#244]
- [x] achieve certified Kubernetes conformance [#245]

Other goals / tasks not listed here can be found both in [the 1.0 project] and
more generally triaged for rough-priority in the [GitHub issues].

[kind-conformance-dashboard]: https://testgrid.k8s.io/conformance-kind
[version-skew-policy]: https://kubernetes.io/docs/setup/release/version-skew-policy/
[deprecation-policy]: https://kubernetes.io/docs/reference/using-api/deprecation-policy/
[certified]: https://github.com/cncf/k8s-conformance/pull/451#issuecomment-457663982
[conformance tests]: https://github.com/cncf/k8s-conformance
[api-review-voluntary]: https://github.com/kubernetes/community/blob/master/sig-architecture/api-review-process.md#voluntary
[1.0]: https://github.com/kubernetes-sigs/kind/projects/1
[the 1.0 project]: https://github.com/kubernetes-sigs/kind/projects/1
[GitHub issues]: https://github.com/kubernetes-sigs/kind/issues
[#62]: https://github.com/kubernetes-sigs/kind/issues/62
[#117]: https://github.com/kubernetes-sigs/kind/issues/117
[#166]: https://github.com/kubernetes-sigs/kind/issues/166
[#155]: https://github.com/kubernetes-sigs/kind/issues/155
[#197]: https://github.com/kubernetes-sigs/kind/issues/197
[#200]: https://github.com/kubernetes-sigs/kind/issues/200
[#244]: https://github.com/kubernetes-sigs/kind/issues/244
[#245]: https://github.com/kubernetes-sigs/kind/issues/245
[#268]: https://github.com/kubernetes-sigs/kind/pull/268

[Phippy]: https://phippy.io/
