# TSIP FIT Module port

Support for TSIP FIT driver for symmetric AES, SHA1/SHA256 hardware acceleration
and TLS-linked capability including Root CA, the server certificate or
intermediate certificate verification.

## Overview
Renesas TSIP FIT module with wolfSSL by setting *WOLFSSL_RENESAS_TSIP* definition.

Including the following examples:

* simple tls_client/tls_server
* crypt test
* crypt benchmark

The *user_settings.h* file enables some of the hardened settings.

## Requirements

### 1. [Renesas TSIP FIT module](https://www.renesas.com/us/en/products/software-tools/software-os-middleware-driver/security-crypto/trusted-secure-ip-driver.html)
[FIT module](https://www.renesas.com/us/en/products/software-tools/software-os-middleware-driver/software-package/fit.html)
Note : The included example program is tested with <u>TSIP FIT version **1.06**</u>.

### 2. [e2studio](https://www.renesas.com/us/en/products/software-tools/tools/ide/e2studio.html)

### 3. Evaluation Board that supports TSIP
Note : The included example program is tested with [GR-ROSE](http://gadget.renesas.com/en/product/rose.html), which is classified to RX65N.

## Setup and Build wolfSSL library
1. Uncomment out `#define WOLFSSL_RENESAS_TSIP` in `/path/to/wolfssl/wolfssl/wolfcrypt/settings.h`
2. Uncomment out `#define WOLFSSL_RENESAS_RX65N` in `/path/to/wolfssl/wolfssl/wolfcrypt/settings.h`
3. Open a project file at /path/to/wolfssl/IDE/Renesas/e2studio/Projects/wolfssl/ by e2studio and build to create wolfssl library

Note : Generating FIT module source files in advance are required to compile wolfSSL
when enabling `WOLFSSL_RENESAS_TSIP` and `WOLFSSL_RENESAS_RX65N`. Please see for
creating FIT module files at "Setup and Build and example program" in this readme below.

To disable portions of the hardware acceleration you can optionally define:

```c
/* Disabled SHA acceleration */
#define NO_WOLFSSL_RENESAS_TSIP_CRYPT_HASH
/* Disabled TLS-linked acceleration */
#define NO_WOLFSSL_RENESAS_TSIP_TLS_SESSION
```

## Benchmarks

Platform:
Renesas   : e2Studio v7.4.0
ToolChain : Renesas CCRX version 3.00.00
TSIP FIT  : version 1.0.6
Board     : [GR-ROSE](http://gadget.renesas.com/en/product/rose.html)
wolfSSL   : 4.1.0

### Software only implementation:

*block cipher*
```
RNG                200 KB took 1.099 seconds,  182.000 KB/s
SHA                  1 MB took 1.005 seconds,    1.166 MB/s
SHA-256            425 KB took 1.038 seconds,  409.520 KB/s
```

*TLS establishment time*
```
TLS_RSA_WITH_AES_128_CBC_SHA          : 0.651 (s)
TLS_RSA_WITH_AES_128_CBC_SHA256       : 0.651 (s)
TLS_RSA_WITH_AES_256_CBC_SHA          : 0.642 (s)
TLS_RSA_WITH_AES_256_CBC_SHA256       : 0.662 (s)
TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256 : 2.050 (s)
```
### Hardware acceleration:

*block cipher*
```
RNG                  1 MB took 1.011 seconds,    1.038 MB/s
SHA                 12 MB took 1.001 seconds,   11.515 MB/s
SHA-256             13 MB took 1.001 seconds,   12.900 MB/s
```

*TLS establishment time with TLS-linked capability*
*Perform full TLS-linked capability*
```
TLS_RSA_WITH_AES_128_CBC_SHA          : 0.141 (s)
TLS_RSA_WITH_AES_128_CBC_SHA256       : 0.141 (s)
TLS_RSA_WITH_AES_256_CBC_SHA          : 0.141 (s)
TLS_RSA_WITH_AES_256_CBC_SHA256       : 0.144 (s)
```

*Perform certificate verification by TSIP TLS-linked API*
```
TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256 : 1.721 (s)
```

## Setup and Build an example program
An example program expects the following FIT modules:

* r_bsp
* r_cmt_rx
* r_config
* r_ether_rx
* r_sys_time_rx
* r_t4_driver_rx
* r_t4_rx
* r_tsip_rx

These needed source files can be generated by creating a dummy project including Renesas Smart Configurator as steps below:

1. Create a dummy project including Renesas Smart Configurator for your evaluation board type
2. Open Smart Configurator and add FIT modules above
   It would need to expand *User Stack Size* property and *Heap Size* of r_bsp.
   Change IP ADDRESS and PORT NUMBER in r_t4_rx_config.h
   `#define T4_CFG_FIXED_IP_ADDRESS_CH0   192,168,1,33`
   `#define T4_CFG_TCP_REPID1_PORT_NUMBER 11111`
   Note: It would need to modify other configuration base on evaluation board.

   When using GR-ROSE, you can choose "GR-ROSE" from "board" tab and "board" drop-down list and then is able to follow settings below:

   Go to component tab and open r_ether_rx properties:
   Ethernet interface : RMII
   The register bus of PHY0 for ETHER0/1: Use ETHER0
   Resource, ETHERC: Check ETHERC0_RMII

   Go to component tab and open r_t4_rx properties:
   Enable/Disable DHCP function : 0
   IP address for ch0, when DHCP disable : 192,168,1,33
   TCP REPID1 prot number : 11111

   Go to pins tab and select ethernet controller
   Check to use pins

3. Generate source code
Now, it is able to copy these FIT modules into an example project.
4. Make "smc_gen" folder under /path/to/wolfssl/IDE/Renesas/e2studio/Projects/test/src/
5. Copy the FIT modules into the folder that is created at step 4.
6. Open an example project file at /path/to/wolfssl/IDE/Renesas/e2studio/Projects/test/ by e2studio
7. Enable a macro definition in /path/to/wolfssl/IDE/Renesas/e2studio/Projects/test/src/wolfssl_demo.h for application type

```c
#define CRYPT_TEST     /* enable crypt test */
#define BENCHMARK      /* enable benchmark application */
#define TLS_CLIENT     /* enable simple tls client application */
#define TLS_SERVER     /* enable simple tls server application */
#define USE_TSIP_TLS   /* to inform user key and flash keying, when using TSIP */
```

   Note: CRYPT_TEST and BENCHMARK can be enabled at the same time. TLS_CLIENT and TLS_SERVER cannot be enabled together other definitions.
7. Setup debug configuration based on your debug hardware

## Run client/server program on the device
When testing the embedded client or server on the device, it is recommended to test against one
of the standard wolfSSL example application running on a desktop machine.


For the embedded client, an example server commands for running on a desktop machine, IP address 192.168.1.45, is as follows:
`./example/server/server -b -d -i`


For the embedded server, an example client commands for running on a desktop machine is as follows:
`./example/client/client -h 192.168.1.33 -p 11111`

## Modify an example program
To use own TSIP keys for TSIP TLS-linked API use, it needs own flash keyring, PSS signed signature and RSA key.

### Create flash keyring and use it in an example program
1. Please follow the instruction at TSIP manual, chapter 7. Key Data Operations.
2. Copy and paste s_flash[] data to s_flash[] data in example-program/key_data.c
`const uint32_t s_flash[] =`

### Create RSA key pair for signing Root CA verification and use them in an example program
To use TSIP TLS-linked APIs, it needs RSA key pair and Root CA certificate bundle signature by RSA 2048 PSS with SHA256.
Shell and Perl script program in /path/to/wolfssl/IDE/Renesas/e2studio/Projects/tools/ can be used for the purpose.

* `generate_rsa_keypair.sh`: generate RSA 2048 bit key pair. Show modulus and public exponent when specifying "-s" option
* `rsa_pss_sign.sh`: sign the file by the specified private key
* `genhexbuf.pl`: generate C header file including a byte array generated from the specified file in the script

Modulus and public exponent showed by `generate_rsa_keypair.sh` can be used for input date to
Renesas Secure Flash Programmer to generate encrypted RSA keys for TSIP TLS-linked API use.
Please follow the instruction about how to generate RSA keys in the TSIP manual.

Generated byte array of signed signature by `genhexbuf.pl` can be replaced signature data in key_data.c of an example program.

Encrypted RSA key and generated byte array of signed signature need to be informed wolfSSL library before loading CA certification.
Please see `SetTsipTlskey()` function an example program about how to inform them.

### Coding

In your application you must include <wolfssl/wolfcrypt/settings.h> before any other wolfSSL headers.
If building the sources directly we recommend defining `WOLFSSL_USER_SETTINGS` and adding your own `user_settings.h` file.
You can find a good reference for this in `/path/to/Renesas/e2studio/Projects/common/user_settings.h`.

## Support
For question please email [support@wolfssl.com]
