# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, Optional, TYPE_CHECKING, cast
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.settings import settings
from azure.mgmt.core import AsyncARMPipelineClient
from azure.mgmt.core.policies import AsyncARMAutoResourceProviderRegistrationPolicy
from azure.mgmt.core.tools import get_arm_endpoints

from .. import models as _models
from .._utils.serialization import Deserializer, Serializer
from ._configuration import PolicyInsightsClientConfiguration
from .operations import (
    AttestationsOperations,
    ComponentPolicyStatesOperations,
    Operations,
    PolicyEventsOperations,
    PolicyMetadataOperations,
    PolicyRestrictionsOperations,
    PolicyStatesOperations,
    PolicyTrackedResourcesOperations,
    RemediationsOperations,
)

if TYPE_CHECKING:
    from azure.core.credentials_async import AsyncTokenCredential


class PolicyInsightsClient:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """Query component policy states at varying resource scopes for Resource Provider mode policies.

    :ivar policy_tracked_resources: PolicyTrackedResourcesOperations operations
    :vartype policy_tracked_resources:
     azure.mgmt.policyinsights.aio.operations.PolicyTrackedResourcesOperations
    :ivar remediations: RemediationsOperations operations
    :vartype remediations: azure.mgmt.policyinsights.aio.operations.RemediationsOperations
    :ivar policy_events: PolicyEventsOperations operations
    :vartype policy_events: azure.mgmt.policyinsights.aio.operations.PolicyEventsOperations
    :ivar policy_states: PolicyStatesOperations operations
    :vartype policy_states: azure.mgmt.policyinsights.aio.operations.PolicyStatesOperations
    :ivar policy_metadata: PolicyMetadataOperations operations
    :vartype policy_metadata: azure.mgmt.policyinsights.aio.operations.PolicyMetadataOperations
    :ivar policy_restrictions: PolicyRestrictionsOperations operations
    :vartype policy_restrictions:
     azure.mgmt.policyinsights.aio.operations.PolicyRestrictionsOperations
    :ivar component_policy_states: ComponentPolicyStatesOperations operations
    :vartype component_policy_states:
     azure.mgmt.policyinsights.aio.operations.ComponentPolicyStatesOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.policyinsights.aio.operations.Operations
    :ivar attestations: AttestationsOperations operations
    :vartype attestations: azure.mgmt.policyinsights.aio.operations.AttestationsOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: Microsoft Azure subscription ID. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is None.
    :type base_url: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self, credential: "AsyncTokenCredential", subscription_id: str, base_url: Optional[str] = None, **kwargs: Any
    ) -> None:
        _cloud = kwargs.pop("cloud_setting", None) or settings.current.azure_cloud  # type: ignore
        _endpoints = get_arm_endpoints(_cloud)
        if not base_url:
            base_url = _endpoints["resource_manager"]
        credential_scopes = kwargs.pop("credential_scopes", _endpoints["credential_scopes"])
        self._config = PolicyInsightsClientConfiguration(
            credential=credential, subscription_id=subscription_id, credential_scopes=credential_scopes, **kwargs
        )

        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                AsyncARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: AsyncARMPipelineClient = AsyncARMPipelineClient(
            base_url=cast(str, base_url), policies=_policies, **kwargs
        )

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.policy_tracked_resources = PolicyTrackedResourcesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.remediations = RemediationsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.policy_events = PolicyEventsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.policy_states = PolicyStatesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.policy_metadata = PolicyMetadataOperations(self._client, self._config, self._serialize, self._deserialize)
        self.policy_restrictions = PolicyRestrictionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.component_policy_states = ComponentPolicyStatesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.attestations = AttestationsOperations(self._client, self._config, self._serialize, self._deserialize)

    def _send_request(
        self, request: HttpRequest, *, stream: bool = False, **kwargs: Any
    ) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> Self:
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details: Any) -> None:
        await self._client.__aexit__(*exc_details)
