# Data Models

Data models are used to strongly type and verify API request and response structure. All
API calls require a data model to be passed in as a parameter. Each module in the `pyvesync.models` module is for a specific product type or API call.

The dataclasses inherit from mashumaro's `DataClassORJSONMixin` which allows for easy serialization and deserialization of the data models, as well as providing a discrimintor for subclasses.

The `bypassv2_models` module is a generic mixin for the bypassv2 API calls.

- [Data Models](#data-models)
  - [Data Models Module](#data-models-module)
  - [Base Models](#base-models)
  - [BypassV2 Models](#bypassv2-models)
  - [VeSync General API Models](#vesync-general-api-models)
  - [Bulb Models](#bulb-models)
  - [Fan Models](#fan-models)
  - [Humidifier Models](#humidifier-models)
  - [Outlet Models](#outlet-models)
  - [Purifier Models](#purifier-models)
  - [Switch Models](#switch-models)
  - [Fryer Models](#fryer-models)
  - [Thermostat Models](#thermostat-models)

## Data Models Module

::: pyvesync.models
    options:
        members: false
        heading_level: 3
        show_root_heading: false
        show_root_toc_entry: false

## Base Models

::: pyvesync.models.base_models
    options:
        show_signature_annotations: true
        heading_level: 3
        show_submodules: false
        signature_crossrefs: true
        show_root_heading: false
        show_category_heading: true
        show_root_toc_entry: true
        inherited_members: false
        show_source: true
        filters:
        - "!Config"
        - "!^__.*"
        - "!^_.*"
        - "!IntFlag"
        - "!StrFlag"
        - "!RGB"
        - "!Color"
        - "!HSV"

## BypassV2 Models

::: pyvesync.models.bypass_models
    options:
        show_signature_annotations: true
        show_submodules: false
        heading_level: 3
        signature_crossrefs: true
        show_root_heading: false
        show_category_heading: true
        show_root_toc_entry: true
        inherited_members: false
        show_source: true
        filters:
        - "!Config"
        - "!^__.*"
        - "!^_.*"
        - "!IntFlag"
        - "!StrFlag"
        - "!RGB"
        - "!Color"
        - "!HSV"

## VeSync General API Models

::: pyvesync.models.vesync_models
    options:
        show_signature_annotations: true
        show_submodules: false
        heading_level: 3
        signature_crossrefs: true
        show_root_heading: false
        show_category_heading: true
        show_root_toc_entry: true
        inherited_members: false
        show_source: true
        filters:
        - "!Config"
        - "!^__.*"
        - "!^_.*"
        - "!IntFlag"
        - "!StrFlag"
        - "!RGB"
        - "!Color"
        - "!HSV"

## Bulb Models

::: pyvesync.models.bulb_models
    options:
        show_signature_annotations: true
        show_submodules: false
        signature_crossrefs: true
        show_root_heading: false
        heading_level: 3
        show_category_heading: true
        show_root_toc_entry: true
        inherited_members: false
        show_source: true
        filters:
        - "!Config"
        - "!^__.*"
        - "!^_.*"
        - "!IntFlag"
        - "!StrFlag"
        - "!RGB"
        - "!Color"
        - "!HSV"

## Fan Models

::: pyvesync.models.fan_models
    options:
        show_signature_annotations: true
        show_submodules: false
        signature_crossrefs: true
        heading_level: 3
        show_root_heading: false
        show_category_heading: true
        show_root_toc_entry: true
        inherited_members: false
        show_source: true
        filters:
        - "!Config"
        - "!^__.*"
        - "!^_.*"
        - "!IntFlag"
        - "!StrFlag"
        - "!RGB"
        - "!Color"
        - "!HSV"

## Humidifier Models

::: pyvesync.models.humidifier_models
    options:
        show_signature_annotations: true
        show_submodules: false
        signature_crossrefs: true
        heading_level: 3
        show_root_heading: false
        show_category_heading: true
        show_root_toc_entry: true
        inherited_members: false
        show_source: true
        filters:
        - "!Config"
        - "!^__.*"
        - "!^_.*"
        - "!IntFlag"
        - "!StrFlag"
        - "!RGB"
        - "!Color"
        - "!HSV"

## Outlet Models

::: pyvesync.models.outlet_models
    options:
        show_signature_annotations: true
        show_submodules: false
        heading_level: 3
        signature_crossrefs: true
        show_root_heading: false
        show_category_heading: true
        show_root_toc_entry: true
        inherited_members: false
        show_source: true
        filters:
        - "!Config"
        - "!^__.*"
        - "!^_.*"
        - "!IntFlag"
        - "!StrFlag"
        - "!RGB"
        - "!Color"
        - "!HSV"

## Purifier Models

::: pyvesync.models.purifier_models
    options:
        show_signature_annotations: true
        show_submodules: false
        heading_level: 3
        signature_crossrefs: true
        show_root_heading: false
        show_category_heading: true
        show_root_toc_entry: true
        inherited_members: false
        show_source: true
        filters:
        - "!Config"
        - "!^__.*"
        - "!^_.*"
        - "!IntFlag"
        - "!StrFlag"
        - "!RGB"
        - "!Color"
        - "!HSV"

## Switch Models

::: pyvesync.models.switch_models
    options:
        show_signature_annotations: true
        show_submodules: false
        heading_level: 3
        signature_crossrefs: true
        show_root_heading: false
        show_category_heading: true
        show_root_toc_entry: true
        inherited_members: false
        show_source: true
        filters:
        - "!Config"
        - "!^__.*"
        - "!^_.*"
        - "!IntFlag"
        - "!StrFlag"
        - "!RGB"
        - "!Color"
        - "!HSV"

## Fryer Models

::: pyvesync.models.fryer_models
    options:
        show_signature_annotations: true
        show_submodules: false
        heading_level: 3
        signature_crossrefs: true
        show_root_heading: false
        show_category_heading: true
        show_root_toc_entry: true
        inherited_members: false
        show_source: true
        filters:
        - "!Config"
        - "!^__.*"
        - "!^_.*"
        - "!IntFlag"
        - "!StrFlag"
        - "!RGB"
        - "!Color"
        - "!HSV"

## Thermostat Models

::: pyvesync.models.thermostat_models
    options:
        show_signature_annotations: true
        show_submodules: false
        heading_level: 3
        signature_crossrefs: true
        show_root_heading: false
        show_category_heading: true
        show_root_toc_entry: true
        inherited_members: false
        show_source: true
        filters:
        - "!Config"
        - "!^__.*"
        - "!^_.*"
        - "!IntFlag"
        - "!StrFlag"
        - "!RGB"
        - "!Color"
        - "!HSV"
