% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_robust.R
\name{vcovCR.lm_robust}
\alias{vcovCR.lm_robust}
\title{Cluster-robust variance-covariance matrix for an \code{estimatr::lm_robust}
object.}
\usage{
\method{vcovCR}{lm_robust}(
  obj,
  cluster,
  type,
  target = NULL,
  inverse_var = NULL,
  form = "sandwich",
  ...
)
}
\arguments{
\item{obj}{Fitted model for which to calculate the variance-covariance matrix}

\item{cluster}{Expression or vector indicating which observations belong to
the same cluster. If not specified, will be detected from the
\code{clusters} argument of \code{obj}.}

\item{type}{Character string specifying which small-sample adjustment should
be used, with available options \code{"CR0"}, \code{"CR1"}, \code{"CR1p"},
\code{"CR1S"}, \code{"CR2"}, or \code{"CR3"}. If not specified, will be
detected from the \code{se_type} argument of \code{obj}. See "Details"
section of \code{\link{vcovCR}} for further information.}

\item{target}{Optional matrix or vector describing the working
variance-covariance model used to calculate the \code{CR2} and \code{CR4}
adjustment matrices. If a vector, the target matrix is assumed to be
diagonal. If not specified, the target is taken to be an identity matrix.}

\item{inverse_var}{Optional logical indicating whether the weights used in 
fitting the model are inverse-variance. If not specified, \code{vcovCR} 
will attempt to infer a value.}

\item{form}{Controls the form of the returned matrix. The default 
\code{"sandwich"} will return the sandwich variance-covariance matrix. 
Alternately, setting \code{form = "meat"} will return only the meat of the 
sandwich and setting \code{form = B}, where \code{B} is a matrix of 
appropriate dimension, will return the sandwich variance-covariance matrix 
calculated using \code{B} as the bread. \code{form = "estfun"} will return the 
(appropriately scaled) estimating function, the transposed crossproduct of 
which is equal to the sandwich variance-covariance matrix.}

\item{...}{Additional arguments available for some classes of objects.}
}
\value{
An object of class \code{c("vcovCR","clubSandwich")}, which consists
  of a matrix of the estimated variance of and covariances between the
  regression coefficient estimates.
}
\description{
\code{vcovCR} returns a sandwich estimate of the variance-covariance matrix
of a set of regression coefficient estimates from an
\code{\link[estimatr]{lm_robust}} object.
}
\examples{

data("ChickWeight", package = "datasets")
ChickWeight$Chick <- factor(ChickWeight$Chick, ordered = FALSE)

if (requireNamespace("estimatr", quietly = TRUE)) withAutoprint({
  library(estimatr)

  lm_fit <- lm_robust(
    weight ~ Time + Diet:Time,
    data = ChickWeight
   )
  vcovCR(lm_fit, cluster = ChickWeight$Chick, type = "CR2")

  lm_fit_clust <- lm_robust(
    weight ~ Time + Diet:Time, data = ChickWeight,
    clusters = Chick
   )
  conf_int(lm_fit_clust, vcov = "CR2")

  # similar model via lm_lin()
  lin_fit_clust <- lm_lin(
    weight ~ Diet, 
    covariates = ~ Time,
    data = ChickWeight,
    clusters = Chick
  )
  conf_int(lin_fit_clust, vcov = "CR2")
  
  lm_fit_fe <- lm_robust(
    weight ~ Time:Diet, data = ChickWeight,
    clusters = Chick,
    fixed_effects = ~ Chick
   )
  vcovCR(lm_fit_fe)
  
  # two-way fixed effects model
  data("MortalityRates")
  MortalityRates <- subset(MortalityRates, cause == "Motor Vehicle")
  MortalityRates$state <- factor(MortalityRates$state)
  MortalityRates$year <- factor(MortalityRates$year)
  MLDA_fit <- lm_robust(
    mrate ~ legal + beertaxa + beerpercap + winepercap + spiritpercap,
    fixed_effects = ~ year + state,
    data = MortalityRates,
    cluster = state
  )
  conf_int(MLDA_fit, vcov = "CR2")

  if (requireNamespace("plm", quietly = TRUE)) withAutoprint({

    data("Produc", package = "plm")
    lm_individual <- lm_robust(
      log(gsp) ~ log(pcap) + log(pc) + log(emp) + unemp,
      data = Produc,
      fixed_effects = ~ state,
      cluster = state
     )
    vcovCR(lm_individual, type = "CR2")

  })

})

}
\seealso{
\code{\link{vcovCR}}
}
