---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, pages, en-tête, page blanche, bas de page
---

# Comment supprimer les en-têtes et bas de page de pages vierges ?

Les classes <ctanpkg:book> (par défaut) et <ctanpkg:report> (avec l'option de classe 
`openright`) garantissent que chaque chapitre commence sur une page de droite (recto). 
Elles obtiennent ce résultat en insérant une commande `\cleardoublepage` 
entre les chapitres (plutôt qu'un simple `\clearpage`). 
La page vide ainsi créée présente un en-tête et un pied de page comme les autres pages, 
ce que certaines personnes n'apprécient pas.

Pour corriger cela, si vous utilisez les classes standards, vous devez prendre 
des mesures spéciales. Quant aux classes <ctanpkg:memoir> 
et [KOMA-Script](ctanpkg:Koma-Script), elles fournissent leurs propres méthodes 
pour traiter ce point.


## Avec les commandes de base, pour les classes standards

La [documentation](texdoc:fancyhdr) de l'extension <ctanpkg:fancyhdr> évoque ce problème, 
conseillant essentiellement la création d'une commande `\clearemptydoublepage` :

```{noedit}
\let\origdoublepage\cleardoublepage % Copie de la commande originale
\newcommand{\clearemptydoublepage}{% Création de notre commande
  \clearpage
  {\pagestyle{empty}\origdoublepage}%
  }
```

La suite logique est d'utiliser la commande ainsi obtenue en remplacement 
de `\cleardoublepage` dans une version corrigée de la commande `\chapitre` 
(vous pouvez même créer votre propre extension contenant une copie de la commande 
hors de la classe). Cette méthode n'est pas particulièrement difficile 
mais vous pouvez plus simplement écraser la définition de `\cleardoublepage` 
(qui n'est pas souvent utilisé par ailleurs) :

```{noedit}
\let\cleardoublepage\clearemptydoublepage
```

Notez que cette commande fonctionne car `\clearemptydoublepage` utilise 
une copie de `\cleardoublepage` : la question traitant des 
[patchs de commandes](/2_programmation/macros/patcher_une_commande_existante) 
explique ce type de méthode.

Voici un exemple illustrant l'action de cette commande (sur la deuxième page) :

::::{tab-set}

:::{tab-item} Sans redéfinition
```
\documentclass[french]{book}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)

\begin{document}
\tableofcontents
\chapter[Philéas Fogg et Passepartout]{Dans lequel Phileas Fogg et Passepartout 
s’acceptent réciproquement, l’un comme maître, l’autre comme domestique.}

\newpage
En l’année 1872, la maison portant le numéro 7 de Saville-row, Burlington 
Gardens, --- maison dans laquelle Shéridan mourut en 1814, --- était habitée 
par Phileas Fogg, esq., l’un des membres les plus singuliers et les plus 
remarqués du Reform-Club de Londres, bien qu’il semblât prendre à tâche 
de ne rien faire qui pût a`tirer l’attention.
\end{document}
```
:::

:::{tab-item} Avec redéfinition

```
\documentclass[french]{book}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)

  \let\origdoublepage\cleardoublepage
  \newcommand{\clearemptydoublepage}{%
    \clearpage
    {\pagestyle{empty}\origdoublepage}%
    }
  \let\cleardoublepage\clearemptydoublepage

\begin{document}
\tableofcontents
\chapter[Philéas Fogg et Passepartout]{Dans lequel Phileas Fogg et Passepartout 
s’acceptent réciproquement, l’un comme maître, l’autre comme domestique.}

\newpage
En l’année 1872, la maison portant le numéro 7 de Saville-row, Burlington 
Gardens, --- maison dans laquelle Shéridan mourut en 1814, --- était habitée 
par Phileas Fogg, esq., l’un des membres les plus singuliers et les plus 
remarqués du Reform-Club de Londres, bien qu’il semblât prendre à tâche 
de ne rien faire qui pût attirer l’attention.
\end{document}
```
:::

::::


## Avec l'extension <ctanpkg:emptypage>

L'extension <ctanpkg:emptypage> fait automatiquement le réglage indiqué ci-dessus.

```
\documentclass[french]{book}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{emptypage}

\begin{document}
\tableofcontents
\chapter[Philéas Fogg et Passepartout]{Dans lequel Phileas Fogg et Passepartout 
s’acceptent réciproquement, l’un comme maître, l’autre comme domestique.}

\newpage
En l’année 1872, la maison portant le numéro 7 de Saville-row, Burlington 
Gardens, --- maison dans laquelle Shéridan mourut en 1814, --- était habitée 
par Phileas Fogg, esq., l’un des membres les plus singuliers et les plus 
remarqués du Reform-Club de Londres, bien qu’il semblât prendre à tâche 
de ne rien faire qui pût a`tirer l’attention.
\end{document}
```


## Avec les classes [KOMA-Script](ctanpkg:koma-script)

Les classes [KOMA-Script](ctanpkg:koma-script) <ctanpkg:scrbook> et <ctanpkg:scrreprt> 
(qui remplacent respectivement <ctanpkg:book> et <ctanpkg:report>) 
proposent des options de classe qui contrôlent l'apparence de ces pages vides : 
`cleardoubleempty`, `cleardoubleplain` et `cleardoublestandard` 
(cette dernière utilisant alors le style de page en cours d'exécution). 
Les classes proposent également des commandes à modifier soi-même `\cleardoubleempty` (etc.).


## Avec la classe <ctanpkg:memoir>

La classe <ctanpkg:memoir> (et l'extension <ctanpkg:nextpage>) 
fournissent les commandes `\cleartooddpage` et `\cleartoevenpage`, 
qui prennent toutes deux un argument optionnel permettant d'obtenir 
des effets particuliers (sans argument, la première est équivalente 
à `\cleardoublepage`). La commande `\clearemptydoublepage` que nous recherchons 
serait réalisée par `\cleartooddpage[\thispagestyle{empty}]`. Les commandes serviront 
également si vous voulez avoir une mention "Page laissée vierge intentionnellement" 
au centre d'une page autrement vide.


## Avec l'extension [schulzrinne](https://www.ctan.org/tex-archive/macros/latex209/contrib/schulzrinne)

:::{warning}
L’extension [schulzrinne](https://www.ctan.org/tex-archive/macros/latex209/contrib/schulzrinne) 
est classée comme [obsolète](/1_generalites/histoire/liste_des_packages_obsoletes), 
car associée à LaTeX 2.09. Ce qui suit est informatif. 
:::

L'extension [schulzrinne](https://www.ctan.org/tex-archive/macros/latex209/contrib/schulzrinne), 
légèrement modifiée en l'extension 
[whitecdp](https://www.ctan.org/tex-archive/documentation/epslatex/french/#whitecdp.sty) 
lors de travaux de traduction en français, redéfinit la commande `\cleardoublepage` 
pour que les pages insérées soient vides autrement dit sans en-tête ni bas de page.

:::{sources}
[Really blank pages between chapters](faquk:FAQ-reallyblank)
:::