// @HEADER
// *****************************************************************************
//                           MiniTensor Package
//
// Copyright 2016 NTESS and the MiniTensor contributors.
// SPDX-License-Identifier: BSD-3-Clause
// *****************************************************************************
// @HEADER

#ifndef MINITENSOR_DOXYGEN_DOCUMENTATION_HPP
#define MINITENSOR_DOXYGEN_DOCUMENTATION_HPP

/*!

\mainpage

\section minitensor_index Table of Contents

- \ref minitensor_overview
- \ref minitensor_copyright
- \ref minitensor_questions

\section minitensor_overview MiniTensor Overview

MiniTensor is a library for the use, manipulation, algebra and optimization of small vectors and tensors and problems that depend on them.
Its purpose is to provide a compact representation of vector and tensor expressions.
Its emphasis is on ease of use, and accurate algorithms, specifically those used for the development of constitutive models in finite deformation solid mechanics.
More information can be found at https://trilinos.org/packages/minitensor.

\section minitensor_copyright Copyright and License

\verbinclude COPYRIGHT_AND_LICENSE

\section minitensor_questions For All Questions and Comments...

   Please contact the authors listed in the License above,
   or open an issue in the Trilinos GitHub repository (https://github.com/trilinos/Trilinos).

*/

/* ************************************************************************ */
/* ************************************************************************ */

#endif //ifndef MINITENSOR_DOXYGEN_DOCUMENTATION_HPP
