/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

class ChemInputCanvas
extends Canvas
implements MouseWheelListener,
MouseListener,
MouseMotionListener,
KeyListener {
    public String[] ForbiddenKeysChars = new String[]{"!", "~", "`", "@", "#", "$", "%", "&", "|", "\\", "=", "/", "{", "}"};
    public int[] ForbiddenKeys = new int[]{16, 17, 18, 20, 27, 39, 112, 113, 114, 115, 116, 117, 118, 119, 120};
    public String[] AcceptedChars = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "(", ")"};
    public static int position = 1;
    public int marked = -1;
    public int newsize = ChemInputApplet.fontsize;
    public static int y0;
    public static FontMetrics fm;
    public static FontMetrics sfm;
    public static Font f;
    public static Font sf;
    public static int fh;
    boolean editing = false;
    Color pencolor = ChemInputApplet.pencolor;
    Color bgcolor1 = ChemInputApplet.bgcolor1;
    Color bgcolor2 = ChemInputApplet.bgcolor2;
    Color bgcolor3 = ChemInputApplet.bgcolor3;

    ChemInputCanvas() {
        this.setBackground(ChemInputApplet.bgcolor1);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
    }

    @Override
    public synchronized void paint(Graphics graphics) {
        int n;
        int n2;
        f = new Font("TimesRoman", 1, this.newsize);
        sf = new Font("TimesRoman", 1, this.newsize - 6);
        fm = graphics.getFontMetrics(f);
        sfm = graphics.getFontMetrics(sf);
        fh = fm.getHeight();
        if (!ChemInputApplet.once) {
            this.AppletText2Array(ChemInputApplet.applettext);
            ChemInputApplet.once = true;
        }
        int n3 = this.getSize().width;
        int n4 = this.getSize().height;
        y0 = n4 / 2;
        graphics.clearRect(0, 0, n3, n4);
        int n5 = 0;
        int n6 = this.getSize().width;
        if (this.marked != -1) {
            position = ChemInputApplet.CharPosition[this.marked];
        }
        if (position == 2) {
            n2 = y0 - fh;
            n = fh / 2;
        } else if (position == 0) {
            n2 = y0;
            n = fh / 2;
        } else {
            n2 = y0 - fh / 2;
            n = fh / 2;
        }
        if (this.editing) {
            graphics.setColor(this.bgcolor2);
            graphics.fillRect(n5, n2, n6, n);
        }
        graphics.setColor(this.pencolor);
        int n7 = 0;
        for (int i = 0; i < ChemInputApplet.index; ++i) {
            if (ChemInputApplet.CharArray[i] == null) continue;
            if (i == this.marked) {
                graphics.setColor(Color.red);
                graphics.setFont(f);
                graphics.drawString("_", n7, n2 + fh);
            } else if (ChemInputApplet.CharArray[i].equals("?")) {
                graphics.setColor(Color.red);
            } else {
                graphics.setColor(this.pencolor);
            }
            if (ChemInputApplet.CharPosition[i] == 1) {
                graphics.setFont(f);
                graphics.drawString(ChemInputApplet.CharArray[i], n7, y0);
            } else if (ChemInputApplet.CharPosition[i] == 0) {
                graphics.setFont(sf);
                graphics.drawString(ChemInputApplet.CharArray[i], n7, y0 + fh / 2);
            } else if (ChemInputApplet.CharPosition[i] == 2) {
                graphics.setFont(sf);
                graphics.drawString(ChemInputApplet.CharArray[i], n7, y0 - fh / 2);
            }
            n7 += ChemInputApplet.CharWidth[i];
            if (i != ChemInputApplet.index - 1 || this.marked != -1) continue;
            graphics.setColor(Color.red);
            graphics.setFont(f);
            graphics.drawString("_", n7, n2 + fh / 2);
        }
    }

    public void update() {
        if (ChemInputApplet.index > ChemInputApplet.max_chars - 4) {
            ChemInputApplet.index = ChemInputApplet.max_chars - 4;
        }
        this.repaint();
    }

    public void clear() {
        position = 1;
        this.marked = -1;
        ChemInputApplet.once = false;
        ChemInputApplet.CharArray = new String[ChemInputApplet.max_chars];
        ChemInputApplet.CharPosition = new int[ChemInputApplet.max_chars];
        ChemInputApplet.CharWidth = new int[ChemInputApplet.max_chars];
        this.update();
        ChemInputApplet.index = 0;
    }

    public void SwitchFont(int n) {
        this.newsize += n;
        this.update();
    }

    public void AppletText2Array(String string) {
        ChemInputApplet.once = true;
        if (string.length() != 0) {
            int n;
            string = ChemInputApplet.replace(string, " ", "");
            string = ChemInputApplet.replace(string, "{", "");
            string = ChemInputApplet.replace(string, "\\rightarrow", "\u21c4");
            string = ChemInputApplet.replace(string, "\\leftrightarrow", "\u2192");
            string = ChemInputApplet.replace(string, "\\downarrow", "\u2193");
            for (n = 0; n < string.length(); ++n) {
                if (string.charAt(n) == '^') {
                    ++n;
                    while (string.charAt(n) != '}' && n < string.length()) {
                        ChemInputApplet.CharArray[n] = Character.toString(string.charAt(n));
                        ChemInputApplet.CharPosition[n] = 2;
                        ChemInputApplet.CharWidth[n] = sfm.charWidth(string.charAt(n));
                        ++n;
                    }
                    continue;
                }
                if (string.charAt(n) == '_') {
                    ++n;
                    while (string.charAt(n) != '}' && n < string.length()) {
                        ChemInputApplet.CharArray[n] = Character.toString(string.charAt(n));
                        ChemInputApplet.CharPosition[n] = 0;
                        ChemInputApplet.CharWidth[n] = sfm.charWidth(string.charAt(n));
                        ++n;
                    }
                    continue;
                }
                ChemInputApplet.CharArray[n] = Character.toString(string.charAt(n));
                ChemInputApplet.CharPosition[n] = 1;
                ChemInputApplet.CharWidth[n] = fm.charWidth(string.charAt(n));
            }
            this.marked = -1;
            position = 1;
            ChemInputApplet.index = n;
        }
    }

    @Override
    public synchronized void mousePressed(MouseEvent mouseEvent) {
        this.marked = -1;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = 1;
        if (n2 > y0 - 2 * fh && n2 < y0 + 2 * fh) {
            if (n2 < y0 + fh && n2 > y0 + fh / 4) {
                n3 = 0;
            } else if (n2 > y0 - 2 * fh && n2 < y0 - fh / 4) {
                n3 = 2;
            }
            int n4 = 0;
            for (int i = 0; i < ChemInputApplet.index; ++i) {
                if (n > n4 && n < n4 + ChemInputApplet.CharWidth[i]) {
                    this.marked = i;
                    position = n3 != 1 ? n3 : ChemInputApplet.CharPosition[i];
                    if (mouseEvent.getButton() == 3) {
                        this.DeleteMarkedChar(this.marked);
                    }
                    this.repaint();
                }
                n4 += ChemInputApplet.CharWidth[i];
            }
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        position = this.NewPosition(-1 * mouseWheelEvent.getWheelRotation(), position);
        if (this.marked != -1) {
            ChemInputApplet.CharPosition[this.marked] = position;
        }
        this.update();
    }

    @Override
    public synchronized void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public synchronized void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.editing = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.editing = false;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (ChemInputApplet.index < ChemInputApplet.max_chars - 4) {
            int n = keyEvent.getKeyCode();
            String string = Character.toString(keyEvent.getKeyChar());
            if (this.marked == -1) {
                this.ProcessKey(string, n);
            } else {
                this.ProcessMarkedKey(string, n);
            }
            this.repaint();
        } else {
            ChemInputApplet.index = 0;
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public void AppendKey(String string, int n) {
        ChemInputApplet.CharPosition[ChemInputApplet.index] = n;
        ChemInputApplet.CharArray[ChemInputApplet.index] = string;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (n == 0 || n == 2) {
                n2 += sfm.charWidth(string.charAt(i));
                continue;
            }
            n2 += fm.charWidth(string.charAt(i));
        }
        ChemInputApplet.CharWidth[ChemInputApplet.index] = n == 0 || n == 2 ? n2 : n2;
        ++ChemInputApplet.index;
    }

    public void InsertKey(String string, int n, boolean bl) {
        if (this.marked != -1) {
            for (int i = ++ChemInputApplet.index; i > this.marked; --i) {
                ChemInputApplet.CharArray[i] = ChemInputApplet.CharArray[i - 1];
                ChemInputApplet.CharPosition[i] = ChemInputApplet.CharPosition[i - 1];
                ChemInputApplet.CharWidth[i] = ChemInputApplet.CharWidth[i - 1];
            }
            ChemInputApplet.CharArray[this.marked] = string;
            ChemInputApplet.CharPosition[this.marked] = position;
            ChemInputApplet.CharWidth[this.marked] = position == 0 || position == 2 ? sfm.charWidth(string.charAt(0)) : fm.charWidth(string.charAt(0));
            ++this.marked;
        }
        if (bl) {
            this.update();
        }
    }

    public void ProcessMarkedKey(String string, int n) {
        if (n == 37) {
            this.LeftRightMarked(-1, false);
        } else if (n == 39) {
            if (this.marked == ChemInputApplet.index - 1) {
                this.marked = -1;
            } else {
                this.LeftRightMarked(1, false);
            }
        } else if (n == 38 || n == 33) {
            this.UpDownMarked(1, false);
        } else if (n == 40 || n == 34) {
            this.UpDownMarked(-1, false);
        } else if (n == 10 || n == 27) {
            this.marked = -1;
        }
        if ((n == 8 || n == 127) && ChemInputApplet.index > 0) {
            this.DeleteMarkedChar(this.marked);
            position = 1;
            --this.marked;
        } else if ((n == 8 || n == 127) && ChemInputApplet.index == 0) {
            position = 1;
            this.marked = -1;
            ChemInputApplet.CharArray[0] = null;
            ChemInputApplet.CharPosition[0] = 1;
            ChemInputApplet.CharWidth[0] = 0;
        } else {
            boolean bl = false;
            for (int i = 0; i < this.AcceptedChars.length; ++i) {
                if (!this.AcceptedChars[i].equals(string) && (n <= 64 || n >= 91) && n != 45 && n != 61) continue;
                bl = true;
            }
            if (bl) {
                this.InsertKey(string, position, false);
            }
        }
    }

    public void AppendSymbol(String string, int n) {
        if (this.marked != -1) {
            this.InsertKey(string, n, false);
            this.marked = -1;
        } else {
            this.AppendKey(string, n);
        }
        this.update();
    }

    public void UpDownMarked(int n, boolean bl) {
        int n2 = this.NewPosition(n, position);
        if (n2 != position) {
            ChemInputApplet.CharPosition[this.marked] = position = n2;
        }
        if (bl) {
            this.update();
        }
    }

    public void LeftRightMarked(int n, boolean bl) {
        for (int i = 0; i < ChemInputApplet.index; ++i) {
            if (i != this.marked) continue;
            if (n == 1) {
                if (i >= ChemInputApplet.index - 1) continue;
                this.marked = ++i;
                continue;
            }
            if (i <= 0) continue;
            this.marked = i - 1;
        }
        if (bl) {
            this.update();
        }
    }

    public void ProcessKey(String string, int n) {
        int n2;
        boolean bl = true;
        for (n2 = 0; n2 < this.ForbiddenKeysChars.length; ++n2) {
            if (!string.equals(this.ForbiddenKeysChars[n2]) || !bl) continue;
            bl = false;
        }
        for (n2 = 0; n2 < this.ForbiddenKeys.length; ++n2) {
            if (n != this.ForbiddenKeys[n2] || !bl) continue;
            bl = false;
        }
        if (bl) {
            if (n == 33) {
                position = this.NewPosition(1, position);
            } else if (n == 34) {
                position = this.NewPosition(-1, position);
            } else if (n == 36) {
                this.marked = 0;
            } else if (n == 37) {
                this.marked = ChemInputApplet.index - 1;
            } else if (n == 35) {
                this.marked = ChemInputApplet.index - 1;
            } else if ((n == 127 || n == 8) && ChemInputApplet.index > 0) {
                ChemInputApplet.CharArray[--ChemInputApplet.index] = null;
                ChemInputApplet.CharPosition[ChemInputApplet.index] = 1;
                ChemInputApplet.CharWidth[ChemInputApplet.index] = 0;
                position = ChemInputApplet.CharPosition[ChemInputApplet.index];
            } else if ((n == 127 || n == 8) && ChemInputApplet.index == 0) {
                position = 1;
                this.marked = -1;
                ChemInputApplet.CharArray[0] = null;
                ChemInputApplet.CharPosition[0] = 1;
                ChemInputApplet.CharWidth[0] = 0;
            } else if (n == 38 || n == 94) {
                position = this.NewPosition(1, position);
            } else if (n == 40 || n == 95) {
                position = this.NewPosition(-1, position);
            } else {
                ChemInputApplet.CharArray[ChemInputApplet.index] = string;
                ChemInputApplet.CharPosition[ChemInputApplet.index] = position;
                ChemInputApplet.CharWidth[ChemInputApplet.index] = position == 0 || position == 2 ? sfm.charWidth(string.charAt(0)) : fm.charWidth(string.charAt(0));
                ++ChemInputApplet.index;
            }
        }
    }

    public int NewPosition(int n, int n2) {
        int n3 = n2 + n;
        if (n3 > 2) {
            n3 = 2;
        } else if (n3 < 0) {
            n3 = 0;
        }
        return n3;
    }

    public void DeleteMarkedChar(int n) {
        int n2 = 0;
        for (int i = ChemInputApplet.index - 1; i >= 0; --i) {
            if (i != n) continue;
            ChemInputApplet.CharArray = this.DeleteStringItem(ChemInputApplet.CharArray, i);
            ChemInputApplet.CharPosition = this.DeleteIntItem(ChemInputApplet.CharPosition, i);
            ChemInputApplet.CharWidth = this.DeleteIntItem(ChemInputApplet.CharWidth, i);
            ChemInputApplet.CharArray[ChemInputApplet.index - n2] = null;
            ++n2;
        }
        ChemInputApplet.index -= n2;
    }

    public int[] DeleteIntItem(int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < nArray.length - 1; ++i) {
            if (i < n) continue;
            n2 = i + 1;
            nArray[i] = nArray[n2];
        }
        return nArray;
    }

    public String[] DeleteStringItem(String[] stringArray, int n) {
        int n2 = 0;
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (i < n) continue;
            n2 = i + 1;
            stringArray[i] = stringArray[n2];
        }
        return stringArray;
    }

    public void ShowHelp() {
        System.out.println("laat helptext zien");
    }

    public static String MakeText() {
        int n;
        String string = "";
        for (n = 0; n < ChemInputApplet.max_chars; ++n) {
            if (ChemInputApplet.CharArray[n] == null) continue;
            if (ChemInputApplet.CharPosition[n] == 1) {
                string = string + ChemInputApplet.CharArray[n];
                continue;
            }
            if (ChemInputApplet.CharPosition[n] == 2) {
                string = string + "^";
                while (ChemInputApplet.CharPosition[n] == 2 && ChemInputApplet.CharArray[n] != null) {
                    string = string + ChemInputApplet.CharArray[n];
                    ++n;
                }
                string = string + " ";
                --n;
                continue;
            }
            if (ChemInputApplet.CharPosition[n] != 0) continue;
            while (ChemInputApplet.CharPosition[n] == 0 && ChemInputApplet.CharArray[n] != null) {
                string = string + ChemInputApplet.CharArray[n];
                ++n;
            }
            string = string + " ";
            --n;
        }
        for (n = 1; n < 10; ++n) {
            string = ChemInputApplet.replace(string, "0" + n, "O" + n);
        }
        return string;
    }

    public static String MakeLaTeX() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < ChemInputApplet.max_chars; ++i) {
            if (ChemInputApplet.CharArray[i] == null) continue;
            if (ChemInputApplet.CharPosition[i] == 1) {
                stringBuffer.append(ChemInputApplet.CharArray[i]);
                continue;
            }
            if (ChemInputApplet.CharPosition[i] == 2) {
                stringBuffer.append("^{");
                while (ChemInputApplet.CharPosition[i] == 2 && ChemInputApplet.CharArray[i] != null) {
                    stringBuffer.append(ChemInputApplet.CharArray[i]);
                    ++i;
                }
                --i;
                stringBuffer.append("}");
                continue;
            }
            if (ChemInputApplet.CharPosition[i] != 0) continue;
            stringBuffer.append("_{");
            while (ChemInputApplet.CharPosition[i] == 0 && ChemInputApplet.CharArray[i] != null) {
                stringBuffer.append(ChemInputApplet.CharArray[i]);
                ++i;
            }
            --i;
            stringBuffer.append("}");
        }
        return stringBuffer.toString();
    }

    public static String MakeHtml() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < ChemInputApplet.max_chars; ++i) {
            if (ChemInputApplet.CharArray[i] == null) continue;
            if (ChemInputApplet.CharPosition[i] == 1) {
                stringBuffer.append(ChemInputApplet.CharArray[i]);
                continue;
            }
            if (ChemInputApplet.CharPosition[i] == 2) {
                stringBuffer.append("<sup><font size=\"-1\">");
                while (ChemInputApplet.CharPosition[i] == 2 && ChemInputApplet.CharArray[i] != null) {
                    stringBuffer.append(ChemInputApplet.CharArray[i]);
                    ++i;
                }
                --i;
                stringBuffer.append("</font></sup>");
                continue;
            }
            if (ChemInputApplet.CharPosition[i] != 0) continue;
            stringBuffer.append("<sub><font size=\"-1\">");
            while (ChemInputApplet.CharPosition[i] == 0 && ChemInputApplet.CharArray[i] != null) {
                stringBuffer.append(ChemInputApplet.CharArray[i]);
                ++i;
            }
            --i;
            stringBuffer.append("</font></sub>");
        }
        return stringBuffer.toString();
    }
}

