/*
 * Decompiled with CFR 0.152.
 */
package spin.demo.complex;

import java.io.File;
import java.io.FileFilter;
import spin.demo.Assert;
import spin.demo.complex.Directory;
import spin.demo.complex.DirectoryService;
import spin.demo.complex.DirectoryServiceException;

public class FileService
implements DirectoryService {
    private File root;
    private FileFilter filter;

    public FileService() {
        this(new File("./"));
    }

    public FileService(String root) {
        this(new File(root));
    }

    public FileService(File root) {
        this(root, new AllFileFilter());
    }

    public FileService(File root, FileFilter filter) {
        this.root = root;
        this.filter = filter;
    }

    public Directory getRoot() {
        Assert.offEDT();
        return new FileDirectory(this.root, true);
    }

    public Directory[] getChildren(Directory directory) throws DirectoryServiceException {
        Assert.offEDT();
        File file = ((FileDirectory)directory).file;
        File[] files = file.listFiles(this.filter);
        Directory[] directories = new Directory[files.length];
        for (int f = 0; f < files.length; ++f) {
            directories[f] = new FileDirectory(files[f], false);
        }
        return directories;
    }

    private static class AllFileFilter
    implements FileFilter {
        private AllFileFilter() {
        }

        public boolean accept(File file) {
            return true;
        }
    }

    private class FileDirectory
    extends Directory {
        private File file;

        public FileDirectory(File file, boolean root) {
            super(root ? file.getAbsolutePath() : file.getName(), !file.isDirectory());
            this.file = file;
        }
    }
}

