/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.feedback;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class Zipper {
    private static final Logger LOGGER = Logger.getLogger(Zipper.class.getPackage().getName());
    private File source;
    List<String> relativePaths;
    private ZipOutputStream zipOutputStream;
    private Set<String> includePatterns = new HashSet<String>();
    private Set<String> excludePatterns = new HashSet<String>();
    private EditableProperties currentProperties;
    private static final List<String> IGNORED_FOLDERS = Arrays.asList("var/cache");

    public Zipper(File source) {
        this.source = source;
    }

    void doExport(File targetZipFile) {
        try {
            Zipper.ensureParent(targetZipFile);
            this.zipOutputStream = new ZipOutputStream(new FileOutputStream(targetZipFile));
            this.copyFiles();
            Zipper.createProductInfo(this.zipOutputStream);
            this.zipOutputStream.close();
        }
        catch (IOException ex) {
            Exceptions.attachLocalizedMessage((Throwable)ex, (String)NbBundle.getMessage(Zipper.class, (String)"OptionsExportModel.export.zip.error", (Object)targetZipFile));
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (this.zipOutputStream != null) {
                try {
                    this.zipOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static Set<String> parsePattern(String pattern) {
        HashSet<String> patterns = new HashSet<String>();
        if (pattern.contains("#")) {
            StringBuilder partPattern = new StringBuilder();
            ParserState state = ParserState.START;
            int blockLevel = 0;
            block6: for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                switch (state) {
                    case START: {
                        if (c == '#') {
                            state = ParserState.IN_KEY_PATTERN;
                            partPattern.append(c);
                            continue block6;
                        }
                        if (c == '(') {
                            state = ParserState.IN_BLOCK;
                            ++blockLevel;
                            partPattern.append(c);
                            continue block6;
                        }
                        if (c == '|') {
                            patterns.add(partPattern.toString());
                            partPattern = new StringBuilder();
                            continue block6;
                        }
                        partPattern.append(c);
                        continue block6;
                    }
                    case IN_KEY_PATTERN: {
                        if (c == '#') {
                            state = ParserState.AFTER_KEY_PATTERN;
                            continue block6;
                        }
                        partPattern.append(c);
                        continue block6;
                    }
                    case AFTER_KEY_PATTERN: {
                        if (c == '|') {
                            state = ParserState.START;
                            patterns.add(partPattern.toString());
                            partPattern = new StringBuilder();
                            continue block6;
                        }
                        assert (false) : "Wrong OptionsExport pattern " + pattern + ". Only format like filePattern1#keyPattern#|filePattern2 is supported.";
                        continue block6;
                    }
                    case IN_BLOCK: {
                        partPattern.append(c);
                        if (c != ')' || --blockLevel != 0) continue block6;
                        state = ParserState.START;
                    }
                }
            }
            patterns.add(partPattern.toString());
        } else {
            patterns.add(pattern);
        }
        return patterns;
    }

    public void addIncludePatterns(String include) {
        if (this.includePatterns == null) {
            this.includePatterns = new HashSet<String>();
        }
        this.includePatterns.addAll(Zipper.parsePattern(include));
    }

    public void addExcludePatterns(String exclude) {
        if (this.excludePatterns == null) {
            this.excludePatterns = new HashSet<String>();
        }
        this.excludePatterns.addAll(Zipper.parsePattern(exclude));
    }

    public String toString() {
        return this.getClass().getName() + " source=" + this.source;
    }

    private void copyFiles() throws IOException {
        if (this.source.isDirectory()) {
            this.copyFolder(this.source);
        } else {
            this.copyFile(Zipper.getRelativePath(this.source, this.source));
        }
    }

    private void copyFolder(File file) throws IOException {
        String relativePath = Zipper.getRelativePath(this.source, file);
        if (IGNORED_FOLDERS.contains(relativePath)) {
            return;
        }
        File[] children = file.listFiles();
        if (children == null || children.length == 0) {
            this.copyFile(Zipper.getRelativePath(this.source, file));
            return;
        }
        for (File child : children) {
            if (child.isDirectory()) {
                this.copyFolder(child);
                continue;
            }
            this.copyFile(Zipper.getRelativePath(this.source, child));
        }
    }

    static List<String> getRelativePaths(File sourceRoot) {
        return Zipper.getRelativePaths(sourceRoot, sourceRoot);
    }

    private static List<String> getRelativePaths(File root, File file) {
        String relativePath = Zipper.getRelativePath(root, file);
        ArrayList<String> result = new ArrayList<String>();
        if (file.isDirectory()) {
            if (IGNORED_FOLDERS.contains(relativePath)) {
                return result;
            }
            File[] children = file.listFiles();
            if (children == null) {
                return Collections.emptyList();
            }
            for (File child : children) {
                result.addAll(Zipper.getRelativePaths(root, child));
            }
        } else {
            result.add(relativePath);
        }
        return result;
    }

    private static String getRelativePath(File root, File file) {
        String result = file.getAbsolutePath().substring(root.getAbsolutePath().length());
        if ((result = result.replace('\\', '/')).startsWith("/") && !result.startsWith("//")) {
            result = result.substring(1);
        }
        return result;
    }

    private Set<String> matchingKeys(String relativePath, String propertiesPattern) throws IOException {
        HashSet<String> matchingKeys = new HashSet<String>();
        String[] patterns = propertiesPattern.split("#", 2);
        String filePattern = patterns[0];
        String keyPattern = patterns[1];
        if (relativePath.matches(filePattern)) {
            if (this.currentProperties == null) {
                this.currentProperties = this.getProperties(relativePath);
            }
            for (String key : this.currentProperties.keySet()) {
                if (!key.matches(keyPattern)) continue;
                matchingKeys.add(key);
            }
        }
        return matchingKeys;
    }

    private void copyFile(String relativePath) throws IOException {
        this.currentProperties = null;
        boolean includeFile = false;
        HashSet<String> includeKeys = new HashSet<String>();
        HashSet<String> excludeKeys = new HashSet<String>();
        for (String pattern : this.includePatterns) {
            if (pattern.contains("#")) {
                includeKeys.addAll(this.matchingKeys(relativePath, pattern));
                continue;
            }
            if (!relativePath.matches(pattern)) continue;
            includeFile = true;
            includeKeys.clear();
            break;
        }
        if (includeFile || !includeKeys.isEmpty()) {
            for (String pattern : this.excludePatterns) {
                if (pattern.contains("#")) {
                    excludeKeys.addAll(this.matchingKeys(relativePath, pattern));
                    continue;
                }
                if (!relativePath.matches(pattern)) continue;
                includeFile = false;
                includeKeys.clear();
                break;
            }
        }
        LOGGER.log(Level.FINEST, "{0}, includeFile={1}, includeKeys={2}, excludeKeys={3}", new Object[]{relativePath, includeFile, includeKeys, excludeKeys});
        if (!includeFile && includeKeys.isEmpty()) {
            return;
        }
        if (this.zipOutputStream != null) {
            LOGGER.log(Level.FINE, "Adding to zip: {0}", relativePath);
            if (new File(this.source, relativePath).isFile()) {
                this.zipOutputStream.putNextEntry(new ZipEntry(relativePath));
                this.copyFileOrProperties(relativePath, includeKeys, excludeKeys, this.zipOutputStream);
            } else {
                this.zipOutputStream.putNextEntry(new ZipEntry(relativePath + "/.empty"));
            }
            this.zipOutputStream.closeEntry();
        }
    }

    private void copyFileOrProperties(String relativePath, Set<String> includeKeys, Set<String> excludeKeys, OutputStream out) throws IOException {
        if (includeKeys.isEmpty() && excludeKeys.isEmpty()) {
            this.copyFile(relativePath, out);
        } else {
            if (!includeKeys.isEmpty()) {
                this.currentProperties.keySet().retainAll(includeKeys);
            }
            this.currentProperties.keySet().removeAll(excludeKeys);
            LOGGER.log(Level.FINE, "  Only keys: {0}", this.currentProperties.keySet());
            this.currentProperties.store(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EditableProperties getProperties(String relativePath) throws IOException {
        EditableProperties properties = new EditableProperties(false);
        try (InputStream in = null;){
            in = this.getInputStream(relativePath);
            properties.load(in);
        }
        return properties;
    }

    private InputStream getInputStream(String relativePath) throws IOException {
        if (this.source.isFile()) {
            ZipFile zipFile = new ZipFile(this.source);
            ZipEntry zipEntry = zipFile.getEntry(relativePath);
            return zipFile.getInputStream(zipEntry);
        }
        return new FileInputStream(new File(this.source, relativePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String relativePath, OutputStream out) throws IOException {
        try (InputStream in = null;){
            in = this.getInputStream(relativePath);
            FileUtil.copy((InputStream)in, (OutputStream)out);
        }
    }

    private static void ensureParent(File file) throws IOException {
        File parent = file.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Cannot create folder: " + parent.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createZipFile(File targetFile, File sourceDir, List<String> relativePaths) throws IOException {
        Zipper.ensureParent(targetFile);
        try (ZipOutputStream out = null;){
            out = new ZipOutputStream(new FileOutputStream(targetFile));
            for (String relativePath : relativePaths) {
                LOGGER.finest("Adding to zip: " + relativePath);
                out.putNextEntry(new ZipEntry(relativePath));
                try (FileInputStream in = null;){
                    in = new FileInputStream(new File(sourceDir, relativePath));
                    FileUtil.copy((InputStream)in, (OutputStream)out);
                }
                out.closeEntry();
            }
            Zipper.createProductInfo(out);
            out.close();
        }
    }

    private static void createProductInfo(ZipOutputStream out) throws IOException {
        String productVersion = MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.core.startup.Bundle").getString("currentVersion"), System.getProperty("netbeans.buildnumber"));
        String os = System.getProperty("os.name", "unknown") + ", " + System.getProperty("os.version", "unknown") + ", " + System.getProperty("os.arch", "unknown");
        String java = System.getProperty("java.version", "unknown") + ", " + System.getProperty("java.vm.name", "unknown") + ", " + System.getProperty("java.vm.version", "");
        out.putNextEntry(new ZipEntry("build.info"));
        PrintWriter writer = new PrintWriter(out);
        writer.println("ProductVersion=" + productVersion);
        writer.println("OS=" + os);
        writer.println("Java=" + java);
        writer.println("Userdir=" + System.getProperty("netbeans.user"));
        writer.flush();
        out.closeEntry();
    }

    private static enum ParserState {
        START,
        IN_KEY_PATTERN,
        AFTER_KEY_PATTERN,
        IN_BLOCK;

    }
}

