/*
 * Decompiled with CFR 0.152.
 */
package ancestris.gedcom;

import ancestris.gedcom.GedcomDirectory;
import ancestris.util.AUtilities;
import genj.gedcom.Context;
import genj.gedcom.Property;
import java.util.List;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;

public class PropertyNode
extends AbstractNode {
    private final InstanceContent lookupContents;
    private Property property;

    public static Children getChildren(Context context) {
        return new PropertyChildren(context);
    }

    public PropertyNode(Context context) {
        this(context, new InstanceContent());
        this.property = null;
        if (context.getProperty() != null) {
            this.property = context.getProperty();
        } else if (context.getEntity() != null) {
            this.property = context.getEntity();
        }
        if (this.property == null) {
            return;
        }
        this.lookupContents.add((Object)this.property);
        this.lookupContents.add((Object)context);
    }

    private PropertyNode(Context context, InstanceContent ic) {
        super(Children.LEAF, PropertyNode.createLookup(context, ic));
        this.lookupContents = ic;
    }

    private static Lookup createLookup(Context context, InstanceContent ic) {
        try {
            return new ProxyLookup(new Lookup[]{new AbstractLookup((AbstractLookup.Content)ic), GedcomDirectory.getDefault().getDataObject(context).getLookup()});
        }
        catch (GedcomDirectory.ContextNotFoundException ex) {
            System.err.println("Quiet exception : temporary loss of context in PropertyNode.createLookup(). Continue with null Lookup.");
            return null;
        }
        catch (Throwable ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return new AbstractLookup((AbstractLookup.Content)ic);
        }
    }

    public Node.PropertySet[] getPropertySets() {
        return super.getPropertySets();
    }

    public Property getProperty() {
        return this.property;
    }

    public Action[] getActions(boolean context) {
        List<Action> myActions = AUtilities.actionsForPath("Ancestris/Actions/GedcomProperty");
        return myActions.toArray(new Action[myActions.size()]);
    }

    private static class PropertyChildren
    extends Children.Keys {
        private Context context;

        public PropertyChildren(Context context) {
            this.context = context;
        }

        protected void addNotify() {
            if (!this.context.getProperties().isEmpty()) {
                this.setKeys(this.context.getProperties());
            } else if (!this.context.getEntities().isEmpty()) {
                this.setKeys(this.context.getEntities());
            }
        }

        protected Node[] createNodes(Object key) {
            Property prop = (Property)key;
            return new Node[]{new PropertyNode(new Context(prop))};
        }
    }
}

