/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Fam;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertyChoiceFamilyPedigree;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyXRef;
import genj.gedcom.values.EnumOperations;
import genj.gedcom.values.PediEnum;
import java.util.List;

public class PropertyFamilyChild
extends PropertyXRef {
    PropertyFamilyChild() {
        this("FAMC");
    }

    PropertyFamilyChild(String tag) {
        super(tag);
        this.assertTag("FAMC");
    }

    public Boolean isBiological() {
        String parent = this.getParent().getTag();
        if ("ADOP".equals(parent)) {
            return Boolean.FALSE;
        }
        if ("BIRT".equals(parent)) {
            return Boolean.TRUE;
        }
        Property pedi = this.getProperty("PEDI");
        if (pedi != null) {
            if (pedi instanceof PropertyChoiceFamilyPedigree) {
                PropertyChoiceFamilyPedigree propertyChoiceFamilyPedigree = (PropertyChoiceFamilyPedigree)pedi;
                return propertyChoiceFamilyPedigree.isBiological();
            }
            String value = this.getGedcom5Code(pedi.getValue());
            if ("BIRTH".equals(value)) {
                return Boolean.TRUE;
            }
            if ("ADOPTED".equals(value)) {
                return Boolean.FALSE;
            }
            if ("FOSTER".equals(value)) {
                return Boolean.FALSE;
            }
            if ("SEALING".equals(value)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private String getGedcom5Code(String value) {
        for (PediEnum pedi : PediEnum.values()) {
            String currentValue = EnumOperations.getDisplayValue(pedi, "PEDI");
            if (currentValue == null || !currentValue.equals(value)) continue;
            return pedi.name();
        }
        switch (value) {
            case "birth": {
                return PediEnum.BIRTH.name();
            }
            case "adopted": {
                return PediEnum.ADOPTED.name();
            }
            case "foster": {
                return PediEnum.FOSTER.name();
            }
            case "sealing": {
                return PediEnum.SEALING.name();
            }
        }
        return "OTHER";
    }

    @Override
    protected String getForeignDisplayValue() {
        Property adop = this.getParent();
        if (adop instanceof PropertyEvent && adop.getTag().equals("ADOP")) {
            return resources.getString("foreign.ADOP", this.getEntity().toString());
        }
        return super.getForeignDisplayValue();
    }

    public Fam getFamily() {
        return this.getTargetEntity().orElse(null);
    }

    @Override
    public void link() throws GedcomException {
        Indi indi;
        try {
            indi = (Indi)this.getEntity();
        }
        catch (ClassCastException ex) {
            throw new GedcomException(resources.getString("error.noenclosingindi"));
        }
        Fam fam = (Fam)this.getCandidate();
        if (indi.isAncestorOf(fam)) {
            throw new GedcomException(resources.getString("error.already.ancestor", indi.toString(), fam.toString()));
        }
        List<PropertyChild> childs = fam.getProperties(PropertyChild.class);
        for (PropertyChild prop : childs) {
            if (!prop.isCandidate(indi)) continue;
            this.link(prop);
            return;
        }
        PropertyChild xref = new PropertyChild();
        fam.addProperty(xref);
        this.link(xref);
    }

    @Override
    public String getTargetType() {
        return "FAM";
    }
}

