/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Property;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertyNumericValue
extends Property {
    private final Class<?> box = Integer.class;
    protected Object value = "";

    public PropertyNumericValue(String tag) {
        super(tag);
    }

    @Override
    public String getValue() {
        return this.value.toString();
    }

    @Override
    public void setValue(String set) {
        String old = this.getValue();
        try {
            this.value = (Comparable)this.box.getConstructor(String.class).newInstance(set);
        }
        catch (Throwable t) {
            this.value = set;
        }
        this.propagatePropertyChanged(this, old);
    }

    protected Object extractNumberObject() {
        Pattern numberPattern = Pattern.compile("-?\\d+");
        Matcher m = numberPattern.matcher(this.getValue());
        if (m.find()) {
            BigInteger number = new BigInteger(m.group());
            return number;
        }
        return this.value;
    }

    @Override
    public int compareTo(Property other) {
        PropertyNumericValue that = (PropertyNumericValue)other;
        if (that.value.getClass() != this.value.getClass()) {
            return this.getValue().compareTo(other.toString());
        }
        return ((Comparable)this.extractNumberObject()).compareTo((Comparable)that.extractNumberObject());
    }
}

